/*
 * Decompiled with CFR 0.152.
 */
package data.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class FrontShieldGenerator
extends BaseHullMod {
    public static final float SHIELD_ARC = 90.0f;
    public static final float SPEED_MULT = 0.8f;

    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        ShieldAPI shield = ship.getShield();
        if (shield == null) {
            ship.setShield(ShieldAPI.ShieldType.FRONT, 0.5f, 1.2f, 90.0f);
        }
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getMaxSpeed().modifyMult(id, 0.8f);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "90";
        }
        if (index == 1) {
            return "" + Math.round(19.999998f) + "%";
        }
        return null;
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (ship != null && (ship.getHullSpec().getDefenseType() == ShieldAPI.ShieldType.FRONT || ship.getHullSpec().getDefenseType() == ShieldAPI.ShieldType.OMNI)) {
            return "\u8be5\u8230\u8239\u5df2\u7ecf\u62e5\u6709\u62a4\u76fe";
        }
        if (ship != null && ship.getHullSpec().getDefenseType() != ShieldAPI.ShieldType.NONE && ship.getPhaseCloak() != null) {
            return "\u4e0d\u517c\u5bb9\u4e8e " + ship.getPhaseCloak().getDisplayName();
        }
        if (ship != null && ship.getVariant().getHullMods().contains("ExigencyBeamArmor")) {
            return "\u4e0e\u9759\u7535\u88c5\u7532\u51b2\u7a81";
        }
        if (ship != null && ship.getVariant().getHullMods().contains("tem_latticeshield")) {
            return "\u4e0e\u6676\u683c\u77e9\u9635\u62a4\u76fe\u51b2\u7a81";
        }
        if (ship != null && ship.getVariant().getHullMods().contains("shieldbypass")) {
            return "\u4e0e\u7981\u7528\u62a4\u76fe\u51b2\u7a81";
        }
        return null;
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        return ship != null && ship.getHullSpec().getDefenseType() == ShieldAPI.ShieldType.NONE && !ship.getVariant().getHullMods().contains("ExigencyRegen") && !ship.getVariant().getHullMods().contains("tem_latticeshield") && !ship.getVariant().getHullMods().contains("shieldbypass");
    }
}

