/*
 * Decompiled with CFR 0.152.
 */
package data.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class FrontShieldEmitter
extends BaseHullMod {
    public static final float ARC_BONUS = 100.0f;
    public static final float UPKEEP_BONUS = 25.0f;

    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        ShieldAPI shield = ship.getShield();
        if (shield != null) {
            shield.setType(ShieldAPI.ShieldType.FRONT);
        }
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getShieldArcBonus().modifyPercent(id, 100.0f);
        stats.getShieldUpkeepMult().modifyMult(id, 0.75f);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "100";
        }
        if (index == 1) {
            return "25";
        }
        return null;
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (ship == null || ship.getShield() == null || ship.getVariant().getHullMods().contains("shieldbypass")) {
            return "\u8be5\u8230\u8239\u6ca1\u6709\u5b89\u88c5\u62a4\u76fe";
        }
        if (ship.getHullSpec().getDefenseType() == ShieldAPI.ShieldType.FRONT) {
            return "\u8be5\u8230\u8239\u5df2\u7ecf\u62e5\u6709\u524d\u76fe";
        }
        if (ship.getVariant().getHullMods().contains("adaptiveshields")) {
            return "\u4e0e\u5168\u89d2\u62a4\u76fe\u53d1\u751f\u5668\u51b2\u7a81";
        }
        return null;
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        return ship != null && ship.getShield() != null && (ship.getHullSpec().getDefenseType() == ShieldAPI.ShieldType.OMNI || ship.getHullSpec().getDefenseType() == ShieldAPI.ShieldType.FRONT && ship.getVariant().getHullMods().contains("adaptiveshields")) && !ship.getVariant().getHullMods().contains("shieldbypass");
    }
}

