/*
 * Decompiled with CFR 0.152.
 */
package data.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import java.util.HashMap;
import java.util.Map;

public class ConvertedHangar
extends BaseHullMod {
    public static final int CREW_REQ = 20;
    private static final Map<ShipAPI.HullSize, Float> mag = new HashMap<ShipAPI.HullSize, Float>(4);

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getFighterRefitTimeMult().modifyPercent(id, mag.get(hullSize).floatValue());
        stats.getNumFighterBays().modifyFlat(id, 1.0f);
        stats.getMinCrewMod().modifyFlat(id, 20.0f);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "" + mag.get(ShipAPI.HullSize.DESTROYER).intValue() + "%";
        }
        if (index == 1) {
            return "" + mag.get(ShipAPI.HullSize.CRUISER).intValue() + "%";
        }
        if (index == 2) {
            return "" + mag.get(ShipAPI.HullSize.CAPITAL_SHIP).intValue() + "%";
        }
        if (index == 3) {
            return "20";
        }
        return null;
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (ship != null && ship.isFrigate()) {
            return "\u4e0d\u80fd\u5b89\u88c5\u5728\u62a4\u536b\u8230\u4e0a";
        }
        if (ship != null && ship.getHullSpec().getFighterBays() > 0) {
            return "\u8be5\u8230\u5df2\u62e5\u6709\u6807\u51c6\u98de\u884c\u7532\u677f";
        }
        if (ship != null && ship.getVariant().hasHullMod("diableavionics_cramped")) {
            return "\u4e0d\u80fd\u5b89\u88c5\u5728\u72ed\u7a84\u8239\u4f53\u4e0a";
        }
        if (ship != null && ship.getVariant().hasHullMod("swp_arcade")) {
            return "\u4e0d\u80fd\u5b89\u88c5\u5728\u592a\u9633\u795e-\u7ea7\u4e0a";
        }
        return "\u4e0d\u80fd\u5b89\u88c5\u5728\u76f8\u4f4d\u8230\u4e0a";
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        return ship != null && !ship.isFrigate() && ship.getHullSpec().getFighterBays() <= 0 && !ship.getVariant().hasHullMod("phasefield") && !ship.getVariant().hasHullMod("swp_arcade") && !ship.getVariant().getHullMods().contains("diableavionics_cramped");
    }

    static {
        mag.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(0.0f));
        mag.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(75.0f));
        mag.put(ShipAPI.HullSize.CRUISER, Float.valueOf(50.0f));
        mag.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(25.0f));
    }
}

