/*
 * Decompiled with CFR 0.152.
 */
package data.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class ArmoredWeapons
extends BaseHullMod {
    public static final float ARMOR_BONUS = 10.0f;
    public static final float HEALTH_BONUS = 100.0f;
    public static final float TURN_PENALTY = 25.0f;

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getArmorBonus().modifyPercent(id, 10.0f);
        stats.getWeaponHealthBonus().modifyPercent(id, 100.0f);
        stats.getWeaponTurnRateBonus().modifyMult(id, 0.75f);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "100";
        }
        if (index == 1) {
            return "25";
        }
        if (index == 2) {
            return "10";
        }
        return null;
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (ship != null && ship.getVariant().getHullMods().contains("brimaginosregen")) {
            return "\u4e0e\u7eb3\u7c73\u6676\u683c\u88c5\u7532\u51b2\u7a81";
        }
        if (ship != null && ship.getVariant().getHullMods().contains("ii_conduits")) {
            return "\u4e0e\u5e1d\u56fd HFR \u7ba1\u9053\u51b2\u7a81";
        }
        return null;
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        return ship != null && !ship.getVariant().getHullMods().contains("brimaginosregen") && !ship.getVariant().getHullMods().contains("ii_conduits");
    }
}

