/*
 * Decompiled with CFR 0.152.
 */
package data.console.commands;

import data.scripts.campaign.events.SWP_IBBTracker;
import data.scripts.campaign.missions.SWP_FamousBountyEvent;
import org.lazywizard.console.BaseCommand;
import org.lazywizard.console.Console;

public class SWP_FamousBountyStage
implements BaseCommand {
    public BaseCommand.CommandResult runCommand(String args, BaseCommand.CommandContext context) {
        int stageNum;
        if (context != BaseCommand.CommandContext.CAMPAIGN_MAP) {
            Console.showMessage((String)"Error: This command is campaign-only.");
            return BaseCommand.CommandResult.WRONG_CONTEXT;
        }
        if (args.isEmpty()) {
            return BaseCommand.CommandResult.BAD_SYNTAX;
        }
        try {
            stageNum = Integer.parseInt(args);
        }
        catch (NumberFormatException ex) {
            Console.showMessage((String)"Error: stage must be a number!");
            return BaseCommand.CommandResult.BAD_SYNTAX;
        }
        if (stageNum < 0 || stageNum > SWP_FamousBountyEvent.MAX_BOUNTY_STAGE) {
            Console.showMessage((String)("Error: stage must be between 0 and " + SWP_FamousBountyEvent.MAX_BOUNTY_STAGE + "!"));
            return BaseCommand.CommandResult.ERROR;
        }
        SWP_FamousBountyEvent.FamousBountyStage stage = SWP_IBBTracker.getStage(stageNum);
        if (stage != null && !stage.mod.isLoaded()) {
            switch (stage.mod) {
                case JUNK_PIRATES: {
                    Console.showMessage((String)"Error: selected stage requires Junk Pirates!");
                    break;
                }
                case TIANDONG: {
                    Console.showMessage((String)"Error: selected stage requires Tiandong Heavy Industries!");
                    break;
                }
                case SHADOWYARDS: {
                    Console.showMessage((String)"Error: selected stage requires Shadowyards Reconstruction Authority!");
                    break;
                }
                case IMPERIUM: {
                    Console.showMessage((String)"Error: selected stage requires Interstellar Imperium!");
                    break;
                }
                case TEMPLARS: {
                    Console.showMessage((String)"Error: selected stage requires The Knights Templar!");
                    break;
                }
                case BLACKROCK: {
                    Console.showMessage((String)"Error: selected stage requires Blackrock Drive Yards!");
                    break;
                }
                case CABAL: {
                    Console.showMessage((String)"Error: selected stage requires Underworld!");
                    break;
                }
                case CITADEL: {
                    Console.showMessage((String)"Error: selected stage requires Citadel!");
                    break;
                }
                case DIABLE: {
                    Console.showMessage((String)"Error: selected stage requires Diable Avionics!");
                    break;
                }
                case EXIGENCY: {
                    Console.showMessage((String)"Error: selected stage requires Exigency!");
                    break;
                }
                case MAYORATE: {
                    Console.showMessage((String)"Error: selected stage requires Mayorate!");
                    break;
                }
                case ORA: {
                    Console.showMessage((String)"Error: selected stage requires Outer Rim Alliance!");
                    break;
                }
                case SCY: {
                    Console.showMessage((String)"Error: selected stage requires Scy Nation!");
                    break;
                }
            }
            return BaseCommand.CommandResult.ERROR;
        }
        if (stage == null || !SWP_IBBTracker.getTracker().isStageAllowed(stage)) {
            Console.showMessage((String)"Error: invalid stage!");
            return BaseCommand.CommandResult.ERROR;
        }
        SWP_IBBTracker.getTracker().reset();
        for (int i = 0; i < stageNum; ++i) {
            SWP_FamousBountyEvent.FamousBountyStage s = SWP_IBBTracker.getStage(i);
            SWP_IBBTracker.getTracker().reportStageCompleted(s);
        }
        Console.showMessage((String)("Famous bounty stage set to " + stageNum + " (" + stage.firstName + " " + stage.lastName + ")."));
        return BaseCommand.CommandResult.SUCCESS;
    }
}

