﻿<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"  xmlns:m = "http://www.w3.org/1998/Math/MathML" >

	<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>



	<xsl:template match="Log">

		<html dir='ltr'>

			<head>

				<title>

					Message Log for <xsl:value-of select="@LogonName"/>

				</title>

				<xsl:text disable-output-escaping="yes"><![CDATA[<object id="MathPlayer" classid="clsid:32F66A20-7614-11D4-BD11-00104BD3F987">

				</object>

				<?IMPORT NAMESPACE="m" IMPLEMENTATION="#MathPlayer" ?>]]></xsl:text>

			</head>



			<body style="padding:0px; margin:0px;" oncontextmenu="window.event.returnValue=false">

				<table width="100%" border="0" cellpadding="0" cellspacing="2">

					<xsl:for-each select="Message">

						<xsl:choose>

							<xsl:when test="position() mod 2 &gt; 0">

								<xsl:text disable-output-escaping="yes">

									<![CDATA[<tr style='background-color:#FFFFFF'>]]>

								</xsl:text>

							</xsl:when>

							<xsl:otherwise>

								<xsl:text disable-output-escaping="yes">

									<![CDATA[<tr>]]>

								</xsl:text>

							</xsl:otherwise>

						</xsl:choose>



						<td style="height:auto">

							<div style="padding:4px;table-layout:fixed; word-break: break-all; overflow:hidden; ">

								<!--聊天人名-->

								<xsl:choose>

									<xsl:when test="not(From)">



									</xsl:when>

									<xsl:otherwise>

										<span style="font-family: Arial, Helvetica, sans-serif; font-size: 12px;color: #2A66B1;line-height:20px;">

											<span>

												<xsl:value-of select='From/User/@Name'/>

											</span>&#160;&#160;&#160;&#160;<xsl:value-of select='./@DateTime' />

										</span>

										<br/>

									</xsl:otherwise>

								</xsl:choose>



								<!--聊天内容-->

								<span style="height:auto;">

									<xsl:attribute name="style">



										<xsl:if test="Text/@font-family != ''">

											font-family:<xsl:value-of select="Text/@font-family"/>;

										</xsl:if>

										<xsl:if test="Text/@font-family = ''">

											font-family: Arial, Helvetica, sans-serif;

										</xsl:if>

										<xsl:if test="Text/@font-size != ''">

											font-size:<xsl:value-of select="Text/@font-size"/>pt;

										</xsl:if>

										<xsl:if test="Text/@font-size = ''">

											font-size:12px;

										</xsl:if>

										<xsl:if test="Text/@font-weight != ''">

											font-weight:<xsl:value-of select="Text/@font-weight"/>;

										</xsl:if>

										<xsl:if test="Text/@font-style != ''">

											font-style:<xsl:value-of select="Text/@font-style"/>;

										</xsl:if>

										<xsl:if test="Text/@text-decoration != ''">

											text-decoration:<xsl:value-of select="Text/@text-decoration"/>;

									</xsl:if>

										<xsl:if test="Text/@color != ''">

											color:<xsl:value-of select="Text/@color"/>;

										</xsl:if>

										<xsl:if test="Text/@color = ''">

											color:#000000;

										</xsl:if>

									</xsl:attribute>

									<xsl:for-each select="Text/item">

										<xsl:choose>

											<xsl:when test="./@type = 'text'">

												<xsl:value-of select="./content" disable-output-escaping="yes"/>

											</xsl:when>

											<xsl:when test="./@type = 'img'">

												<img src="{./@src}"></img>

											</xsl:when>

											<xsl:when test="./@type = 'link'">

												<a target="_blank" href="{./@dst}">

													<xsl:value-of select="./content" disable-output-escaping="yes"/>

												</a>

											</xsl:when>

											<xsl:when test="./@type = 'math'">

												<xsl:value-of select="./content" disable-output-escaping="yes"/>

											</xsl:when>

										</xsl:choose>

									</xsl:for-each>

								</span>

							</div>

						</td>

						<xsl:text disable-output-escaping='yes'>

						  <![CDATA[</tr>]]>

						  </xsl:text>

						<tr>

							<td>

								<div style="border-bottom:1px solid #FFFFFF;"></div>

							</td>

						</tr>

					</xsl:for-each>

				</table>

			</body>

		</html>



	</xsl:template>



</xsl:stylesheet>

