$(function() {
  var TimelineControl,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  window.TimelineControl = TimelineControl = (function(_super) {
    var uniqueArray;

    __extends(TimelineControl, _super);

    function TimelineControl(map, notes, markerClusterer) {
      this.map = map;
      this.notes = notes;
      this.markerClusterer = markerClusterer;
      this.addNotesToMap = __bind(this.addNotesToMap, this);

      this.addMonthForYear = __bind(this.addMonthForYear, this);

      this.defaultOffset = new BMap.Size(15, 60);
      this.defaultAnchor = BMAP_ANCHOR_TOP_RIGHT;
    }

    TimelineControl.prototype.initialize = function(map) {
      var buttons, createTimeMap, getNearest3month, monthNav, nearest3month, times, year, yearNav;

      times = $.map(this.notes, function(note){
        return new Date(note.created);
      }).sort(function(a, b) {
        return a - b;
      });
      createTimeMap = function(times) {
        var arr, timeMap = {};
        $.each(times, function(index, time) {
          year = time.getFullYear();
          arr = timeMap[year] != null ? timeMap[year] : [];
          arr.push(time.getMonth());
          timeMap[year] = uniqueArray(arr);
        });
        return timeMap;
      };
      this.yearMonthsMap = createTimeMap(times);
      getNearest3month = function(timeMonthMap) {
        var months;
        months = timeMonthMap[new Date().getFullYear()];
        if (months != null) {
          if (months.length > 3) {
            timeMonthMap[new Date().getFullYear()] = months.slice(3);
          } else {
            delete timeMonthMap[new Date().getFullYear()];
          }
          return months.slice(0, 3);
        } else {
          return [];
        }
      };
      nearest3month = getNearest3month(this.yearMonthsMap);
      monthNav = $.map(nearest3month, function(month) {
        return "<li><a href='javascript: void(0)' data-time=\"" + (new Date().getFullYear()) + "-" + month + "\">" + (parseInt(month) + 1) + "月</a></li>"
      });
      yearNav = $.map(this.yearMonthsMap, function(index, year) {
        return "<li><a href='javascript: void(0)' data-time=\"" + year + "\">" + year + "</a></li>";
      });
      buttons = $(['<div><div id="timeline_nav"><ul>',
        "<li><a href='javascript: void(0)' data-time='9999'>全部</a></li>",
        monthNav.join(''),
        yearNav.join(''),
      '<ul></div></div>'].join('')).get(0);
      map.getContainer().appendChild(buttons);
      $('#timeline_nav').on('click', 'a', this.addMonthForYear);
      $('#timeline_nav').on('click', 'a', this.addNotesToMap);
      return buttons;
    };

    uniqueArray = function(arr) {
      var item, key, obj, _i, _len, _results;
      obj = {};
      for (_i = 0, _len = arr.length; _i < _len; _i++) {
        item = arr[_i];
        obj[item] = true;
      }
      _results = [];
      for (key in obj) {
        _results.push(key);
      }
      return _results;
    };

    TimelineControl.prototype.addMonthForYear = function(e) {
      var m, mNav, month, subNav, year, _ref;
      _ref = $(e.target).data("time").toString().split("-"), year = _ref[0], month = _ref[1];
      $('#timeline_nav li.current').removeClass('current');
      $(e.target).parent().addClass("current");
      if(year === '9999') {
        return;
      }
      if (!(month != null)) {
        $('#timeline_nav ol').remove();
        mNav = (function() {
          var _i, _len, _ref1, _results;
          _ref1 = this.yearMonthsMap[year];
          _results = [];
          for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
            m = _ref1[_i];
            _results.push("<li><a href='javascript: void(0)' data-time=\"" + year + "-" + m + "\">" + (parseInt(m) + 1) + "月</a></li>");
          }
          return _results;
        }).call(this);
        subNav = "<ol>" + (mNav.join("\n")) + "</ol>";
        $(e.target).after(subNav);
        return false;
      }
    };

    TimelineControl.prototype.addNotesToMap = function(e) {
      closeAllNoteWindowOnMap();
      var _this = this;
      var filteredNotes, month, note, year, _ref;
      _ref = $(e.target).data("time").toString().split("-"), year = _ref[0], month = _ref[1];
      year = parseInt(year);
      month = parseInt(month);
      filteredNotes = $.grep(_this.notes, function(note) {
        if (year === 9999) {
          return true;
        } else {
          return new Date(note.created).getFullYear() === year;
        }
      });
      if (month) {
        filteredNotes = $.grep(filteredNotes, function(note) {
          return new Date(note.created).getMonth() === month;
        });
      }
      clearAndAddNotesToMap(filteredNotes, _this.map, _this.markerClusterer);
    };

    return TimelineControl;

  })(BMap.Control);
});
