$(function() {
  var NoteOnMap,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

//  exports = this;

  window.baiduMapMarkerIcon = new BMap.Icon("images/718001c9.markers.png", new BMap.Size(31, 41), {
    anchor: new BMap.Size(15, 41),
    infoWindowAnchor: new BMap.Size(15, 0)
  });

  window.NoteOnMapInstances = [];

  window.closeAllNoteWindowOnMap = function() {
    $.each(NoteOnMapInstances, function(index, instance) {
      instance.close();
    });
  };

  window.NoteOnMap = NoteOnMap = (function(_super) {

    __extends(NoteOnMap, _super);

    function NoteOnMap(map, opts) {
      var _this = this;
      this.map = map;
      this.opts = opts;
      this.open = __bind(this.open, this);

      this.draw = __bind(this.draw, this);

      $.extend(this.opts, {
        offset: new BMap.Size(0, 0),
        enableAutoPan: true
      });
      this.marker = new BMap.Marker(this.opts.position, {
        icon: baiduMapMarkerIcon
      });
      this.marker.addEventListener('click', function(e) {
        return _this.open();
      });
      NoteOnMapInstances.push(this);
    }

    NoteOnMap.prototype.initialize = function(theMap) {
      var TRUNCATE_LENGTH = 30, _this = this;
      closeAllNoteWindowOnMap();
      this.map = theMap;
      var truncatedContent = this.opts.content.substring(0, TRUNCATE_LENGTH) + (this.opts.content.length > TRUNCATE_LENGTH ? "..." : "");
      var tagDiv = this.opts.tags != null ? "<p class=\"muted\" style=\"font-size:12px;\">标签: " + this.opts.tags.join(', ') + "</p>" : "";
      var imageDiv = this.opts.image != null ? [
        "<div class='col-xs-4'>",
          '<img src="/api/resources/redirect-to-cloud189/' + this.opts.image + '?&icon_option=max160" class="img-rounded img-responsive">',
        "</div>"].join('') : '';
      this.container = this.container = $([
        "<div style='display:block;top:auto;width:" + this.opts.width + ";height:" + this.opts.height + ";' class='popover top container-fluid'>",
          "<div class='arrow'></div>",
          "<h3 class='popover-title'>" + this.opts.title,
            "<button type='button' class='close pull-right'>&times;</button>",
          "</h3>",
          "<div class='popover-content'>",
            "<div class='row'>",
              "<div class='" + (imageDiv.length > 0 ? "col-xs-8" : "col-xs-12") + "'>",
                "<p style='font-size:13px;'>" + truncatedContent + "</p>",
                "<blockquote>" + tagDiv + "<p style='font-size:12px;'>",
                  "<i class='icon-th-large'></i><a href='#/main?edit=" + this.opts.noteId + "' style='color:black;'>编辑</a></p>",
                "</blockquote>",
              "</div>",
              imageDiv,
            "</div>",
          "</div>",
        "</div>"].join('')).get(0);
      this.map.getPanes().floatPane.appendChild(this.container);
      this.containerOffsetWidth = parseInt(this.container.offsetWidth, 10);
      this.containerOffsetHeight = parseInt(this.container.offsetHeight, 10);
      $(this.container).on('click', 'button.close', function(e) {
        return _this.close();
      });
//      $('.fancybox_ajax').fancybox({
//        type: 'ajax'
//      });
      return this.container;
    };

    NoteOnMap.prototype.draw = function() {
      if (this.isOpen) {
        return this.adjustPosition();
      }
    };

    NoteOnMap.prototype.adjustPosition = function() {
      var icon, pixel;
      pixel = this.map.pointToOverlayPixel(this.marker.getPosition());
      icon = this.marker.getIcon();
      this.container.style.bottom = -(pixel.y - this.opts.offset.height - icon.anchor.height + icon.infoWindowAnchor.height) - this.marker.getOffset().height + 2 + 10 + "px";
      return this.container.style.left = pixel.x - icon.anchor.width + this.marker.getOffset().width + icon.infoWindowAnchor.width - this.containerOffsetWidth / 2 + "px";
    };

    NoteOnMap.prototype.open = function() {
      if (!this.isOpen) {
        this.map.addOverlay(this);
        this.isOpen = true;
      }
      this.show();
      this.panBox();
      return this.adjustPosition();
    };

    NoteOnMap.prototype.show = function() {
      if (this.container != null) {
        return this.container.style.display = "block";
      }
    };

    NoteOnMap.prototype.hide = function() {
      if (this.container != null) {
        return this.container.style.display = "none";
      }
    };

    NoteOnMap.prototype.close = function() {
      if (this.isOpen) {
        this.map.removeOverlay(this);
        return this.isOpen = false;
      }
    };

    NoteOnMap.prototype.panBox = function() {
      var anchorPos, boxH, boxW, h, icon, mapH, mapW, panLeft, panRight, panTop, panX, panY;
      if (!this.opts.enableAutoPan) {
        return;
      }
      mapH = parseInt(this.map.getContainer().offsetHeight, 10);
      mapW = parseInt(this.map.getContainer().offsetWidth, 10);
      boxH = this.containerOffsetHeight;
      boxW = this.containerOffsetWidth;
      if (boxH >= mapH || boxW >= mapW) {
        return;
      }
      if (!this.map.getBounds().containsPoint(this.marker.getPosition())) {
        this.map.setCenter(this.marker.getPosition());
      }
      icon = this.marker.getIcon();
      anchorPos = this.map.pointToPixel(this.marker.getPosition());
      panLeft = boxW / 2 - 28 - anchorPos.x + 100;
      panRight = boxW / 2 + 28 + anchorPos.x - mapW + 125;
      h = icon.anchor.height + this.marker.getOffset().height - icon.infoWindowAnchor.height;
      panTop = boxH - anchorPos.y + this.opts.offset.height + h + 31 + 30;
      panX = panLeft > 0 ? panLeft : (panRight > 0 ? -panRight : 0);
      panY = panTop > 0 ? panTop : 0;
      return this.map.panBy(panX, panY);
    };

    return NoteOnMap;

  })(BMap.Overlay);

});
