window.clearAndAddNotesToMap = function(notes, map, markerClusterer) {
  var bounds, markers, notesOnMap;
  markerClusterer.clearMarkers();
  if ((notes != null) && notes.length > 0) {
    notesOnMap = $.map(notes, function(note){
      return new NoteOnMap(map, note);
    });

    markers = $.map(notesOnMap, function(noteOnMap){
      return noteOnMap.marker;
    });
    markerClusterer.addMarkers(markers);
    bounds = new BMap.Bounds(notes[0].position, notes[0].position);
    $.each(notes, function(index, note){
      bounds.extend(note.position);
    });

    map.setViewport(bounds, {
      margins: [75, 135, 0, 50]
    });
//    console.log('zoom ' + map.getZoom());
//    if (map.getZoom() > 14) {
//      console.log('set zoom to 14');
//      map.setZoom(14);
//    }
  }
};