function init(virtual)
	if virtual then return end
	storage.timePassed = 0

	entity.setInteractive(entity.configParameter("interactive", true))
	if storage.state == nil then
		output(entity.configParameter("defaultSwitchState", false))
	else
		output(storage.state)
	end
	self.delay = entity.configParameter("delay")
end

function onInteraction(args)
	output(not storage.state)
end

function onInboundNodeChange(args)
	output(args.level)
end

function output(state)
	storage.state = state
	if state then
		entity.setAnimationState("switchState", "0")
		if not (entity.configParameter("alwaysLit")) then entity.setLightColor(entity.configParameter("lightColor", {0, 0, 0, 0})) end
		entity.playSound("on");
	else
		storage.timePassed = 0
		entity.setAnimationState("switchState", "0")
		if not (entity.configParameter("alwaysLit")) then entity.setLightColor({0, 0, 0, 0}) end
		entity.playSound("off");
		entity.setAllOutboundNodes(false)
	end
end

function update(dt)
	if (storage.state) then
		storage.timePassed = storage.timePassed + dt
		local animState = math.floor((storage.timePassed / self.delay) * 10)
		if animState > 10 then animState = 10 end
		if animState < 0 then animState = 0 end
		entity.setAnimationState("switchState", animState)
		if (storage.timePassed >= self.delay) then
			entity.setAllOutboundNodes(true)
		end
	end
end
