renderer = {
	width = 400,
	height = 210,
	tileWidth = 16,
	tileHeight = 16,
	position = {0, 0},
	colours = {{255, 255, 255, 255}, {255, 0, 0, 255}, {0, 0, 255, 255}, {255, 255, 0, 255}},
	knight = "/pilch_wiring/objects/pilch_blueknight/gfx/knight.png",
	title = "/pilch_wiring/objects/pilch_blueknight/gfx/title.png"
}

function renderer:renderTitle()
	console.canvasDrawImageRect(renderer.title, {0, 0, 640, 480}, {60, 0, 340, 210}, {255, 255, 255, 255})
end

function renderer:renderGame()
	self.tileWidth = self.width / 8
	self.tileHeight = self.height / 8
	
	for y = 1, 8 do
		for x = 1, 8 do
			local coordX = self.position[1] + ((x - 1) * self.tileWidth)
			local coordY = self.position[2] + ((y - 1) * self.tileHeight)
			local diffX = math.abs(x - player.x)
			local diffY = math.abs(y - player.y)
			if (diffX == 1 and diffY == 2) or (diffX == 2 and diffY == 1) then
				if game.board[x][y] < 3 then
					console.canvasDrawRect({coordX, coordY, coordX + self.tileWidth, coordY + self.tileHeight}, self.colours[4])
				else
					console.canvasDrawRect({coordX, coordY, coordX + self.tileWidth, coordY + self.tileHeight}, self.colours[game.board[x][y]])
				end
			else
				console.canvasDrawRect({coordX, coordY, coordX + self.tileWidth, coordY + self.tileHeight}, self.colours[game.board[x][y]])
			end
		end
	end
	
	local coordX = self.position[1] + ((player.x - 1) * self.tileWidth)
	local coordY = self.position[2] + ((player.y - 1) * self.tileHeight)
	console.canvasDrawImageRect(renderer.knight, {0, 0, 60, 60}, {coordX, coordY, coordX + self.tileWidth, coordY + self.tileHeight}, {255, 255, 255, 255})
end
