game = {
	state = "title",
	board = {},
	lastClickPosition = nil
}

player = {
	x = 1,
	y = 1
}

function init()
	initTitle()
	initGame()
end

function initTitle()
	renderer.width = 400
	renderer.height = 210
	renderer.position = {0, 0}

	game.state = "title"
end

function initGame()
	renderer.height = 208
	renderer.width = 208
	renderer.position = {96, 0}

	local colour = 1
	for x = 1, 8 do
		colour = 3 - colour
		colourB = colour
		game.board[x] = {}

		for y = 1, 8 do
			game.board[x][y] = colourB
			colourB = 3 - colourB
		end
	end
	game.board[1][1] = 3
	player.x = 1
	player.y = 1
end

function update(dt)
	if game.state == "title" then
		updateTitle()
	elseif game.state == "game" then
		updateGame()
	elseif game.state == "lose" then
		updateLose()
	else
		updateWin()
	end
end

function updateTitle()
	if game.lastClickPosition then
		game.state = "game"
		game.lastClickPosition = nil
	end
	renderer:renderTitle()
end

function updateGame()
	if game.lastClickPosition then
		local x = math.floor((game.lastClickPosition[1] - renderer.position[1]) / renderer.tileWidth) + 1
		local y = math.floor((game.lastClickPosition[2] - renderer.position[2]) / renderer.tileHeight) + 1
		if x > 0 and x < 9 and y > 0 and y < 9 then
			local diffX = math.abs(x - player.x)
			local diffY = math.abs(y - player.y)
			if (diffX == 1 and diffY == 2) or (diffX == 2 and diffY == 1) then
				if game.board[x][y] < 3 then
					player.x = x
					player.y = y
					game.board[x][y] = 3
				end
			end
		end
		game.lastClickPosition = nil
	end
	game.state = checkGameOver()
	renderer:renderGame()
end

function updateLose()
	if game.lastClickPosition then
		init()
		game.lastClickPosition = nil
	end
	renderer:renderGame()
	console.canvasDrawText("You lose!", {position = {157, 115}, width = 100, centered = true}, 20, {0, 0, 0, 255})
end

function updateWin()
	if game.lastClickPosition then
		init()
		game.lastClickPosition = nil
	end
	renderer:renderGame()
	console.canvasDrawText("You win!", {position = {163, 115}, width = 100, centered = true}, 20, {255, 255, 0, 255})
end

function checkGameOver()
	local blueCount = 0
	local yellowCount = 0
	for x = 1, 8 do
		for y = 1, 8 do
			if game.board[x][y] == 3 then
				blueCount = blueCount + 1
			else
				local diffX = math.abs(x - player.x)
				local diffY = math.abs(y - player.y)
				if (diffX == 1 and diffY == 2) or (diffX == 2 and diffY == 1) then
					yellowCount = yellowCount + 1
				end
			end
		end
	end
	if blueCount == 64 then
		return "win"
	elseif yellowCount == 0 then
		return "lose"
	end
	return "game"
end

function canvasClickEvent(position, button, isButtonDown)
	if isButtonDown and button == 1 then
		game.lastClickPosition = position
	end
end

function canvasKeyEvent(key, isKeyDown)
end
