-- stages of reading
READBUILDING = 1
SPITOUTPRINTER = 2
DISPLAYANIMATION = 3
READSUCCESS = 256
CLEARAREAONLY = 512
CLEARSUCCESS = 513

function readerBusy()
	if (self.miab) then
		return true
	end

	return false
end

function readStart(args)
	self.miab = {}
	-- store area to read
	self.miab.boundingBox = copyTable(args.areaToScan)
	
	-- store area to ignore
	self.miab.areaToIgnore = copyTable(args.areaToIgnore)
	
	-- store placement of printer
	self.miab.readerPosition = copyTable(args.readerPosition)
	
	-- position where the blueprint (or currently printer) will be dropped after successfull read
	self.miab.spawnPrinterPosition = copyTable(args.spawnPrinterPosition)
	
	-- do not remove the scanned structure, clone it
	self.miab.breakStuff = args.breakStuff

	-- only clear the area, do not scan
	self.miab.clearOnly = args.clearOnly

	-- if true plots files of the blueprint to the log
	self.miab.plotJSON = args.plotJSON

	-- number of printers we want created
	self.miab.printerCount = args.printerCount
		
	self.miab.animationDuration = args.animationDuration -- in seconds
	
	-- reset the blueprint to blank (and store bounding box)
	local dist = world.distance({self.miab.boundingBox[3], self.miab.boundingBox[4]}, {self.miab.boundingBox[1], self.miab.boundingBox[2]})
	blueprint.Init({dist[1], dist[2]})
	
	-- flag to start scanning
	if (self.miab.clearOnly) then
		self.miab.readingStage = CLEARAREAONLY
	else
		self.miab.readingStage = READBUILDING
	end
	
	self.miab.animationStarted = false
end

function readModule()
	if (self.miab == nil) then return end -- not initialized
	
	if (self.miab.readingStage == READBUILDING) then
		if (setDefaultAnimation) then setDefaultAnimation() end
		scanBuilding()
		if (self.miab.breakStuff) then destroyBlocks() end
		self.miab.readingStage = SPITOUTPRINTER
	elseif (self.miab.readingStage == SPITOUTPRINTER) then
		if (self.miab.breakStuff) then destroyBlocks() end
		spawnPrinterItem()
		produceJSONOutput()
		self.miab.readingStage = DISPLAYANIMATION
	elseif (self.miab.readingStage == DISPLAYANIMATION) then
		displayBlueprintAnimation()
	elseif (self.miab.readingStage == READSUCCESS) then
		endSuccessfully()
	elseif (self.miab.readingStage == CLEARAREAONLY) then
		if (setDefaultAnimation) then setDefaultAnimation() end
		dropObjects()
		dropBlocks()
		self.miab.readingStage = CLEARSUCCESS
	elseif (self.miab.readingStage == CLEARSUCCESS) then
		dropBlocks()
		endSuccessfully()
	end
end

----- Reading State machine -----

-- workers
function scanBuilding()
	if self.miab.boundingBox == nil then
		endUnsuccessfully()
		return
	end
	
	local anythingScanned = false
	
	local dist = world.distance({self.miab.boundingBox[3], self.miab.boundingBox[4]}, {self.miab.boundingBox[1], self.miab.boundingBox[2]})
	local xMax = dist[1]
	local yMax = dist[2]
	if xMax < 1 or yMax < 1 then
		endUnsuccessfully()
		return
	end
	
	-- scan blocks + mods
	local pos = nil
	local matNameBack = nil
	local matNameFore = nil
	local modNameBack = nil
	local modNameFore = nil
	for y = 0, yMax, 1 do
		for x = 0, xMax, 1 do
			pos = {self.miab.boundingBox[1] + x, self.miab.boundingBox[2] + y}
			if (not self.miab.areaToIgnore) or (self.miab.areaToIgnore and not blueprint.isInsideBoundingBox(pos, self.miab.areaToIgnore)) then -- ignore pixels in areaToIgnore if it is defined
				matNameBack = world.material(pos, "background")
				matNameFore = world.material(pos, "foreground")
				modNameBack = world.mod(pos, "background")
				modNameFore = world.mod(pos, "foreground")
				-- some impassable things like doors leave "metamaterial:<something>" now which cant be printed later on ...
				if matNameBack and not string.find(matNameBack, "metamaterial:") then
					-- store in blueprint
					blueprint.setBlock(x, y, matNameBack, "background")
					
					anythingScanned = true
				else
					-- store as scaffold location
					blueprint.setBlock(x, y, "miab_scaffold", "background")
				end

				-- some impassable things like doors leave "metamaterial:<something>" now which cant be printed later on ...
				if matNameFore and not string.find(matNameFore, "metamaterial:") then			
					-- store in blueprint
					blueprint.setBlock(x, y, matNameFore, "foreground")
					
					anythingScanned = true
				else
					-- store as scaffold location
					blueprint.setBlock(x, y, "miab_scaffold", "foreground")
				end

				if (modNameBack) then
					-- store in blueprint
					blueprint.setMod(x, y, modNameBack, "background")
					
					anythingScanned = true
				end

				if (modNameFore) then
					-- store in blueprint
					blueprint.setMod(x, y, modNameFore, "foreground")
					
					anythingScanned = true
				end
			end
		end
	end

	-- scan objects
	local objectIds = fixedObjectQuery({self.miab.boundingBox[1], self.miab.boundingBox[2]}, {self.miab.boundingBox[3], self.miab.boundingBox[4]})
	if (objectIds) then
		for i, objectId in pairs(objectIds) do
			pos = world.entityPosition(objectId)
			dist = world.distance(pos, {self.miab.boundingBox[1], self.miab.boundingBox[2]})
			-- this if is needed as objects that overlap the BB but are not placed
			-- "at a block inside the BB" dont need to be copied			
			if (blueprint.isInsideBoundingBox(pos, self.miab.boundingBox)) then
				if (not self.miab.areaToIgnore) or (self.miab.areaToIgnore and not blueprint.isInsideBoundingBox(pos, self.miab.areaToIgnore)) then -- ignore objects in areaToIgnore if it is defined
					-- store in blueprint
					blueprint.setObject(dist[1], dist[2], objectId)
					-- smash it
					if (self.miab.breakStuff) then world.breakObject(objectId, true) end
					
					anythingScanned = true
				end
			end
		end
	end

	if (not anythingScanned) then
		endUnsuccessfully()
	end
end

function destroyBlocks()
	if (self.miab == nil) then return end -- failed during read stage

	local dist = world.distance({self.miab.boundingBox[3], self.miab.boundingBox[4]}, {self.miab.boundingBox[1], self.miab.boundingBox[2]})
	local xMax = dist[1]
	local yMax = dist[2]
	local pos = {}

	for y = yMax, 0, -1 do
		for x = 0, xMax, 1 do
			pos = {self.miab.boundingBox[1] + x, self.miab.boundingBox[2] + y}
			if (not self.miab.areaToIgnore) or (self.miab.areaToIgnore and not blueprint.isInsideBoundingBox(pos, self.miab.areaToIgnore)) then -- dont destroy what we ignored while scanning
				blueprint.clearBlock(pos,"background")
				blueprint.clearBlock(pos,"foreground")
			end
		end
	end
end

function spawnPrinterItem()
	-- spawn printer item
	local _configTbl = blueprint.toConfigTable()
	world.spawnItem("miab_basestore_printer", self.miab.spawnPrinterPosition, self.miab.printerCount, _configTbl)
end

function produceJSONOutput()
	if (self.miab.plotJSON) then
		blueprint.DumpJSON()
	end
end

function displayBlueprintAnimation()
	if (self.miab.animationStarted) then
		-- timer is already running
		if(os.time() >= self.miab.animationStartTime + self.miab.animationDuration) then
			-- timer ran out
			if (setDefaultAnimation) then setDefaultAnimation() end
			self.miab.animationStarted = false
			self.miab.readingStage = READSUCCESS
		end
	else
		if (setBlueprintAnimation) then
			-- start animation
			setBlueprintAnimation()
			-- start timer
			self.miab.animationStartTime = os.time()
			self.miab.animationStarted = true
		end
	end
end

function dropObjects()
	local objectIds = fixedObjectQuery({self.miab.boundingBox[1], self.miab.boundingBox[2]}, {self.miab.boundingBox[3], self.miab.boundingBox[4]})
	if (objectIds) then
		for i, objectId in pairs(objectIds) do
			local pos = world.entityPosition(objectId)
			local dist = world.distance(pos, {self.miab.boundingBox[1], self.miab.boundingBox[2]})
			-- this if is needed as objects that overlap the BB but are not placed
			-- "at a block inside the BB" dont need to be copied			
			if (blueprint.isInsideBoundingBox(pos, self.miab.boundingBox)) then
				-- drop it
				world.breakObject(objectId, false)
			end
		end
	end
end

function dropBlocks()
	local dist = world.distance({self.miab.boundingBox[3], self.miab.boundingBox[4]}, {self.miab.boundingBox[1], self.miab.boundingBox[2]})
	local xMax = dist[1]
	local yMax = dist[2]
	local pos = {}

	for y = yMax, 0, -1 do
		for x = 0, xMax, 1 do
			pos = {self.miab.boundingBox[1] + x, self.miab.boundingBox[2] + y}
			if (not self.miab.areaToIgnore) or (self.miab.areaToIgnore and not blueprint.isInsideBoundingBox(pos, self.miab.areaToIgnore)) then -- dont destroy what we ignored while scanning
				world.damageTiles({pos}, "background", pos, "blockish", 10000, 1)
				world.damageTiles({pos}, "foreground", pos, "blockish", 10000, 1)
			end
		end
	end
end

function endUnsuccessfully()
	blueprint.Init({0, 0}) -- reset blueprint
	self.miab = nil -- reset state
end

function endSuccessfully()
	blueprint.Init({0, 0}) -- reset blueprint
	self.miab = nil -- reset state
end