function init(virtual)
	if (not virtual) then
		object.setInteractive(true)
		
		-- Options for write process
		local writerOptions = {}
		local offset = config.getParameter("miab_printer_offset", {0.0, 0.0})
		writerOptions.writerPosition = object.toAbsolutePosition(offset)
		writerOptions.spawnUnplacablesPosition = object.toAbsolutePosition({ 0, 4 })
		printInit(writerOptions)
		
		donePrinting = false -- flag to end polling
	end
end

function onInteraction(args)
	printStart()
end

function update(dt)
	if (not donePrinting) then
		-- needs to be polled
		donePrinting = printModule()
	else
		object.smash()
	end	
end

function die()
	if (donePrinting == false) then
		world.spawnItem("miab_basestore_printer", entity.position(), 1, blueprint.toConfigTable())
		object.smash()
	end
end