<?php

chdir(dirname(__FILE__));

// start scripts located elsewhere than vanilla/scripts should include
// vanilla/scripts in include path with a relative path
// e.g. set_include_path("../../../packages/vanilla/scripts"); 

// all vanilla includes are defined in relation to vanilla/scripts OR the local folder

// --------------------------------------------

// this is mostly intended as a template for single player quick match overlays

// 1) make a copy of this file renaming it to something of your own and move it to your overlay folder, preferably under scripts subfolder
// 2) customize the settings and logic
// 3) make your overlay_config.xml point to this file with quick_match_entry_script="xxx"
// 4) launch game, enable the mod in quick match mod menu and start a new game

// --------------------------------------------

function get_start_server_command() {
	return "";
}

// --------------------------------------------

// this assumes the file is located at media/packages/RWR_total_conversion_mod/scripts/
set_include_path("../../../packages/vanilla/scripts"); 

include_once("internal/metagame.as");
include_once("internal/log.as");

include_once("trackers/basic_command_handler.as");

include_once("trackers/phase_controller_map12.as");

// --------------------------------------------
class GameModeExtended extends MetaGame {

	// --------------------------------------------
	public function init() {
		parent::init();

		// with quickmatch scripting, we get to run the script late in a sense,
		// the match has already started in RWR when we start processing the script,
		// but let's not let that stand in our way!

		// if the script needs to manipulate faction vehicle resources in some way 
		// right from the start of the match, it's a good idea to accompany the 
		// disabling calls with remove_existing_on_disable so that the potentially
		// already created vehicles of specific type to be disabled will be removed 
	
		$this->pre_begin_match();
		$this->post_begin_match();
	}

	// --------------------------------------------
	public function post_begin_match() {
		parent::post_begin_match();

		$this->add_tracker(new BasicCommandHandler($this));

		$this->add_tracker(new PhaseControllerMap12($this));

		$this->comms->send("say hello!");
	}
}

// --------------------------------------------

$metagame = new GameModeExtended();

$metagame->init();
// execution blocks here at run until comms from server is lost
$metagame->run();
$metagame->uninit();

_log("ending execution");

?>