--==========================================================================================================================
-- LOADING INFO
--==========================================================================================================================
-- LoadingInfo
-------------------------------------	
INSERT INTO LoadingInfo	
		(LeaderType,					ForegroundImage,						BackgroundImage,				PlayDawnOfManAudio)
VALUES	('LEADER_ANT_TAIZONG',			'LEADER_ANT_TAIZONG_NEUTRAL',			'LEADER_VICTORIA_BACKGROUND',	0);	
--==========================================================================================================================
-- DIPLOMACY INFO
--==========================================================================================================================
-- DiplomacyInfo
-------------------------------------	
-- INSERT INTO DiplomacyInfo	
-- 			(Type,						BackgroundImage)
-- VALUES	('LEADER_ANT_TAIZONG',		'FALLBACK_NEUTRAL_ANT_TAIZONG.dds');
--==========================================================================================================================
-- COLOURS
--==========================================================================================================================
-- PlayerColors
-------------------------------------	
INSERT INTO PlayerColors	
		(Type,							Usage,				PrimaryColor, 							SecondaryColor,							TextColor)
VALUES	('LEADER_ANT_TAIZONG',			'Unique',			'COLOR_PLAYER_ANT_TAIZONG_PRIMARY',		'COLOR_PLAYER_ANT_TAIZONG_SECONDARY', 	'COLOR_PLAYER_WHITE_TEXT');	

INSERT INTO Colors 
		(Type, 										Red, 	Green, 	Blue, 	Alpha)
VALUES	('COLOR_PLAYER_ANT_TAIZONG_PRIMARY', 		0.216,	0.059,	0.020,	1),
		('COLOR_PLAYER_ANT_TAIZONG_SECONDARY', 		0.627,	0.608,	0.118,	1);
--==========================================================================================================================
-- LEADERS
--==========================================================================================================================
-- Types
-------------------------------------	
INSERT INTO Types	
		(Type,							Kind)
VALUES	('LEADER_ANT_TAIZONG',			'KIND_LEADER');	
-------------------------------------
-- Leaders
-------------------------------------	
INSERT INTO Leaders	
		(LeaderType,					Name,												InheritFrom,		SceneLayers)
VALUES	('LEADER_ANT_TAIZONG',			'LOC_LEADER_ANT_TAIZONG_NAME',						'LEADER_DEFAULT',	4);	
-------------------------------------
-- LeaderQuotes
-------------------------------------	
INSERT INTO LeaderQuotes	
		(LeaderType,					Quote)
VALUES	('LEADER_ANT_TAIZONG',			'LOC_LEADER_ANT_TAIZONG_QUOTE');	
-------------------------------------
-- LeaderTraits
-------------------------------------	
INSERT INTO LeaderTraits	
		(LeaderType,					TraitType)
VALUES	('LEADER_ANT_TAIZONG',			'TRAIT_LEADER_ANT_FOUR_GARRISONS');	
-- -------------------------------------
-- HistoricalAgendas
-- -------------------------------------	
INSERT INTO HistoricalAgendas	
		(LeaderType,					AgendaType)
VALUES	('LEADER_ANT_TAIZONG',			'AGENDA_ANT_HEAVENLY_KHAGAN');	
-- -------------------------------------
-- FavoredReligions
-- -------------------------------------	
INSERT OR REPLACE INTO FavoredReligions
       (LeaderType,						ReligionType)
VALUES   ('LEADER_ANT_TAIZONG',		    'RELIGION_CONFUCIANISM');

CREATE TRIGGER AntTaizong_HR
AFTER INSERT ON Religions WHEN 'RELIGION_ZOROASTRIANISM' = NEW.ReligionType
BEGIN
   INSERT OR REPLACE INTO FavoredReligions
		    (LeaderType,				ReligionType)
   VALUES   ('LEADER_ANT_TAIZONG',		'RELIGION_CONFUCIANISM');
END;
--==========================================================================================================================
-- TRAITS
--==========================================================================================================================
-- Types
-------------------------------------	
INSERT INTO Types	
		(Type,													Kind)
VALUES	('TRAIT_LEADER_ANT_FOUR_GARRISONS',						'KIND_TRAIT');	
-------------------------------------			
-- Traits			
-------------------------------------				
INSERT INTO Traits				
		(TraitType,												Name,												Description)
VALUES	('TRAIT_LEADER_ANT_FOUR_GARRISONS',						'LOC_TRAIT_LEADER_ANT_FOUR_GARRISONS_NAME',			'LOC_TRAIT_LEADER_ANT_FOUR_GARRISONS_DESCRIPTION');
-------------------------------------
-- TraitModifiers
-------------------------------------
INSERT INTO TraitModifiers			
		(TraitType,												ModifierId)
VALUES	('TRAIT_LEADER_ANT_FOUR_GARRISONS', 					'TRAIT_ANT_FOUR_GARRISONS_COMBAT_BONUS_ENCAMPMENT'),
		('TRAIT_LEADER_ANT_FOUR_GARRISONS', 					'TRAIT_ANT_FOUR_GARRISONS_COMBAT_BONUS_ENCAMPMENT_MODIFIER'),
		('TRAIT_LEADER_ANT_FOUR_GARRISONS', 					'TRAIT_ANT_FOUR_GARRISONS_GOLD_FROM_KILLS_ENCAMPMENT'),
		('TRAIT_LEADER_ANT_FOUR_GARRISONS', 					'TRAIT_ANT_FOUR_GARRISONS_CULTURE_BOMB_PROTECTORATE'),
		('TRAIT_LEADER_ANT_FOUR_GARRISONS', 					'TRAIT_ANT_FOUR_GARRISONS_CULTURE_BOMB_COMMERCIAL_HUB');
--==========================================================================================================================
-- AGENDAS
--==========================================================================================================================
-- Agendas			
-------------------------------------				
INSERT INTO Agendas				
		(AgendaType,									Name,											Description)
VALUES	('AGENDA_ANT_HEAVENLY_KHAGAN',					'LOC_AGENDA_ANT_HEAVENLY_KHAGAN_NAME',			'LOC_AGENDA_ANT_HEAVENLY_KHAGAN_DESCRIPTION');	
-------------------------------------
-- Types
-------------------------------------	
INSERT INTO Types	
		(Type,											Kind)
VALUES	('TRAIT_AGENDA_ANT_HEAVENLY_KHAGAN',			'KIND_TRAIT');
-------------------------------------			
-- AgendaTraits			
-------------------------------------				
INSERT INTO AgendaTraits				
		(AgendaType,									TraitType)
VALUES	('AGENDA_ANT_HEAVENLY_KHAGAN',					'TRAIT_AGENDA_ANT_HEAVENLY_KHAGAN');
-------------------------------------			
-- ExclusiveAgendas
-------------------------------------
INSERT INTO ExclusiveAgendas				
		(AgendaOne,										AgendaTwo)
VALUES	('AGENDA_ANT_HEAVENLY_KHAGAN',					'AGENDA_MONEY_GRUBBER');					
-------------------------------------			
-- Traits			
-------------------------------------				
INSERT INTO Traits				
		(TraitType,										Name,											Description)
VALUES	('TRAIT_AGENDA_ANT_HEAVENLY_KHAGAN',			'LOC_AGENDA_ANT_HEAVENLY_KHAGAN_NAME',			'LOC_AGENDA_ANT_HEAVENLY_KHAGAN_DESCRIPTION');
-------------------------------------
-- TraitModifiers
-------------------------------------
INSERT INTO TraitModifiers			
		(TraitType,													ModifierId)
VALUES	('TRAIT_AGENDA_ANT_HEAVENLY_KHAGAN', 						'MODIFIER_AGENDA_ANT_HEAVENLY_KHAGAN_HIGH_INCOME'),
		('TRAIT_AGENDA_ANT_HEAVENLY_KHAGAN', 						'MODIFIER_AGENDA_ANT_HEAVENLY_KHAGAN_LOW_INCOME');
--==========================================================================================================================
-- MODIFIERS 
--==========================================================================================================================
-- Modifiers
-------------------------------------
INSERT INTO Modifiers			
		(ModifierId,													ModifierType,													SubjectRequirementSetId)
VALUES	('TRAIT_ANT_FOUR_GARRISONS_COMBAT_BONUS_ENCAMPMENT',			'MODIFIER_PLAYER_UNITS_ATTACH_MODIFIER',						null),
		('TRAIT_ANT_FOUR_GARRISONS_COMBAT_BONUS_ENCAMPMENT_MODIFIER',	'MODIFIER_UNIT_ADJUST_COMBAT_STRENGTH',							'PLOT_TWO_INCLUDE_ENCAMPMENT_TAIZONG'),
		('TRAIT_ANT_FOUR_GARRISONS_GOLD_FROM_KILLS_ENCAMPMENT',			'MODIFIER_PLAYER_UNITS_ADJUST_POST_COMBAT_YIELD',				'PLOT_TWO_INCLUDE_ENCAMPMENT_TAIZONG'),
		('MODIFIER_AGENDA_ANT_HEAVENLY_KHAGAN_HIGH_INCOME',				'MODIFIER_PLAYER_DIPLOMACY_SIMPLE_MODIFIER',					'PLAYER_HAS_HIGH_INCOME'),
		('MODIFIER_AGENDA_ANT_HEAVENLY_KHAGAN_LOW_INCOME',				'MODIFIER_PLAYER_DIPLOMACY_SIMPLE_MODIFIER',					'PLAYER_HAS_LOW_INCOME');
-------------------------------------
-- ModifierArguments
-------------------------------------
INSERT INTO ModifierArguments
		(ModifierId,													Name,							Value)
VALUES	('TRAIT_ANT_FOUR_GARRISONS_COMBAT_BONUS_ENCAMPMENT',			'ModifierId',					'TRAIT_ANT_FOUR_GARRISONS_COMBAT_BONUS_ENCAMPMENT_MODIFIER'),
		('TRAIT_ANT_FOUR_GARRISONS_COMBAT_BONUS_ENCAMPMENT_MODIFIER',	'Amount',						5),
		('TRAIT_ANT_FOUR_GARRISONS_GOLD_FROM_KILLS_ENCAMPMENT',			'YieldType',					'YIELD_GOLD'),
		('TRAIT_ANT_FOUR_GARRISONS_GOLD_FROM_KILLS_ENCAMPMENT',			'PercentDefeatedStrength',		100),
		
		('MODIFIER_AGENDA_ANT_HEAVENLY_KHAGAN_HIGH_INCOME',				'InitialValue',					-10),
		('MODIFIER_AGENDA_ANT_HEAVENLY_KHAGAN_HIGH_INCOME',				'StatementKey',					'LOC_DIPLO_WARNING_LEADER_ANT_TAIZONG_REASON_ANY'),
		('MODIFIER_AGENDA_ANT_HEAVENLY_KHAGAN_HIGH_INCOME',				'SimpleModifierDescription',	'LOC_DIPLO_MODIFIER_ANT_ZHENGUAN_HIGH_GOLD'),

		('MODIFIER_AGENDA_ANT_HEAVENLY_KHAGAN_LOW_INCOME',				'InitialValue',					7),
		('MODIFIER_AGENDA_ANT_HEAVENLY_KHAGAN_LOW_INCOME',				'StatementKey',					'LOC_DIPLO_WARNING_LEADER_ANT_TAIZONG_REASON_ANY'),
		('MODIFIER_AGENDA_ANT_HEAVENLY_KHAGAN_LOW_INCOME',				'SimpleModifierDescription',	'LOC_DIPLO_MODIFIER_ANT_ZHENGUAN_LOW_GOLD');
-------------------------------------
-- Types
-------------------------------------
-------------------------------------
-- DynamicModifiers
-------------------------------------
-------------------------------------
-- ModifierStrings
-------------------------------------
INSERT INTO ModifierStrings
		(ModifierId,													Context,						Text)
VALUES	('TRAIT_ANT_FOUR_GARRISONS_COMBAT_BONUS_ENCAMPMENT_MODIFIER',	'Preview',						'LOC_PROMOTION_NEAR_ENCAMPMENT_TAIZONG_DESCRIPTION'),
		('MODIFIER_AGENDA_ANT_HEAVENLY_KHAGAN_HIGH_INCOME',				'Sample',						'LOC_TOOLTIP_SAMPLE_DIPLOMACY_ALL'),
		('MODIFIER_AGENDA_ANT_HEAVENLY_KHAGAN_LOW_INCOME',				'Sample',						'LOC_TOOLTIP_SAMPLE_DIPLOMACY_ALL');
--==========================================================================================================================
-- REQUIREMENTS
--==========================================================================================================================
-- RequirementSets
-------------------------------------
INSERT INTO RequirementSets
		(RequirementSetId,									RequirementSetType)
VALUES	('PLOT_TWO_INCLUDE_ENCAMPMENT_TAIZONG',				'REQUIREMENTSET_TEST_ALL');
-------------------------------------
-- RequirementSetRequirements
-------------------------------------
INSERT INTO RequirementSetRequirements
		(RequirementSetId,									RequirementId)
VALUES	('PLOT_TWO_INCLUDE_ENCAMPMENT_TAIZONG',				'REQUIRES_PLOT_WITHIN_TWO_ENCAMPMENT');
-------------------------------------
-- Requirements
-------------------------------------
INSERT INTO Requirements
		(RequirementId,										RequirementType)
VALUES	('REQUIRES_PLOT_WITHIN_TWO_ENCAMPMENT',				'REQUIREMENT_PLOT_ADJACENT_DISTRICT_TYPE_MATCHES');
-------------------------------------
-- RequirementArguments
-------------------------------------
INSERT INTO RequirementArguments
		(RequirementId,										Name,							Value)
VALUES	('REQUIRES_PLOT_WITHIN_TWO_ENCAMPMENT',				'DistrictType',					'DISTRICT_ENCAMPMENT'),
		('REQUIRES_PLOT_WITHIN_TWO_ENCAMPMENT',				'MinRange',						0),
		('REQUIRES_PLOT_WITHIN_TWO_ENCAMPMENT',				'MaxRange',						2);
--==========================================================================================================================
-- AI
--==========================================================================================================================
-- AiListTypes
-------------------------------------	
INSERT INTO AiListTypes	
		(ListType)
VALUES	('Ant_Taizong_Wonders'),
		('Ant_Taizong_Civics'),
		('Ant_Taizong_Techs'),
		('ZhenguanEncampmentPreference'),
		('ZhenguanCommercialHubPreference');
-------------------------------------
-- AiLists 
-------------------------------------
INSERT INTO AiLists	
		(ListType,								AgendaType,										System)
VALUES	('Ant_Taizong_Wonders',					'TRAIT_AGENDA_ANT_HEAVENLY_KHAGAN',				'Buildings'),
		('Ant_Taizong_Civics',					'TRAIT_AGENDA_ANT_HEAVENLY_KHAGAN',				'Civics'),
		('Ant_Taizong_Techs',					'TRAIT_AGENDA_ANT_HEAVENLY_KHAGAN',				'Technologies'),
		('ZhenguanCommercialHubPreference',		'TRAIT_AGENDA_ANT_HEAVENLY_KHAGAN',				'Districts'),
		('ZhenguanEncampmentPreference',		'TRAIT_AGENDA_ANT_HEAVENLY_KHAGAN',				'Districts'),
		('MoneyGrubberGoldPreference',			'TRAIT_AGENDA_ANT_HEAVENLY_KHAGAN',				'Yields');	
-------------------------------------		
-- AiFavoredItems 
-------------------------------------
INSERT INTO AiFavoredItems	
		(ListType,							Item)
VALUES	('Ant_Taizong_Wonders',				'BUILDING_ALHAMBRA'),
		('Ant_Taizong_Wonders',				'BUILDING_BIG_BEN'),
		('Ant_Taizong_Wonders',				'BUILDING_COLOSSUS'),
		('Ant_Taizong_Wonders',				'BUILDING_GREAT_ZIMBABWE'),
		('Ant_Taizong_Wonders',				'BUILDING_TERRACOTTA_ARMY'),

		('Ant_Taizong_Civics',				'CIVIC_FOREIGN_TRADE'),
		('Ant_Taizong_Civics',				'CIVIC_MILITARY_TRADITION'),
		('Ant_Taizong_Civics',				'CIVIC_MILITARY_TRAINING'),
		('Ant_Taizong_Civics',				'CIVIC_GUILDS'),
		('Ant_Taizong_Civics',				'CIVIC_MERCENARIES'),
		('Ant_Taizong_Civics',				'CIVIC_MERCANTILISM'),

		('Ant_Taizong_Techs',				'TECH_BRONZE_WORKING'),
		('Ant_Taizong_Techs',				'TECH_MASONRY'),
		('Ant_Taizong_Techs',				'TECH_CASTLES'),
		('Ant_Taizong_Techs',				'TECH_FLIGHT'),
		('Ant_Taizong_Techs',				'TECH_CURRENCY'),
		('Ant_Taizong_Techs',				'TECH_MILITARY_ENGINEERING'),
		('Ant_Taizong_Techs',				'TECH_BANKING'),
		('Ant_Taizong_Techs',				'TECH_MILITARY_SCIENCE'),
		('Ant_Taizong_Techs',				'TECH_ECONOMICS');

INSERT INTO AiFavoredItems	
		(ListType,							Item,							Favored)
VALUES	('ZhenguanCommercialHubPreference',	'DISTRICT_COMMERCIAL_HUB',		1),
		('ZhenguanEncampmentPreference',	'DISTRICT_ANT_PROTECTORATE',	1);
--==========================================================================================================================
-- CivilizationLeaders
--==========================================================================================================================
INSERT INTO CivilizationLeaders
		(LeaderType, 				CivilizationType,			CapitalName)
VALUES  ('LEADER_ANT_TAIZONG',		'CIVILIZATION_CHINA',		'LOC_CITY_NAME_XIAN');
--==========================================================================================================================
--==========================================================================================================================