--==========================================================================================================================
-- Districts
--==========================================================================================================================
-- Types
-------------------------------------	
INSERT INTO Types	
		(Type,												Kind)
VALUES	('TRAIT_LEADER_DISTRICT_ANT_PROTECTORATE',			'KIND_TRAIT');
-------------------------------------			
-- Traits			
-------------------------------------				
INSERT INTO Traits				
		(TraitType,										Name,										Description)
VALUES	('TRAIT_LEADER_DISTRICT_ANT_PROTECTORATE',		'LOC_DISTRICT_ANT_PROTECTORATE_NAME',		'LOC_DISTRICT_ANT_PROTECTORATE_DESCRIPTION');

-------------------------------------
-- CivilizationTraits
-------------------------------------	
INSERT INTO LeaderTraits	
		(TraitType,											LeaderType)
VALUES	('TRAIT_LEADER_DISTRICT_ANT_PROTECTORATE',			'LEADER_ANT_TAIZONG');
-------------------------------------
-- Types
-------------------------------------
INSERT INTO Types	
		(Type,									Kind)
VALUES	('DISTRICT_ANT_PROTECTORATE',			'KIND_DISTRICT');
-------------------------------------
-- Districts
-------------------------------------
INSERT INTO Districts
			(DistrictType,					Name,									Description,									TraitType,									Cost,		PrereqTech,			Aqueduct,		PlunderType,		PlunderAmount,		AdvisorType,		CostProgressionModel,		CostProgressionParam1,		RequiresPlacement,		RequiresPopulation,		NoAdjacentCity,		InternalOnly,		ZOC,		CaptureRemovesBuildings,		CaptureRemovesCityDefenses,		MilitaryDomain,		TravelTime,		CityStrengthModifier,	Housing,	OnePerCity,		HitPoints,	Maintenance)
SELECT		'DISTRICT_ANT_PROTECTORATE',	'LOC_DISTRICT_ANT_PROTECTORATE_NAME',	'LOC_DISTRICT_ANT_PROTECTORATE_DESCRIPTION',	'TRAIT_LEADER_DISTRICT_ANT_PROTECTORATE',	Cost/2,		PrereqTech,			Aqueduct,		PlunderType,		PlunderAmount,		AdvisorType,		CostProgressionModel,		CostProgressionParam1,		RequiresPlacement,		RequiresPopulation,		NoAdjacentCity,		InternalOnly,		ZOC,		CaptureRemovesBuildings,		CaptureRemovesCityDefenses,		MilitaryDomain,		TravelTime,		CityStrengthModifier,	Housing,	OnePerCity,		HitPoints,	Maintenance
FROM Districts WHERE DistrictType = 'DISTRICT_ENCAMPMENT';
-------------------------------------
-- DistrictReplaces
-------------------------------------
INSERT INTO DistrictReplaces
			(CivUniqueDistrictType,				ReplacesDistrictType)
VALUES		('DISTRICT_ANT_PROTECTORATE',		'DISTRICT_ENCAMPMENT');
-------------------------------------
-- District_GreatPersonPoints
-------------------------------------
INSERT INTO District_GreatPersonPoints
			(DistrictType,					GreatPersonClassType,				PointsPerTurn)
VALUES 		('DISTRICT_ANT_PROTECTORATE',	'GREAT_PERSON_CLASS_GENERAL',		1);
-----------------------------------------------------------------------------------
-- District_CitizenYieldChanges
-----------------------------------------------------------------------------------
INSERT INTO District_CitizenYieldChanges
			(DistrictType,						YieldType,				YieldChange)
VALUES		('DISTRICT_ANT_PROTECTORATE',		'YIELD_PRODUCTION',		1),
			('DISTRICT_ANT_PROTECTORATE',		'YIELD_CULTURE',		1),
			('DISTRICT_ANT_PROTECTORATE',		'YIELD_GOLD',			2);
-------------------------------------
-- District_TradeRouteYields
-------------------------------------
INSERT INTO District_TradeRouteYields
			(DistrictType,					YieldType,			YieldChangeAsOrigin,	YieldChangeAsDomesticDestination,	YieldChangeAsInternationalDestination)
SELECT 		'DISTRICT_ANT_PROTECTORATE',	YieldType,			YieldChangeAsOrigin,	YieldChangeAsDomesticDestination,	YieldChangeAsInternationalDestination
FROM District_TradeRouteYields WHERE DistrictType = 'DISTRICT_ENCAMPMENT';
-----------------------------------------------------------------------------------
-- District_Adjacencies
-----------------------------------------------------------------------------------
INSERT INTO District_Adjacencies
			(DistrictType,						YieldChangeId)
VALUES 		('DISTRICT_ANT_PROTECTORATE',		'District_Gold'),
			('DISTRICT_ANT_PROTECTORATE',		'Protectorate_Adj_GW'),
			('DISTRICT_ANT_PROTECTORATE',		'Protectorate_Adj_Hub'),
			('DISTRICT_ANT_PROTECTORATE',		'Protectorate_Adj_Oasis'),
			('DISTRICT_ANT_PROTECTORATE',		'Protectorate_Adj_River');
-----------------------------------------------------------------------------------
-- Adjacency_YieldChanges
-----------------------------------------------------------------------------------
INSERT INTO Adjacency_YieldChanges
		(ID,							Description,						YieldType,			YieldChange,		TilesRequired,	OtherDistrictAdjacent,		AdjacentImprovement)
VALUES	('Protectorate_Adj_GW',			'LOC_GW_PROTECTORATE_GOLD',			'YIELD_GOLD',		1,					2,				0,							'IMPROVEMENT_GREAT_WALL');

INSERT INTO Adjacency_YieldChanges
		(ID,							Description,						YieldType,			YieldChange,		TilesRequired,	OtherDistrictAdjacent,		AdjacentDistrict)
VALUES	('Protectorate_Adj_Hub',		'LOC_HUB_PROTECTORATE_GOLD',		'YIELD_GOLD',		2,					1,				0,							'DISTRICT_COMMERCIAL_HUB');

INSERT INTO Adjacency_YieldChanges
		(ID,							Description,						YieldType,			YieldChange,		TilesRequired,	OtherDistrictAdjacent,		AdjacentFeature)
VALUES	('Protectorate_Adj_Oasis',		'LOC_OASIS_PROTECTORATE_GOLD',		'YIELD_GOLD',		2,					1,				0,							'FEATURE_OASIS');

INSERT INTO Adjacency_YieldChanges
		(ID,							Description,						YieldType,			YieldChange,		TilesRequired,	OtherDistrictAdjacent,		AdjacentRiver)
VALUES	('Protectorate_Adj_River',		'LOC_RIVER_PROTECTORATE_GOLD',		'YIELD_GOLD',		1,					1,				0,							1);
-------------------------------------
-- District_CitizenYieldChanges
-------------------------------------
-------------------------------------
-- District_ValidTerrains
-------------------------------------
-------------------------------------
-- DistrictModifiers
-------------------------------------
INSERT INTO DistrictModifiers
			(DistrictType,						ModifierId)
VALUES 		('DISTRICT_ANT_PROTECTORATE',		'ANT_PROTECTORATE_BARRACKS_GOLD_YIELD'),
			('DISTRICT_ANT_PROTECTORATE',		'ANT_PROTECTORATE_STABLE_GOLD_YIELD'),
			('DISTRICT_ANT_PROTECTORATE',		'ANT_PROTECTORATE_ARMORY_GOLD_YIELD'),
			('DISTRICT_ANT_PROTECTORATE',		'ANT_PROTECTORATE_MILITARY_ACADEMY_GOLD_YIELD'),
			('DISTRICT_ANT_PROTECTORATE',		'ANT_PROTECTORATE_BARRACKS_PRODUCTION_YIELD'),
			('DISTRICT_ANT_PROTECTORATE',		'ANT_PROTECTORATE_STABLE_PRODUCTION_YIELD'),
			('DISTRICT_ANT_PROTECTORATE',		'ANT_PROTECTORATE_ARMORY_PRODUCTION_YIELD'),
			('DISTRICT_ANT_PROTECTORATE',		'ANT_PROTECTORATE_MILITARY_ACADEMY_PRODUCTION_YIELD');
--==========================================================================================================================
-- Modifiers
--==========================================================================================================================
-- Modifiers
-------------------------------------
INSERT INTO Modifiers	
		(ModifierId,											ModifierType)
VALUES	('ANT_PROTECTORATE_BARRACKS_GOLD_YIELD',				'MODIFIER_BUILDING_YIELD_CHANGE'),
		('ANT_PROTECTORATE_STABLE_GOLD_YIELD',					'MODIFIER_BUILDING_YIELD_CHANGE'),
		('ANT_PROTECTORATE_ARMORY_GOLD_YIELD',					'MODIFIER_BUILDING_YIELD_CHANGE'),
		('ANT_PROTECTORATE_MILITARY_ACADEMY_GOLD_YIELD',		'MODIFIER_BUILDING_YIELD_CHANGE'),
		('ANT_PROTECTORATE_BARRACKS_PRODUCTION_YIELD',			'MODIFIER_BUILDING_YIELD_CHANGE'),
		('ANT_PROTECTORATE_STABLE_PRODUCTION_YIELD',			'MODIFIER_BUILDING_YIELD_CHANGE'),
		('ANT_PROTECTORATE_ARMORY_PRODUCTION_YIELD',			'MODIFIER_BUILDING_YIELD_CHANGE'),
		('ANT_PROTECTORATE_MILITARY_ACADEMY_PRODUCTION_YIELD',	'MODIFIER_BUILDING_YIELD_CHANGE');
-------------------------------------
-- ModifierArguments
-------------------------------------
INSERT INTO ModifierArguments
		(ModifierId,											Name,				Value)
VALUES	('ANT_PROTECTORATE_BARRACKS_GOLD_YIELD',				'BuildingType',		'BUILDING_BARRACKS'),
		('ANT_PROTECTORATE_BARRACKS_GOLD_YIELD',				'YieldType',		'YIELD_GOLD'),
		('ANT_PROTECTORATE_BARRACKS_GOLD_YIELD',				'Amount',			2),
		
		('ANT_PROTECTORATE_STABLE_GOLD_YIELD',					'BuildingType',		'BUILDING_STABLE'),
		('ANT_PROTECTORATE_STABLE_GOLD_YIELD',					'YieldType',		'YIELD_GOLD'),
		('ANT_PROTECTORATE_STABLE_GOLD_YIELD',					'Amount',			2),
		
		('ANT_PROTECTORATE_ARMORY_GOLD_YIELD',					'BuildingType',		'BUILDING_ARMORY'),
		('ANT_PROTECTORATE_ARMORY_GOLD_YIELD',					'YieldType',		'YIELD_GOLD'),
		('ANT_PROTECTORATE_ARMORY_GOLD_YIELD',					'Amount',			2),
		
		('ANT_PROTECTORATE_MILITARY_ACADEMY_GOLD_YIELD',		'BuildingType',		'BUILDING_MILITARY_ACADEMY'),
		('ANT_PROTECTORATE_MILITARY_ACADEMY_GOLD_YIELD',		'YieldType',		'YIELD_GOLD'),
		('ANT_PROTECTORATE_MILITARY_ACADEMY_GOLD_YIELD',		'Amount',			2),
		
		('ANT_PROTECTORATE_BARRACKS_PRODUCTION_YIELD',			'BuildingType',		'BUILDING_BARRACKS'),
		('ANT_PROTECTORATE_BARRACKS_PRODUCTION_YIELD',			'YieldType',		'YIELD_PRODUCTION'),
		('ANT_PROTECTORATE_BARRACKS_PRODUCTION_YIELD',			'Amount',			1),
		
		('ANT_PROTECTORATE_STABLE_PRODUCTION_YIELD',			'BuildingType',		'BUILDING_STABLE'),
		('ANT_PROTECTORATE_STABLE_PRODUCTION_YIELD',			'YieldType',		'YIELD_PRODUCTION'),
		('ANT_PROTECTORATE_STABLE_PRODUCTION_YIELD',			'Amount',			1),
		
		('ANT_PROTECTORATE_ARMORY_PRODUCTION_YIELD',			'BuildingType',		'BUILDING_ARMORY'),
		('ANT_PROTECTORATE_ARMORY_PRODUCTION_YIELD',			'YieldType',		'YIELD_PRODUCTION'),
		('ANT_PROTECTORATE_ARMORY_PRODUCTION_YIELD',			'Amount',			1),
		
		('ANT_PROTECTORATE_MILITARY_ACADEMY_PRODUCTION_YIELD',	'BuildingType',		'BUILDING_MILITARY_ACADEMY'),
		('ANT_PROTECTORATE_MILITARY_ACADEMY_PRODUCTION_YIELD',	'YieldType',		'YIELD_PRODUCTION'),
		('ANT_PROTECTORATE_MILITARY_ACADEMY_PRODUCTION_YIELD',	'Amount',			1);
--==========================================================================================================================
-- DynamicModifiers
--==========================================================================================================================
--==========================================================================================================================
-- Requirements
--==========================================================================================================================
-- RequirementSets
-------------------------------------
-------------------------------------
-- RequirementSetRequirements
-------------------------------------
-------------------------------------
-- Requirements
-------------------------------------
-------------------------------------
-- RequirementArguments
-------------------------------------
--==========================================================================================================================
--==========================================================================================================================