--If you want to customize it
bProductionCost = true --base culture gained on production - if false, will base on combat strength instead
iPercentModifier = 0.25 --percent of the production/strength
print("lua loaded!")
function HasLeaderTrait(leaderType, traitType) --utility
	for row in GameInfo.LeaderTraits() do
		if (row.LeaderType == leaderType and row.TraitType == traitType) then return true end
	end
	return false
end

local sQianlongTrait = "TRAIT_LEADER_ANT_IMPERIAL_HUNT" --put your trait here as defined in the sql


--Valid units
local tMounted = {}
local tQuery = DB.Query("SELECT UnitType, Combat, Cost FROM Units WHERE PromotionClass IN ('PROMOTION_CLASS_LIGHT_CAVALRY', 'PROMOTION_CLASS_HEAVY_CAVALRY')")
for key, value in ipairs(tQuery) do
	table.insert(tMounted, {["UnitID"] = GameInfo.Units[value.UnitType].Index, ["Combat"] = value.Combat, ["Cost"] = value.Cost})
end

function Relic_Culture_On_Production(playerID, cityID, orderType, productionType, bCancelled)
	if orderType == 0 and (not bCancelled) then
		local pPlayer = Players[playerID]
		local pPlayerConfig = PlayerConfigurations[playerID]
		local sLeaderType = pPlayerConfig:GetLeaderTypeName()
		if HasLeaderTrait(sLeaderType, sQianlongTrait) then	
			local pPlayerUnits = pPlayer:GetUnits()
			local pUnit = pPlayerUnits:FindID(unitID)
			local pPlayerCities = pPlayer:GetCities()
			local pCity = pPlayerCities:FindID(cityID)
			for key, value in ipairs(tMounted) do
				if value.UnitID == productionType then
					print("Mounted unit!")
					iCultureValue = 0
					if bProductionCost then --jesus that's a lot of nested statements maybe i should go kms
						iCultureValue = value.Cost
					else
						iCultureValue = value.Combat
					end
					print(iCultureValue)
					iCultureValue = iCultureValue * iPercentModifier
					pPlayer:GetCulture():ChangeCurrentCulturalProgress(iCultureValue)
					Game.AddWorldViewText(playerID, Locale.Lookup("[COLOR_FLOAT_CULTURE]+{1_Value}  [ICON_CULTURE][ENDCOLOR]", iCultureValue), pCity:GetX(), pCity:GetY(), 0)
					print("Adding culture")
					break
				else
					print("No mounted unit :(")
				end
			end
		end
	end
end

Events.CityProductionCompleted.Add(Relic_Culture_On_Production)
