--==========================================================================================================================
-- USER SETTINGS (THIS IS NEEDED IN MOST CASES)
--==========================================================================================================================
-- JFD_GlobalUserSettings
------------------------------------------------------------
CREATE TABLE IF NOT EXISTS 
JFD_GlobalUserSettings (
	Type 				text 			default null,
	Value 				integer 		default 1);

UPDATE Leaders
SET Name = 'LOC_LEADER_ANT_QIANLONG_RWF'
WHERE LeaderType = 'LEADER_ANT_QIANLONG'
AND EXISTS (SELECT * FROM JFD_GlobalUserSettings WHERE Type = 'JFD_RWF_GOVERNMENT_CORE_LEADER_CHANGES_QIN' AND Value = 1);

CREATE TRIGGER Ant_ChinaLeader_RwF_Rename_Qianlong
AFTER INSERT ON JFD_GlobalUserSettings
WHEN NEW.Type = 'JFD_RWF_GOVERNMENT_CORE_LEADER_CHANGES_QIN' AND NEW.Value = 1
BEGIN
    UPDATE Leaders
    SET Name = 'LOC_LEADER_ANT_QIANLONG_RWF'
    WHERE LeaderType = 'LEADER_ANT_QIANLONG';
END;
--==========================================================================================================================
-- DELIVERATOR MOAR UNITS (8342b98d-80c7-4002-87bb-419646bd9b54)
-- DELIVERATOR MOAR UNITS (CORE ONLY) (860265f1-73df-47d9-b5dc-c9cdc6b1489a)
--==========================================================================================================================
--==========================================================================================================================
-- GEDEMON YNAEMP (36e88483-48fe-4545-b85f-bafc50dde315)
--==========================================================================================================================
-- StartPosition 
------------------------------------------------------------	
CREATE TABLE IF NOT EXISTS StartPosition (MapName TEXT, Civilization TEXT, Leader TEXT, X INT default 0, Y INT default 0);
INSERT INTO StartPosition
		(Civilization,				Leader,						MapName,			X,		Y)
VALUES	('CIVILIZATION_CHINA',		'LEADER_ANT_QIANLONG',		'GiantEarth',		83,		65),
		('CIVILIZATION_CHINA',		'LEADER_ANT_QIANLONG',		'GreatestEarthMap',	86,		55),
		('CIVILIZATION_CHINA',		'LEADER_ANT_QIANLONG',		'LargestEarth',		111,	83);
--==========================================================================================================================
-- JFD RULE WITH FAITH (650ff782-47b4-4b46-93fb-00bef8da8b8e)
--==========================================================================================================================
-- Leader_Titles 
--------------------------------------------------------------------------------------------------------------------------	
CREATE TABLE IF NOT EXISTS 
	Leader_Titles (
	LeaderType  					text 		 	default null,
	GovernmentType					text 	 		default null,
	LeaderTitle						text			default null,
	PolicyType  					text 		 	default null,
	UseFeminine						boolean			default 0,
	TitleIsFullName					boolean			default 0);	
	
INSERT INTO Leader_Titles
		(LeaderType, 				GovernmentType, LeaderTitle, PolicyType)
SELECT	'LEADER_ANT_QIANLONG', 		GovernmentType, LeaderTitle, PolicyType
FROM Leader_Titles WHERE LeaderType = 'LEADER_QIN';
DELETE FROM Leader_Titles WHERE LeaderType = 'LEADER_ANT_QIANLONG' AND GovernmentType IS NOT null AND GovernmentType NOT IN (SELECT GovernmentType FROM Governments);
DELETE FROM Leader_Titles WHERE LeaderType = 'LEADER_ANT_QIANLONG' AND PolicyType IS NOT null AND PolicyType NOT IN (SELECT PolicyType FROM Policies);