--==========================================================================================================================
-- LOADING INFO
--==========================================================================================================================
-- LoadingInfo
-------------------------------------	
INSERT INTO LoadingInfo	
		(LeaderType,					ForegroundImage,						BackgroundImage,				PlayDawnOfManAudio)
VALUES	('LEADER_ANT_QIANLONG',			'LEADER_ANT_QIANLONG_NEUTRAL',			'LEADER_CLEOPATRA_BACKGROUND',	0);	
--==========================================================================================================================
-- DIPLOMACY INFO
--==========================================================================================================================
-- DiplomacyInfo
-------------------------------------	
-- INSERT INTO DiplomacyInfo	
-- 			(Type,						BackgroundImage)
-- VALUES	('LEADER_ANT_QIANLONG',		'FALLBACK_NEUTRAL_ANT_QIANLONG.dds');
--==========================================================================================================================
-- COLOURS
--==========================================================================================================================
-- PlayerColors
-------------------------------------	
INSERT INTO PlayerColors	
		(Type,							Usage,				PrimaryColor, 							SecondaryColor,							TextColor)
VALUES	('LEADER_ANT_QIANLONG',			'Unique',			'COLOR_PLAYER_ANT_QIANLONG_PRIMARY',	'COLOR_PLAYER_ANT_QIANLONG_SECONDARY', 	'COLOR_PLAYER_WHITE_TEXT');	

INSERT INTO Colors 
		(Type, 										Red, 	Green, 	Blue, 	Alpha)
VALUES	('COLOR_PLAYER_ANT_QIANLONG_PRIMARY', 		0.698,	0.220,	0.325,	1),
		('COLOR_PLAYER_ANT_QIANLONG_SECONDARY', 	0.894,	0.596,	0.208,	1);
--==========================================================================================================================
-- LEADERS
--==========================================================================================================================
-- Types
-------------------------------------	
INSERT INTO Types	
		(Type,							Kind)
VALUES	('LEADER_ANT_QIANLONG',			'KIND_LEADER');	
-------------------------------------
-- Leaders
-------------------------------------	
INSERT INTO Leaders	
		(LeaderType,					Name,												InheritFrom,		SceneLayers)
VALUES	('LEADER_ANT_QIANLONG',			'LOC_LEADER_ANT_QIANLONG_NAME',						'LEADER_DEFAULT',	4);	
-------------------------------------
-- LeaderQuotes
-------------------------------------	
INSERT INTO LeaderQuotes	
		(LeaderType,					Quote)
VALUES	('LEADER_ANT_QIANLONG',			'LOC_LEADER_ANT_QIANLONG_QUOTE');	
-------------------------------------
-- LeaderTraits
-------------------------------------	
INSERT INTO LeaderTraits	
		(LeaderType,					TraitType)
VALUES	('LEADER_ANT_QIANLONG',			'TRAIT_LEADER_ANT_IMPERIAL_HUNT');	
-- -------------------------------------
-- HistoricalAgendas
-- -------------------------------------	
INSERT INTO HistoricalAgendas	
		(LeaderType,					AgendaType)
VALUES	('LEADER_ANT_QIANLONG',			'AGENDA_ANT_SIKU_QUANSHU');	
-- -------------------------------------
-- FavoredReligions
-- -------------------------------------	
INSERT OR REPLACE INTO FavoredReligions
       (LeaderType,						ReligionType)
VALUES   ('LEADER_ANT_QIANLONG',		    'RELIGION_CONFUCIANISM');

CREATE TRIGGER AntQianlong_HR
AFTER INSERT ON Religions WHEN 'RELIGION_ZOROASTRIANISM' = NEW.ReligionType
BEGIN
   INSERT OR REPLACE INTO FavoredReligions
		    (LeaderType,				ReligionType)
   VALUES   ('LEADER_ANT_QIANLONG',		'RELIGION_CONFUCIANISM');
END;
--==========================================================================================================================
-- TRAITS
--==========================================================================================================================
-- Types
-------------------------------------	
INSERT INTO Types	
		(Type,													Kind)
VALUES	('TRAIT_LEADER_ANT_IMPERIAL_HUNT',						'KIND_TRAIT');	
-------------------------------------			
-- Traits			
-------------------------------------				
INSERT INTO Traits				
		(TraitType,												Name,												Description)
VALUES	('TRAIT_LEADER_ANT_IMPERIAL_HUNT',						'LOC_TRAIT_LEADER_ANT_IMPERIAL_HUNT_NAME',			'LOC_TRAIT_LEADER_ANT_IMPERIAL_HUNT_DESCRIPTION');
-------------------------------------
-- TraitModifiers
-------------------------------------
INSERT INTO TraitModifiers			
		(TraitType,												ModifierId)
VALUES	('TRAIT_LEADER_ANT_IMPERIAL_HUNT',						'ANT_SUMMER_PALACE_PLACEMENT_CULTURE'),
		('TRAIT_LEADER_ANT_IMPERIAL_HUNT',						'ANT_IMPERIAL_HUNT_FLANKING_MODIFIER'),
		('TRAIT_LEADER_ANT_IMPERIAL_HUNT',						'ANT_IMPERIAL_HUNT_NO_STRENGTH_REDUCTION');
--==========================================================================================================================
-- AGENDAS
--==========================================================================================================================
-- Agendas			
-------------------------------------				
INSERT INTO Agendas				
		(AgendaType,									Name,											Description)
VALUES	('AGENDA_ANT_SIKU_QUANSHU',						'LOC_AGENDA_ANT_SIKU_QUANSHU_NAME',				'LOC_AGENDA_ANT_SIKU_QUANSHU_DESCRIPTION');	
-------------------------------------
-- Types
-------------------------------------	
INSERT INTO Types	
		(Type,											Kind)
VALUES	('TRAIT_AGENDA_ANT_SIKU_QUANSHU',				'KIND_TRAIT');
-------------------------------------			
-- AgendaTraits			
-------------------------------------				
INSERT INTO AgendaTraits				
		(AgendaType,									TraitType)
VALUES	('AGENDA_ANT_SIKU_QUANSHU',						'TRAIT_AGENDA_ANT_SIKU_QUANSHU');
-------------------------------------			
-- ExclusiveAgendas
-------------------------------------				
-------------------------------------			
-- Traits			
-------------------------------------				
INSERT INTO Traits				
		(TraitType,										Name,											Description)
VALUES	('TRAIT_AGENDA_ANT_SIKU_QUANSHU',				'LOC_AGENDA_ANT_SIKU_QUANSHU_NAME',			'LOC_AGENDA_ANT_SIKU_QUANSHU_DESCRIPTION');
-------------------------------------
-- TraitModifiers
-------------------------------------
INSERT INTO TraitModifiers			
		(TraitType,													ModifierId)
VALUES	('TRAIT_AGENDA_ANT_SIKU_QUANSHU', 							'MODIFIER_AGENDA_ANT_SIKU_QUANSHU_HIGH_CULTURE'),
		('TRAIT_AGENDA_ANT_SIKU_QUANSHU', 							'MODIFIER_AGENDA_ANT_SIKU_QUANSHU_LOW_CULTURE');
--==========================================================================================================================
-- MODIFIERS 
--==========================================================================================================================
-- Modifiers
-------------------------------------
INSERT INTO Modifiers	
		(ModifierId,										ModifierType,																SubjectRequirementSetId)
VALUES	('ANT_SUMMER_PALACE_PLACEMENT_CULTURE',				'MODIFIER_PLAYER_DISTRICT_CREATE_YIELD',									null),
		('ANT_IMPERIAL_HUNT_FLANKING_MODIFIER',				'MODIFIER_PLAYER_UNITS_ADJUST_FLANKING_BONUS_MODIFIER',						'UNIT_IS_CAVALRY_REQUIREMENTS'),
		('ANT_IMPERIAL_HUNT_NO_STRENGTH_REDUCTION',			'MODIFIER_PLAYER_UNITS_ADJUST_STRENGTH_REDUCTION_FOR_DAMAGE_MODIFIER',		'UNIT_IS_CAVALRY_REQUIREMENTS'),
		('MODIFIER_AGENDA_ANT_SIKU_QUANSHU_HIGH_CULTURE',	'MODIFIER_PLAYER_DIPLOMACY_SIMPLE_MODIFIER',								'PLAYER_HAS_HIGH_CULTURE'),
		('MODIFIER_AGENDA_ANT_SIKU_QUANSHU_LOW_CULTURE',	'MODIFIER_PLAYER_DIPLOMACY_SIMPLE_MODIFIER',								'ANT_PLAYER_HAS_LOW_CULTURE_LOW_GREATPEOPLE');
-------------------------------------
-- ModifierArguments
-------------------------------------
INSERT INTO ModifierArguments
		(ModifierId,										Name,													Value)
VALUES	('ANT_SUMMER_PALACE_PLACEMENT_CULTURE',				'DistrictType',						'DISTRICT_ANT_SUMMER_PALACE'),
		('ANT_SUMMER_PALACE_PLACEMENT_CULTURE',				'Amount',							60),
		('ANT_SUMMER_PALACE_PLACEMENT_CULTURE',				'YieldType',						'YIELD_CULTURE'),
		('ANT_SUMMER_PALACE_PLACEMENT_CULTURE',				'YieldBasedOnAppeal',				1),
		('ANT_IMPERIAL_HUNT_FLANKING_MODIFIER',				'Percent',							50),
		('ANT_IMPERIAL_HUNT_NO_STRENGTH_REDUCTION',			'Amount',							100),

		('MODIFIER_AGENDA_ANT_SIKU_QUANSHU_HIGH_CULTURE',	'InitialValue',						-12),
		('MODIFIER_AGENDA_ANT_SIKU_QUANSHU_HIGH_CULTURE',	'StatementKey',						'LOC_DIPLO_WARNING_LEADER_ANT_QIANLONG_REASON_ANY'),
		('MODIFIER_AGENDA_ANT_SIKU_QUANSHU_HIGH_CULTURE',	'SimpleModifierDescription',		'LOC_DIPLO_MODIFIER_ANT_SIKU_QUANSHU_HIGH_CULTURE'),

		('MODIFIER_AGENDA_ANT_SIKU_QUANSHU_LOW_CULTURE',	'InitialValue',						8),
		('MODIFIER_AGENDA_ANT_SIKU_QUANSHU_LOW_CULTURE',	'StatementKey',						'LOC_DIPLO_WARNING_LEADER_ANT_QIANLONG_REASON_ANY'),
		('MODIFIER_AGENDA_ANT_SIKU_QUANSHU_LOW_CULTURE',	'SimpleModifierDescription',		'LOC_DIPLO_MODIFIER_ANT_SIKU_QUANSHU_LOW_CULTURE');
-------------------------------------
-- Types
-------------------------------------
-------------------------------------
-- DynamicModifiers
-------------------------------------
-------------------------------------
-- ModifierStrings
-------------------------------------
INSERT INTO ModifierStrings
		(ModifierId,													Context,						Text)
VALUES	('MODIFIER_AGENDA_ANT_SIKU_QUANSHU_HIGH_CULTURE',				'Sample',						'LOC_TOOLTIP_SAMPLE_DIPLOMACY_ALL'),
		('MODIFIER_AGENDA_ANT_SIKU_QUANSHU_LOW_CULTURE',				'Sample',						'LOC_TOOLTIP_SAMPLE_DIPLOMACY_ALL');
--==========================================================================================================================
-- REQUIREMENTS
--==========================================================================================================================
-- RequirementSets
-------------------------------------
-- RequirementSets
-------------------------------------
INSERT INTO RequirementSets
		(RequirementSetId,												RequirementSetType)
VALUES	('ANT_PLAYER_HAS_LOW_CULTURE_LOW_GREATPEOPLE',					'REQUIREMENTSET_TEST_ALL');
-------------------------------------
-- RequirementSetRequirements
-------------------------------------
INSERT INTO RequirementSetRequirements
		(RequirementSetId,												RequirementId)
VALUES	('ANT_PLAYER_HAS_LOW_CULTURE_LOW_GREATPEOPLE',					'REQUIRES_HAS_LOW_CULTURE'),
		('ANT_PLAYER_HAS_LOW_CULTURE_LOW_GREATPEOPLE',					'REQUIRES_LAGS_GREAT_PEOPLE'),
		('ANT_PLAYER_HAS_LOW_CULTURE_LOW_GREATPEOPLE',					'REQUIRES_MAJOR_CIV_OPPONENT'),
		('ANT_PLAYER_HAS_LOW_CULTURE_LOW_GREATPEOPLE',					'REQUIRES_MET_10_TURNS_AGO');
--==========================================================================================================================
-- AI
--==========================================================================================================================
-- AiListTypes
-------------------------------------	
INSERT INTO AiListTypes	
		(ListType)
VALUES	('Ant_Qianlong_Wonders'),
		('Ant_Qianlong_Civics'),
		('Ant_Qianlong_Techs'),
		('Ant_Qianlong_UnitBuilds'),
		('Ant_Qianlong_SummerPalacePreference');
-------------------------------------
-- AiLists 
-------------------------------------
INSERT INTO AiLists	
		(ListType,								AgendaType,										System)
VALUES	('Ant_Qianlong_Wonders',				'TRAIT_AGENDA_ANT_SIKU_QUANSHU',				'Buildings'),
		('Ant_Qianlong_Civics',					'TRAIT_AGENDA_ANT_SIKU_QUANSHU',				'Civics'),
		('Ant_Qianlong_Techs',					'TRAIT_AGENDA_ANT_SIKU_QUANSHU',				'Technologies'),
		('CultureLoverCulturePreference',		'TRAIT_AGENDA_ANT_SIKU_QUANSHU',				'Yields'),
		('FavorCulturalVictory',				'TRAIT_AGENDA_ANT_SIKU_QUANSHU',				'Strategies'),
		('Ant_Qianlong_UnitBuilds',				'TRAIT_AGENDA_ANT_SIKU_QUANSHU',				'UnitPromotionClasses'),
		('Ant_Qianlong_SummerPalacePreference',	'TRAIT_AGENDA_ANT_SIKU_QUANSHU',				'Districts');	
-------------------------------------		
-- AiFavoredItems 
-------------------------------------
INSERT INTO AiFavoredItems	
		(ListType,							Item)
VALUES	('Ant_Qianlong_Wonders',			'BUILDING_BROADWAY'),
		('Ant_Qianlong_Wonders',			'BUILDING_COLOSSEUM'),
		('Ant_Qianlong_Wonders',			'BUILDING_CRISTO_REDENTOR'),
		('Ant_Qianlong_Wonders',			'BUILDING_EIFFEL_TOWER'),
		('Ant_Qianlong_Wonders',			'BUILDING_FORBIDDEN_CITY'),
		('Ant_Qianlong_Wonders',			'BUILDING_ORACLE'),
		('Ant_Qianlong_Wonders',			'BUILDING_SYDNEY_OPERA_HOUSE'),
		('Ant_Qianlong_Wonders',			'BUILDING_AMPHITHEATER'),
		('Ant_Qianlong_Wonders',			'BUILDING_MUSEUM_ART'),

		('Ant_Qianlong_Civics',				'CIVIC_DRAMA_POETRY'),
		('Ant_Qianlong_Civics',				'CIVIC_HUMANISM'),
		('Ant_Qianlong_Civics',				'CIVIC_OPERA_BALLET'),
		('Ant_Qianlong_Civics',				'CIVIC_CIVIL_ENGINEERING'),

		('Ant_Qianlong_Techs',				'TECH_MASONRY'),
		('Ant_Qianlong_Techs',				'TECH_CASTLES'),
		('Ant_Qianlong_Techs',				'TECH_FLIGHT');
-------------------------------------		
-- AiFavoredItems: Favoured Districts/Units
-------------------------------------
INSERT INTO AiFavoredItems	
		(ListType,								Item,									Value)
VALUES	('Ant_Qianlong_UnitBuilds',				'PROMOTION_CLASS_LIGHT_CAVALRY',		1),
		('Ant_Qianlong_UnitBuilds',				'PROMOTION_CLASS_HEAVY_CAVALRY',		1),
		('Ant_Qianlong_SummerPalacePreference',	'DISTRICT_ANT_SUMMER_PALACE',			1);
--==========================================================================================================================
-- CivilizationLeaders
--==========================================================================================================================
INSERT INTO CivilizationLeaders
		(LeaderType, 				CivilizationType,			CapitalName)
VALUES  ('LEADER_ANT_QIANLONG',		'CIVILIZATION_CHINA',		'LOC_CITY_NAME_BEIJING');
--==========================================================================================================================
--==========================================================================================================================