!function($) {

    /* 设置日期语言 */
    function setDateLang(n) {
        switch (n) {
            // 阿拉伯语
            case 1:
                AudioConfig.language = 'ar';
                break;
            // 荷兰语
            case 2:
                AudioConfig.language = 'nl';
                break;
            // 英语
            case 3:
                AudioConfig.language = 'en';
                break;
            // 法语
            case 4:
                AudioConfig.language = 'fr';
                break;
            // 德语
            case 5:
                AudioConfig.language = 'de';
                break;
            // 意大利语
            case 6:
                AudioConfig.language = 'it';
                break;
            // 日语
            case 7:
                AudioConfig.language = 'ja';
                break;
            // 韩语
            case 8:
                AudioConfig.language = 'ko';
                break;
            // 波兰语
            case 9:
                AudioConfig.language = 'pl';
                break;
            // 葡萄牙语
            case 10:
                AudioConfig.language = 'pt';
                break;
            // 罗马尼亚语
            case 11:
                AudioConfig.language = 'ro';
                break;
            // 俄语
            case 12:
                AudioConfig.language = 'ru';
                break;
            // 简体中文
            case 13:
                AudioConfig.language = 'zh-cn';
                break;
            // 西班牙语
            case 14:
                AudioConfig.language = 'es';
                break;
            // 繁体中文
            case 15:
                AudioConfig.language = 'zh-tw';
                break;
            // 土耳其语
            case 16:
                AudioConfig.language = 'tr';
                break;
            // 默认汉语
            default:
                AudioConfig.language = 'zh_cn';
        }
    }

    window.wallpaperPropertyListener = {
        applyUserProperties: function (properties) {
            // 更换背景
            if (properties.image) {
                if (properties.image.value) {
                    $('body').css("background-image", "url('file:///" + properties.image.value + "')");

                } else {
                    $('body').css("background-image", "url(img/bg.png)");
                }
            }
            // 背景填充样式
            if (properties.image_fillStyle) {
                var size = '100% 100%';
                var repeat = 'no-repeat';
                switch  (properties.image_fillStyle.value) {
                    // 填充
                    case 1:
                        size = 'cover';
                        break;
                    // 适应
                    case 2:
                        size = 'contain';
                        break;
                    // 拉伸
                    case 3:
                        size = '100% 100%';
                        break;
                    // 平铺
                    case 4:
                        size = 'initial';
                        repeat = 'repeat';
                        break;
                    // 居中
                    case 5:
                        size = 'initial';
                        break;
                    // 默认适应
                    default:
                        size = 'contain';
                }
                $('body').css('background-size', size);
                $('body').css('background-repeat', repeat);
            }
            // 透明度
            if (properties.opacity) {
                AudioConfig.opacity = properties.opacity.value / 100;
            }
            // 颜色
            if (properties.color) {
                AudioConfig.color = properties.color.value.split(' ').map(function (c) {
                    return Math.ceil(c * 255)
                });
            }
            // 发光程度
            if (properties.shadowBlur) {
                AudioConfig.shadowBlur = properties.shadowBlur.value * 5;
            }
            // 旋转角度
            if (properties.audio_rotation) {
                AudioConfig.rotation = properties.audio_rotation.value / 10;
            }
            // 圆环样式
            if (properties.audio_RingStyle) {
                switch (properties.audio_RingStyle.value) {
                    case 1:
                        AudioConfig.isRing = true;
                        AudioConfig.isInnerRing = true;
                        AudioConfig.isOuterRing = true;
                        break;
                    case 2:
                        AudioConfig.isRing = true;
                        AudioConfig.isInnerRing = true;
                        AudioConfig.isOuterRing = false;
                        break;
                    case 3:
                        AudioConfig.isRing = true;
                        AudioConfig.isInnerRing = false;
                        AudioConfig.isOuterRing = true;

                        break;
                    case 4:
                        AudioConfig.isRing = false;
                        AudioConfig.isInnerRing = false;
                        AudioConfig.isOuterRing = false;
                        break;
                    default:
                        AudioConfig.isRing = true;
                        AudioConfig.isInnerRing = true;
                        AudioConfig.isOuterRing = true;
                }
            }
            // X轴偏移
            if(properties.audio_offsetX) {
                AudioConfig.offsetX = properties.audio_offsetX.value / 100;
            }
            // Y轴偏移
            if(properties.audio_offsetY) {
                AudioConfig.offsetY = properties.audio_offsetY.value / 100;
            }
            // 鼠标坐标偏移
            if(properties.audio_isClickOffset) {
                AudioConfig.isClickOffset = properties.audio_isClickOffset.value;
            }
            // 圆环半径
            if (properties.audio_radius) {
                AudioConfig.radius = properties.audio_radius.value / 10;
            }
            // 音频振幅
            if (properties.audio_amplitude) {
                AudioConfig.amplitude = properties.audio_amplitude.value;
            }
            // 内外环距离
            if (properties.audio_distance) {
                AudioConfig.distance = properties.audio_distance.value;
            }
            // 是否连线
            if (properties.audio_isLineTo) {
                AudioConfig.isLineTo = properties.audio_isLineTo.value;
            }
            // 圆环点数
            if(properties.audio_pointNum) {
                AudioConfig.pointNum = properties.audio_pointNum.value;
            }
            // 线条粗细
            if (properties.audio_lineWidth) {
                AudioConfig.lineWidth = properties.audio_lineWidth.value;
            }
            // 显示小球
            if (properties.audio_isBall) {
                AudioConfig.isBall = properties.audio_isBall.value;
            }
            // 小球间隔
            if (properties.audio_ballSpacer) {
                AudioConfig.ballSpacer = properties.audio_ballSpacer.value;
            }
            // 小球大小
            if (properties.audio_ballSize) {
                AudioConfig.ballSize = properties.audio_ballSize.value;
            }
            // 显示日期
            if (properties.date_isDate) {
                AudioConfig.isDate = properties.date_isDate.value;
            }
            // 设置语言
            if (properties.date_language) {
                setDateLang(properties.date_language.value);
            }
            // 日期样式
            if(properties.date_style) {
                AudioConfig.dateStyle = properties.date_style.value;
            }
            // 日期大小
            if (properties.date_fontSize) {
                AudioConfig.fontSize = properties.date_fontSize.value;
            }
        }
    }

}(window.jQuery);