/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.jwin.client;

import com.ssblur.jwin.ConfigHandler;
import com.ssblur.utilities.objects.Vec6;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import org.lwjgl.opengl.GL11;

public class SpawnOverlayRenderer {
    private static int mo = 0;
    public static int co = 0;
    private static Vec6 c = new Vec6();

    public static void reset() {
        mo = 0;
        co = 0;
    }

    public static void incrementMO() {
        mo = (mo + 1) % 2;
    }

    public static void incrementCO() {
        co = (co + 1) % 3;
    }

    public static void render(float frame) {
        GlStateManager.func_179094_E();
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        SpawnOverlayRenderer.WCoordMatch(entity, frame);
        if (ConfigHandler.SpawnOverlayOn) {
            SpawnOverlayRenderer.renderBounds(entity);
        }
        if (ConfigHandler.ChunkOverlayOn) {
            SpawnOverlayRenderer.renderLighting(entity);
        }
        GlStateManager.func_179121_F();
    }

    private static void renderLighting(Entity entity) {
        if (mo == 0) {
            return;
        }
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GL11.glLineWidth((float)1.5f);
        GL11.glBegin((int)1);
        GlStateManager.func_179124_c((float)1.0f, (float)0.0f, (float)0.0f);
        World world = entity.field_70170_p;
        int x1 = (int)entity.field_70165_t;
        int z1 = (int)entity.field_70161_v;
        int y1 = (int)SpawnOverlayRenderer.normalize(entity.field_70163_u, 16.0, world.func_72800_K() - 16);
        for (int x = x1 - 16; x <= x1 + 16; ++x) {
            for (int z = z1 - 16; z <= z1 + 16; ++z) {
                BlockPos pos = new BlockPos(x, y1, z);
                Chunk chunk = world.func_175726_f(pos);
                Biome biome = world.func_180494_b(pos);
                if (biome.func_76747_a(EnumCreatureType.MONSTER).isEmpty() || biome.func_76741_f() <= 0.0f) continue;
                for (int y = y1 - 16; y < y1 + 16; ++y) {
                    int spawnMode = SpawnOverlayRenderer.getSpawnMode(chunk, x, y, z);
                    if (spawnMode == 0) continue;
                    if (spawnMode == 1) {
                        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)0.0f);
                    } else {
                        GlStateManager.func_179124_c((float)1.0f, (float)0.0f, (float)0.0f);
                    }
                    GL11.glVertex3d((double)x, (double)((double)y + 0.004), (double)z);
                    GL11.glVertex3d((double)(x + 1), (double)((double)y + 0.004), (double)(z + 1));
                    GL11.glVertex3d((double)(x + 1), (double)((double)y + 0.004), (double)z);
                    GL11.glVertex3d((double)x, (double)((double)y + 0.004), (double)(z + 1));
                }
            }
        }
        GL11.glEnd();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
    }

    private static int getSpawnMode(Chunk chunk, int x, int y, int z) {
        BlockPos pos;
        World world = chunk.func_177412_p();
        if (!WorldEntitySpawner.func_180267_a((EntityLiving.SpawnPlacementType)EntityLiving.SpawnPlacementType.ON_GROUND, (World)world, (BlockPos)(pos = new BlockPos(x, y, z))) || chunk.func_177413_a(EnumSkyBlock.BLOCK, pos) >= 8) {
            return 0;
        }
        c.set((double)x + 0.2, (double)y + 0.01, (double)z + 0.2, (double)x + 0.8, (double)y + 1.8, (double)z + 0.8);
        AxisAlignedBB aabb = c.aabb();
        if (!world.func_72855_b(aabb) || world.func_72953_d(aabb)) {
            return 0;
        }
        if (chunk.func_177413_a(EnumSkyBlock.SKY, pos) >= 8) {
            return 1;
        }
        return 2;
    }

    private static void renderBounds(Entity entity) {
        if (co == 0) {
            return;
        }
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179140_f();
        GL11.glLineWidth((float)1.5f);
        GL11.glBegin((int)1);
        for (int cx = -4; cx <= 4; ++cx) {
            for (int cz = -4; cz <= 4; ++cz) {
                double x1 = entity.field_70176_ah + cx << 4;
                double z1 = entity.field_70164_aj + cz << 4;
                double x2 = x1 + 16.0;
                double z2 = z1 + 16.0;
                double dy = 128.0;
                double y1 = Math.floor(entity.field_70163_u - dy / 2.0);
                double y2 = y1 + dy;
                if (y1 < 0.0) {
                    y1 = 0.0;
                    y2 = dy;
                }
                if (y1 > (double)entity.field_70170_p.func_72800_K()) {
                    y2 = entity.field_70170_p.func_72800_K();
                    y1 = y2 - dy;
                }
                double dist = Math.pow(1.5, -(cx * cx + cz * cz));
                GlStateManager.func_179131_c((float)0.9f, (float)0.0f, (float)0.0f, (float)((float)dist));
                if (cx >= 0 && cz >= 0) {
                    GL11.glVertex3d((double)x2, (double)y1, (double)z2);
                    GL11.glVertex3d((double)x2, (double)y2, (double)z2);
                }
                if (cx >= 0 && cz <= 0) {
                    GL11.glVertex3d((double)x2, (double)y1, (double)z1);
                    GL11.glVertex3d((double)x2, (double)y2, (double)z1);
                }
                if (cx <= 0 && cz >= 0) {
                    GL11.glVertex3d((double)x1, (double)y1, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y2, (double)z2);
                }
                if (cx <= 0 && cz <= 0) {
                    GL11.glVertex3d((double)x1, (double)y1, (double)z1);
                    GL11.glVertex3d((double)x1, (double)y2, (double)z1);
                }
                if (co != 2 || cx != 0 || cz != 0) continue;
                dy = 32.0;
                y1 = Math.floor(entity.field_70163_u - dy / 2.0);
                y2 = y1 + dy;
                if (y1 < 0.0) {
                    y1 = 0.0;
                    y2 = dy;
                }
                if (y1 > (double)entity.field_70170_p.func_72800_K()) {
                    y2 = entity.field_70170_p.func_72800_K();
                    y1 = y2 - dy;
                }
                GlStateManager.func_179131_c((float)0.0f, (float)0.9f, (float)0.0f, (float)0.4f);
                for (double y = (double)((int)y1); y <= y2; y += 1.0) {
                    GL11.glVertex3d((double)x2, (double)y, (double)z1);
                    GL11.glVertex3d((double)x2, (double)y, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y, (double)z1);
                    GL11.glVertex3d((double)x1, (double)y, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y, (double)z2);
                    GL11.glVertex3d((double)x2, (double)y, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y, (double)z1);
                    GL11.glVertex3d((double)x2, (double)y, (double)z1);
                }
                for (double h = 1.0; h <= 15.0; h += 1.0) {
                    GL11.glVertex3d((double)(x1 + h), (double)y1, (double)z1);
                    GL11.glVertex3d((double)(x1 + h), (double)y2, (double)z1);
                    GL11.glVertex3d((double)(x1 + h), (double)y1, (double)z2);
                    GL11.glVertex3d((double)(x1 + h), (double)y2, (double)z2);
                    GL11.glVertex3d((double)x1, (double)y1, (double)(z1 + h));
                    GL11.glVertex3d((double)x1, (double)y2, (double)(z1 + h));
                    GL11.glVertex3d((double)x2, (double)y1, (double)(z1 + h));
                    GL11.glVertex3d((double)x2, (double)y2, (double)(z1 + h));
                }
            }
        }
        GL11.glEnd();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
    }

    public static void WCoordMatch(Entity entity, float frame) {
        double X = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)frame;
        double Y = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)frame;
        double Z = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)frame;
        GL11.glTranslated((double)(-X), (double)(-Y), (double)(-Z));
    }

    public static double normalize(double v, double n, double x) {
        return v > x ? x : (v < n ? n : v);
    }
}

