/*
 * Decompiled with CFR 0.152.
 */
package com.ssblur.jwin;

import com.ssblur.jwin.ConfigHandler;
import com.ssblur.jwin.events.GUIHandlers;
import com.ssblur.jwin.events.KeyPressHandler;
import com.ssblur.jwin.events.MissingMappingHandler;
import com.ssblur.jwin.events.PickupHandlers;
import com.ssblur.jwin.events.PlayerHandlers;
import com.ssblur.jwin.events.SpawningHandlers;
import com.ssblur.jwin.events.UseHandlers;
import com.ssblur.utilities.GreatLog;
import com.ssblur.utilities.SaveTheOresMapper;
import java.io.PrintWriter;
import java.util.ArrayList;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="jwin", name="Just What I Needed", version="univ_compat_filler", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.10.2]")
public class JustWhatINeededMain {
    public static PrintWriter writer;
    public static Logger logger;
    protected static Thread shutdown;
    public static ArrayList<String> OrePickupBlacklist;

    @Mod.EventHandler
    public void preload(FMLPreInitializationEvent e) {
        logger = LogManager.getLogger((String)"JWIN");
        logger.log(Level.INFO, "Just What I Needed Loaded");
        ConfigHandler.configLoad(e);
        if (ConfigHandler.JWINDebugLogOn) {
            try {
                writer = new PrintWriter("jwin.log", "UTF-8");
                Runtime.getRuntime().addShutdownHook(shutdown);
                logger.warn("Debug Log enabled, all output can be found in jwin.log in your minecraft directory.");
            }
            catch (Exception ex) {
                logger.warn(ex.getMessage());
            }
        } else {
            logger.warn("Debug Log disabled.");
        }
        if (ConfigHandler.OrePickupConvertOn) {
            MinecraftForge.EVENT_BUS.register((Object)new PickupHandlers());
        }
        if ((ConfigHandler.SpawnOverlayOn || ConfigHandler.ChunkOverlayOn) && e.getSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)new GUIHandlers());
            MinecraftForge.EVENT_BUS.register((Object)new KeyPressHandler());
            JustWhatINeededMain.keys();
        }
        if (ConfigHandler.WrenchLogsOn || ConfigHandler.RightClickHarvestOn) {
            MinecraftForge.EVENT_BUS.register((Object)new UseHandlers());
        }
        if (ConfigHandler.BedFixOn) {
            PlayerHandlers.setupFields();
            MinecraftForge.EVENT_BUS.register((Object)new PlayerHandlers());
        }
        if (ConfigHandler.AntiTreeMobOn) {
            MinecraftForge.EVENT_BUS.register((Object)new SpawningHandlers());
        }
        if (ConfigHandler.SecretOn) {
            GreatLog.info("Doing some more work on P&P, will have a new build released within a month after BTM16 2.0.");
        }
    }

    @Mod.EventHandler
    public void postload(FMLPostInitializationEvent e) {
        if (ConfigHandler.SaveTheOresOn) {
            SaveTheOresMapper.mapExistingOres();
        }
    }

    public static void keys() {
        ConfigHandler.SpawnOverlayKey = new KeyBinding("key.spawn_overlay", 65, "key.categories.jwin");
        ConfigHandler.ChunkOverlayKey = new KeyBinding("key.chunk_overlay", 67, "key.categories.jwin");
        ClientRegistry.registerKeyBinding((KeyBinding)ConfigHandler.SpawnOverlayKey);
        ClientRegistry.registerKeyBinding((KeyBinding)ConfigHandler.ChunkOverlayKey);
    }

    @Mod.EventHandler
    public void saveTheOres(FMLMissingMappingsEvent e) {
        GreatLog.info("Checking if Save the Ores is enabled...");
        if (ConfigHandler.SaveTheOresOn) {
            GreatLog.info("Launching Save the Ores.");
            MissingMappingHandler.saveTheOres(e);
        }
    }

    static {
        shutdown = new Thread(){

            @Override
            public void run() {
                if (writer != null) {
                    writer.close();
                }
            }
        };
    }
}

