/*
 * Decompiled with CFR 0.152.
 */
package com.reimaginedgaming.blur.jwin;

import com.reimaginedgaming.blur.jwin.events.AnimalHandlers;
import com.reimaginedgaming.blur.jwin.events.EntityAnimalSit;
import com.reimaginedgaming.blur.jwin.events.PickupHandlers;
import com.reimaginedgaming.blur.jwin.events.PlayerHandlers;
import com.reimaginedgaming.blur.jwin.events.SpawningHandlers;
import com.reimaginedgaming.blur.jwin.events.WrenchRotateLogs;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.util.ArrayList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

@Mod(modid="jwin", name="Just What I Needed", version="univ_compat_1.7.10", acceptableRemoteVersions="*")
public class JustWhatINeededMain {
    public static boolean CowParticlesOn;
    public static boolean OrePickupConvertOn;
    public static boolean WrenchLogsOn;
    public static boolean BedFixOn;
    public static boolean AnimalsEatBreedingItemsOn;
    public static boolean AnimalSitOn;
    public static boolean AntiTreeMobOn;
    public static boolean[] OrePickupConfig;
    public static ArrayList<String> OrePickupBlacklist;

    @Mod.EventHandler
    public void preload(FMLPreInitializationEvent e) {
        System.out.println("Just What I Needed Loaded");
        JustWhatINeededMain.configLoad(e);
        if (OrePickupConvertOn) {
            MinecraftForge.EVENT_BUS.register((Object)new PickupHandlers());
        }
        if (WrenchLogsOn) {
            MinecraftForge.EVENT_BUS.register((Object)new WrenchRotateLogs());
        }
        if (CowParticlesOn | AnimalsEatBreedingItemsOn) {
            AnimalHandlers.setupField();
            MinecraftForge.EVENT_BUS.register((Object)new AnimalHandlers());
        }
        if (BedFixOn) {
            PlayerHandlers.setupFields();
            MinecraftForge.EVENT_BUS.register((Object)new PlayerHandlers());
        }
        if (AnimalSitOn) {
            MinecraftForge.EVENT_BUS.register((Object)new EntityAnimalSit());
        }
        if (AntiTreeMobOn) {
            MinecraftForge.EVENT_BUS.register((Object)new SpawningHandlers());
        }
    }

    public static void configLoad(FMLPreInitializationEvent e) {
        String CATEGORY_GENERAL = "general";
        String CATEGORY_ORES = "Ore Conversion";
        Configuration config = new Configuration(e.getSuggestedConfigurationFile());
        config.load();
        Property orepickup = config.get(CATEGORY_ORES, "OrePickupEnabled", "true");
        orepickup.comment = "Set to false if you do not want mined items to be converted on pickup.";
        OrePickupConvertOn = orepickup.getBoolean(true);
        Property orepickupo = config.get(CATEGORY_ORES, "OreOrePickupEnabled", "true");
        orepickupo.comment = "Set to false if you do not want ore blocks specifically to be converted on pickup. \nIrrelevant if OrePickupEnabled is set to false.";
        JustWhatINeededMain.OrePickupConfig[0] = orepickup.getBoolean(true);
        Property orepickupi = config.get(CATEGORY_ORES, "IngotOrePickupEnabled", "false");
        orepickupi.comment = "Set to false if you do not want ingots specifically to be converted on pickup. \nIrrelevant if OrePickupEnabled is set to false.";
        JustWhatINeededMain.OrePickupConfig[1] = orepickup.getBoolean(false);
        Property orepickupn = config.get(CATEGORY_ORES, "NuggetOrePickupEnabled", "false");
        orepickupn.comment = "Set to false if you do not want nuggets specifically to be converted on pickup. \nIrrelevant if OrePickupEnabled is set to false.";
        JustWhatINeededMain.OrePickupConfig[2] = orepickup.getBoolean(false);
        Property orepickupg = config.get(CATEGORY_ORES, "GemOrePickupEnabled", "true");
        orepickupg.comment = "Set to false if you do not want gems specifically to be converted on pickup. \nIrrelevant if OrePickupEnabled is set to false.";
        JustWhatINeededMain.OrePickupConfig[3] = orepickup.getBoolean(true);
        Property orepickupd = config.get(CATEGORY_ORES, "DustOrePickupEnabled", "true");
        orepickupd.comment = "Set to false if you do not want dusts specifically to be converted on pickup. \nIrrelevant if OrePickupEnabled is set to false.";
        JustWhatINeededMain.OrePickupConfig[4] = orepickup.getBoolean(true);
        Property orepickupb = config.get(CATEGORY_ORES, "BlockOrePickupEnabled", "false");
        orepickupb.comment = "Set to false if you do not want ingot blocks specifically to be converted on pickup. \nIrrelevant if OrePickupEnabled is set to false.";
        JustWhatINeededMain.OrePickupConfig[5] = orepickup.getBoolean(false);
        Property cowparticles = config.get("general", "AnimalParticlesEnabled", "true");
        cowparticles.comment = "Set to false if you do not want to see particles around animals which cannot breed.";
        CowParticlesOn = cowparticles.getBoolean(true);
        Property wrenchlog = config.get("general", "WrenchLogEnabled", "true");
        wrenchlog.comment = "Set to false if you do not want sticks and wrenches to rotate logs.";
        WrenchLogsOn = wrenchlog.getBoolean(true);
        Property bedfix = config.get("general", "BedFixEnabled", "true");
        bedfix.comment = "Set to false if you do not want to use improved sleeping mechanics.";
        BedFixOn = bedfix.getBoolean(true);
        Property animaleat = config.get("general", "AnimalEatingTweaksEnabled", "true");
        animaleat.comment = "Set to false if you do not want to use animal eating tweaks.";
        AnimalsEatBreedingItemsOn = animaleat.getBoolean(true);
        Property animalssit = config.get("general", "AnimalForceSittingEnabled", "true");
        animalssit.comment = "Set to false if you do not want to right clicking to disable animal AI.";
        AnimalSitOn = animalssit.getBoolean(true);
        Property antitreemob = config.get("general", "AntiTreeMobsEnabled", "true");
        antitreemob.comment = "Set to false if you want mobs to spawn on trees (Not yet implemented!)";
        AntiTreeMobOn = antitreemob.getBoolean(true);
        config.save();
    }

    static {
        OrePickupConfig = new boolean[]{true, true, true, true, true, true};
    }
}

