/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags.loot;

import cpw.mods.fml.common.registry.GameRegistry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import mal.lootbags.LootbagsUtil;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomChestContent;

public class LootItem
implements Comparable {
    private WeightedRandomChestContent item;
    private String modid;
    private String name;
    private int damage;
    private int minstack;
    private int maxstack;
    private int weight;
    private byte[] nbt;
    private boolean generalItem = false;

    public LootItem(WeightedRandomChestContent item, boolean isgeneral) {
        this.item = item;
        this.modid = GameRegistry.findUniqueIdentifierFor((Item)item.field_76297_b.func_77973_b()).modId;
        this.name = GameRegistry.findUniqueIdentifierFor((Item)item.field_76297_b.func_77973_b()).name;
        this.damage = item.field_76297_b.func_77960_j();
        this.minstack = item.field_76295_d;
        this.maxstack = item.field_76296_e;
        this.weight = item.field_76292_a;
        this.generalItem = isgeneral;
        try {
            if (item.field_76297_b.func_77978_p() != null) {
                this.nbt = CompressedStreamTools.func_74798_a((NBTTagCompound)item.field_76297_b.func_77978_p());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public LootItem(String modid, String itemname, int damage, int minstack, int maxstack, int weight, boolean isgeneral) {
        ItemStack stack = new ItemStack(GameRegistry.findItem((String)modid, (String)itemname), 1);
        this.modid = modid;
        this.name = itemname;
        this.damage = damage;
        this.minstack = minstack;
        this.maxstack = maxstack;
        this.weight = weight;
        this.nbt = null;
        this.generalItem = isgeneral;
        if (stack != null && stack.func_77973_b() != null) {
            stack.field_77994_a = maxstack;
            stack.func_77964_b(damage);
            if (stack.field_77994_a > stack.func_77976_d()) {
                stack.field_77994_a = stack.func_77976_d();
            }
            if (stack.field_77994_a < 1) {
                stack.field_77994_a = 1;
                LootbagsUtil.LogInfo("Stack size for whitelisted item: " + stack.toString() + " below 1.  Setting to 1.");
            }
            if (minstack > maxstack) {
                minstack = maxstack;
            }
            this.item = new WeightedRandomChestContent(stack, minstack, stack.field_77994_a, weight);
        }
    }

    public LootItem(String modid, String itemname, int damage, int minstack, int maxstack, int weight, byte[] nbt, boolean isgeneral) {
        ItemStack stack = new ItemStack(GameRegistry.findItem((String)modid, (String)itemname), 1);
        this.modid = modid;
        this.name = itemname;
        this.damage = damage;
        this.minstack = minstack;
        this.maxstack = maxstack;
        this.weight = weight;
        this.nbt = nbt;
        this.generalItem = isgeneral;
        if (stack.func_77973_b() == null) {
            Block block = GameRegistry.findBlock((String)modid, (String)itemname);
            Item item = GameRegistry.findItem((String)modid, (String)itemname);
            if (item != null) {
                stack = new ItemStack(item, maxstack, damage);
            } else if (block != null) {
                stack = new ItemStack(block, maxstack, damage);
            }
        }
        if (stack != null && stack.func_77973_b() != null) {
            stack.field_77994_a = maxstack;
            stack.func_77964_b(damage);
            ByteArrayInputStream st = new ByteArrayInputStream(nbt);
            try {
                NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)st);
                stack.func_77982_d(tag);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (stack.field_77994_a > stack.func_77976_d()) {
                stack.field_77994_a = stack.func_77976_d();
            }
            if (stack.field_77994_a < 1) {
                stack.field_77994_a = 1;
                LootbagsUtil.LogInfo("Stack size for whitelisted item: " + stack.toString() + " below 1.  Setting to 1.");
            }
            if (minstack > maxstack) {
                minstack = maxstack;
            }
            this.item = new WeightedRandomChestContent(stack, minstack, stack.field_77994_a, weight);
        }
    }

    public void reinitializeLootItem() {
        ItemStack stack = new ItemStack(GameRegistry.findItem((String)this.modid, (String)this.name), 1);
        if (stack.func_77973_b() == null) {
            Block block = GameRegistry.findBlock((String)this.modid, (String)this.name);
            Item item = GameRegistry.findItem((String)this.modid, (String)this.name);
            if (item != null) {
                stack = new ItemStack(item, this.maxstack, this.damage);
            } else if (block != null) {
                stack = new ItemStack(block, this.maxstack, this.damage);
            }
        }
        if (stack != null && stack.func_77973_b() != null) {
            stack.field_77994_a = this.maxstack;
            stack.func_77964_b(this.damage);
            if (this.nbt != null) {
                ByteArrayInputStream st = new ByteArrayInputStream(this.nbt);
                try {
                    NBTTagCompound tag = CompressedStreamTools.func_74796_a((InputStream)st);
                    stack.func_77982_d(tag);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (stack.field_77994_a > stack.func_77976_d()) {
                stack.field_77994_a = stack.func_77976_d();
            }
            if (stack.field_77994_a < 1) {
                stack.field_77994_a = 1;
                LootbagsUtil.LogInfo("Stack size for whitelisted item: " + stack.toString() + " below 1.  Setting to 1.");
            }
            if (this.minstack > this.maxstack) {
                this.minstack = this.maxstack;
            }
            this.item = new WeightedRandomChestContent(stack, this.minstack, stack.field_77994_a, this.weight);
        } else {
            LootbagsUtil.LogInfo("Loot Item with name: " + this.modid + ":" + this.name + " did not find an item with that name and mod ID. Ensure that the information is correct.");
        }
    }

    public WeightedRandomChestContent getContentItem() {
        return this.item;
    }

    public String getItemName() {
        return this.name;
    }

    public String getItemModID() {
        return this.modid;
    }

    public int getItemWeight() {
        return this.item.field_76292_a;
    }

    public boolean getGeneral() {
        return this.generalItem;
    }

    public String toString() {
        return this.item.field_76297_b.toString() + ":" + this.minstack + ":" + this.maxstack + ":" + this.weight;
    }

    public LootItem copy() {
        return new LootItem(this.item, this.generalItem);
    }

    public int compareTo(Object loot) {
        if (!(loot instanceof LootItem)) {
            return 0;
        }
        if (this.item.field_76292_a > ((LootItem)loot).getItemWeight()) {
            return 1;
        }
        if (this.item.field_76292_a < ((LootItem)loot).getItemWeight()) {
            return -1;
        }
        return 0;
    }
}

