/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags.item;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mal.lootbags.Bag;
import mal.lootbags.LootBags;
import mal.lootbags.LootbagsUtil;
import mal.lootbags.handler.BagHandler;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class LootbagItem
extends Item {
    private final String name = "lootbag";
    private IIcon[] iconlist;

    public LootbagItem() {
        GameRegistry.registerItem((Item)this, (String)"lootbag");
        this.func_77655_b("lootbags_lootbag");
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.iconlist = new IIcon[BagHandler.getHighestUsedID() + 1];
    }

    public String getName() {
        return "lootbag";
    }

    public String func_77653_i(ItemStack stack) {
        String s = ("" + StatCollector.func_74838_a((String)(this.func_77657_g(stack) + ".name"))).trim();
        Bag b = BagHandler.getBag(stack.func_77960_j());
        if (b != null) {
            return b.getBagNameColor() + s;
        }
        return s;
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List list, boolean bool) {
        Bag b = BagHandler.getBag(is.func_77960_j());
        if (b == null) {
            return;
        }
        if (b.isBagEmpty()) {
            list.add(EnumChatFormatting.RED + "Bag Disabled - Loot Table is empty.");
            list.add(EnumChatFormatting.RED + "This is not good.");
            return;
        }
        if (is.func_77978_p() != null && is.func_77978_p().func_74767_n("generated")) {
            for (String s : b.getBagTextOpened()) {
                list.addAll(this.parseTextCommand(s, b));
            }
        } else {
            for (String s : b.getBagTextUnopened()) {
                list.addAll(this.parseTextCommand(s, b));
            }
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            for (String s : b.getBagTextShift()) {
                list.addAll(this.parseTextCommand(s, b));
            }
        }
    }

    private ArrayList<String> parseTextCommand(String text, Bag currentBag) {
        String sret = "";
        if (currentBag == null) {
            return new ArrayList<String>();
        }
        String color = "";
        if (text.startsWith("\u00ef\u00bf\u00bd")) {
            color = text.substring(0, 2);
            text = text.substring(2);
        }
        switch (text.toUpperCase()) {
            case "DROPCHANCES": {
                sret = StatCollector.func_74838_a((String)("name.lootbags_" + currentBag.getBagName() + ".name")) + " drop chances: Monster: " + currentBag.getMonsterDropChance() + " Passive: " + currentBag.getPassiveDropChance() + " Player: " + currentBag.getPlayerDropChance() + " Boss: " + currentBag.getBossDropChance();
                break;
            }
            default: {
                sret = text;
            }
        }
        return LootbagsUtil.addLineBreaks(sret, color);
    }

    public void func_94581_a(IIconRegister ir) {
        for (Bag b : BagHandler.getBagList().values()) {
            this.iconlist[b.getBagIndex()] = ir.func_94245_a("lootbags:" + b.getBagName() + "ItemTexture");
        }
    }

    public IIcon func_77617_a(int value) {
        if (value < 0 || value >= this.iconlist.length) {
            value = 0;
        }
        return this.iconlist[value];
    }

    public static void setTagCompound(ItemStack is, ItemStack[] inventory) {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList nbtinventory = new NBTTagList();
        if (inventory != null) {
            for (int i = 0; i < 5; ++i) {
                NBTTagCompound var4 = new NBTTagCompound();
                var4.func_74768_a("Slot", i);
                if (inventory[i] != null) {
                    inventory[i].func_77955_b(var4);
                }
                nbtinventory.func_74742_a((NBTBase)var4);
            }
        }
        nbt.func_74782_a("inventory", (NBTBase)nbtinventory);
        nbt.func_74757_a("generated", true);
        is.func_77982_d(nbt);
    }

    public static ItemStack[] getInventory(ItemStack is) {
        ItemStack[] inventory = new ItemStack[5];
        NBTTagList items = is.func_77978_p().func_150295_c("inventory", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            ItemStack ii;
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74762_e("Slot");
            if (slot < 0 || slot >= inventory.length) continue;
            inventory[i] = ii = ItemStack.func_77949_a((NBTTagCompound)item);
        }
        return inventory;
    }

    private static void generateInventory(ItemStack is) {
        boolean gen = false;
        if (is.func_77978_p() != null) {
            gen = is.func_77978_p().func_74767_n("generated");
        }
        if (!gen) {
            int numitems = LootbagItem.getNumItems(is);
            ItemStack[] items = new ItemStack[numitems];
            NBTTagCompound nbt = new NBTTagCompound();
            NBTTagList nbtinventory = new NBTTagList();
            for (int i = 0; i < numitems; ++i) {
                ItemStack inv;
                items[i] = inv = LootbagItem.getLootItem(is.func_77960_j(), i, items);
                NBTTagCompound var4 = new NBTTagCompound();
                var4.func_74768_a("Slot", i);
                if (inv != null && inv.field_77994_a > 0) {
                    inv.func_77955_b(var4);
                } else {
                    --i;
                    --numitems;
                }
                nbtinventory.func_74742_a((NBTBase)var4);
            }
            nbt.func_74782_a("inventory", (NBTBase)nbtinventory);
            nbt.func_74757_a("generated", true);
            is.func_77982_d(nbt);
        }
    }

    private static ItemStack getLootItem(int damage, int slot, ItemStack[] items) {
        return LootbagItem.getLootItem(0, damage, slot, items);
    }

    private static ItemStack getLootItem(int rerollCount, int damage, int slot, ItemStack[] items) {
        boolean reroll = false;
        Bag b = BagHandler.getBag(damage);
        if (b.getMap().size() <= b.getMaxItems() && LootBags.PREVENTDUPLICATELOOT != 0) {
            return b.getSpecificItem(slot);
        }
        ItemStack is = b.getRandomItem();
        if (is == null || is.func_77973_b() == null || is.field_77994_a <= 0) {
            reroll = true;
        }
        if (LootbagItem.itemAlreadyRolled(is, items, b)) {
            reroll = true;
        }
        if (reroll && rerollCount < LootBags.MAXREROLLCOUNT) {
            return LootbagItem.getLootItem(rerollCount += items.length, damage, slot, items);
        }
        if (rerollCount >= LootBags.MAXREROLLCOUNT) {
            return null;
        }
        return is;
    }

    private static boolean itemAlreadyRolled(ItemStack stack, ItemStack[] items, Bag b) {
        if (items == null) {
            return false;
        }
        if (b.getItemRepeats() == 0) {
            return false;
        }
        for (int i = 0; i < items.length; ++i) {
            if (items[i] == null) continue;
            if (b.getItemRepeats() == 1 && stack.func_77969_a(items[i])) {
                return true;
            }
            if (b.getItemRepeats() != 2 || stack.func_77973_b() != items[i].func_77973_b()) continue;
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer player) {
        if (!world.field_72995_K && !player.func_70093_af()) {
            if (BagHandler.isBagEmpty(is.func_77960_j())) {
                return is;
            }
            LootbagItem.generateInventory(is);
            player.openGui((Object)LootBags.LootBagsInstance, 0, world, 0, 0, 0);
        }
        return is;
    }

    public boolean func_77648_a(ItemStack is, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (BagHandler.isBagEmpty(is.func_77960_j())) {
                return false;
            }
            if (!player.func_70093_af()) {
                return false;
            }
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof IInventory) {
                LootbagItem.generateInventory(is);
                ItemStack[] iss = LootbagItem.getInventory(is);
                block0: for (int j = 0; j < iss.length; ++j) {
                    ItemStack stack = iss[j];
                    if (stack == null) continue;
                    IInventory ite = (IInventory)te;
                    int size = ite.func_70302_i_();
                    for (int i = 0; i < size; ++i) {
                        ItemStack itstack = ite.func_70301_a(i);
                        if (!ite.func_94041_b(i, stack) || itstack != null && !LootBags.areItemStacksEqualItem(itstack, stack, true, true) && ite.func_70301_a(i) != null) continue;
                        if (itstack == null) {
                            ite.func_70299_a(i, stack);
                            iss[j] = null;
                            continue block0;
                        }
                        if (itstack.field_77994_a + stack.field_77994_a <= itstack.func_77976_d()) {
                            itstack.field_77994_a += stack.field_77994_a;
                            iss[j] = null;
                            continue block0;
                        }
                        if (itstack.field_77994_a >= itstack.func_77976_d()) continue;
                        int diff = itstack.func_77976_d() - itstack.field_77994_a;
                        ite.func_70301_a((int)i).field_77994_a = ite.func_70301_a(i).func_77976_d();
                        stack.field_77994_a -= diff;
                        if (stack.field_77994_a > 0) continue;
                        iss[j] = null;
                        continue block0;
                    }
                }
                LootbagItem.setTagCompound(is, iss);
                if (LootbagItem.checkInventory(is)) {
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean checkInventory(ItemStack is) {
        boolean gen = is.func_77978_p().func_74767_n("generated");
        if (gen) {
            ItemStack[] stack = LootbagItem.getInventory(is);
            if (stack == null) {
                return true;
            }
            boolean b = true;
            for (int i = 0; i < stack.length; ++i) {
                if (stack[i] == null || stack[i].field_77994_a <= 0) continue;
                b = false;
            }
            return b;
        }
        return false;
    }

    public String func_77667_c(ItemStack stack) {
        String base = "name.lootbags";
        Bag bag = BagHandler.getBag(stack.func_77960_j());
        if (bag == null) {
            return base + "_" + "lootbag";
        }
        return base + "_" + bag.getBagName();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int renderPass) {
        Bag bag = BagHandler.getBag(stack.func_77960_j());
        if (bag == null) {
            return 0xFFFFFF;
        }
        int[] colors = bag.getBagTextureColor();
        if (renderPass == 0) {
            return colors[0];
        }
        return colors[1];
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (Bag b : BagHandler.getBagList().values()) {
            if (b.getSecret() && !LootBags.SHOWSECRETBAGS) continue;
            par3List.add(new ItemStack(par1, 1, b.getBagIndex()));
        }
    }

    private static int getNumItems(ItemStack is) {
        int max;
        Bag b = BagHandler.getBag(is.func_77960_j());
        int min = b.getMinItems();
        if (min == (max = b.getMaxItems())) {
            return min;
        }
        return LootBags.getRandom().nextInt(max - min + 1) + min;
    }

    public boolean func_77651_p() {
        return true;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        if (!BagHandler.isBagEmpty(itemStack.func_77960_j())) {
            return super.getEntityLifespan(itemStack, world);
        }
        return 1;
    }
}

