/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags.config;

import java.io.File;
import java.util.ArrayList;
import mal.lootbags.LootBags;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;

public class GeneralConfigHandler {
    private static ArrayList<String> blacklistConfigData = new ArrayList();
    private static ArrayList<String> whitelistConfigData = new ArrayList();
    private static ArrayList<String> recyclerBlacklistConfigData = new ArrayList();
    private static ArrayList<String> recyclerWhitelistConfigData = new ArrayList();
    private static File configfile;

    public static void loadConfig(FMLPreInitializationEvent event) {
        configfile = event.getSuggestedConfigurationFile();
        GeneralConfigHandler.reloadConfig();
    }

    public static void reloadConfig() {
        int i;
        Configuration config = new Configuration(configfile);
        config.load();
        Property prop = config.get("Drop Chances", "1 Weighting Resolution", 1000);
        prop.setComment("This is the resolution of the bag drop chances.  Only change this if you want bags with rarity resolutions > 0.1%");
        LootBags.DROPRESOLUTION = prop.getInt();
        prop = config.get("Loot Categories", "ChestGenHooks Dropped", new String[]{LootTableList.field_186422_d.toString(), LootTableList.field_186424_f.toString(), LootTableList.field_186429_k.toString(), LootTableList.field_186430_l.toString(), LootTableList.field_189420_m.toString(), LootTableList.field_186428_j.toString(), LootTableList.field_186427_i.toString(), LootTableList.field_186426_h.toString(), LootTableList.field_186423_e.toString()});
        prop.setComment("This is a list of the loot sources the bags pull from to generate the loot tables.  Probably a good idea to not mess with this unless you know what you're doing as entering in a category that doesn't exist will simply make a new.");
        LootBags.LOOTCATEGORYLIST = prop.getStringList();
        prop = config.get("Loot Categories", "Chest Drop Weight", 20);
        prop.setComment("This is the weighting of the bags in any of the worldgen chests.");
        LootBags.CHESTQUALITYWEIGHT = prop.getInt();
        prop = config.get("Blacklisted Items", "Global Blacklist", new String[]{""});
        prop.setComment("Adding a modid and internal item name to this list will remove the item from the general loot table.  The entry must be in the form <modid>:<itemname>:<damage> on a single line or it won't work right.  Example to blacklist iron ingots: minecraft:iron_ingot:0.  An entire modcan be blacklisted by just entering the modid and nothing else.");
        String[] blep = prop.getStringList();
        for (i = 0; i < blep.length; ++i) {
            blacklistConfigData.add(blep[i]);
        }
        prop = config.get("Whitelisted Items", "Global Whitelist", new String[0]);
        prop.setComment("Adding a modid and internal item name to this list will add the item to the Loot Bag drop table.  The entry must be in the form <modid>:<itemname>:<damage>:<min stack size>:<max stack size>:<weighting>:[<nbt data (seriously don't try to make this by hand)> (optional)]  Example to whitelist up to 16 iron ingots with a weight of 50: minecraft:iron_ingot:0:1:16:50.");
        blep = prop.getStringList();
        for (i = 0; i < blep.length; ++i) {
            whitelistConfigData.add(blep[i]);
        }
        prop = config.get("Recycler", "Item Blacklist", new String[0]);
        prop.setComment("Blacklist an item from being recyclable.  The entry must be in the form <modid>:<itemname>:<damage> on a single line or it won't work right.");
        blep = prop.getStringList();
        for (i = 0; i < blep.length; ++i) {
            recyclerBlacklistConfigData.add(blep[i]);
        }
        prop = config.get("Recycler", "Item Whitelist", new String[0]);
        prop.setComment("Whitelist an item to be recyclable.  The entry must be in the form <modid>:<itemname>:<damage>:<weighting>:[<nbt data (seriously don't try to make this by hand)> (optional)]  The weight is as though the item was added to a bag, but the items whitelisted are not added to any loot bags.");
        blep = prop.getStringList();
        for (i = 0; i < blep.length; ++i) {
            recyclerWhitelistConfigData.add(blep[i]);
        }
        prop = config.get("Loot Categories", "Loot Bags in worldgen chests", new String[]{LootTableList.field_186422_d.toString(), LootTableList.field_186424_f.toString(), LootTableList.field_186429_k.toString(), LootTableList.field_186430_l.toString(), LootTableList.field_189420_m.toString(), LootTableList.field_186428_j.toString(), LootTableList.field_186427_i.toString(), LootTableList.field_186426_h.toString(), LootTableList.field_186423_e.toString()});
        prop.setComment("This adds the loot bags to each of the loot tables listed.");
        LootBags.LOOTBAGINDUNGEONLOOT = prop.getStringList();
        prop = config.get("general", "Maximum Rerolls Allowed", 50);
        prop.setComment("If the bag encounters an item it cannot place in the bag for some reason, it will reroll until it gets an item that will work, this sets a limit to the number of times the bag will reroll before it just skips the slot.  Extremely high or low numbers may result in undesired performance of the mod.");
        LootBags.MAXREROLLCOUNT = prop.getInt();
        prop = config.get("general", "Bag Opener Cooldown", 100);
        prop.setComment("The cooldown in ticks that the bag opener needs before it'll process again.");
        LootBags.OPENERMAXCOOLDOWN = prop.getInt();
        prop = config.get("general", "Show Secret Bags", false);
        prop.setComment("This if true will show all the secret bags in creative inventory or item list mods.  Kind of ruins the fun if you ask me.");
        LootBags.SHOWSECRETBAGS = prop.getBoolean();
        prop = config.get("general", "Total Loot Value to Create a New Bag Multiplier", 1.0);
        prop.setComment("This is kind of ambiguous, but essentially it's a global multiplier to adjust the cost to fabricate new bags in the loot recycler.");
        LootBags.TOTALVALUEMULTIPLIER = prop.getDouble();
        prop = config.get("general", "Disable Recycler Recipe", false);
        prop.setComment("Disables the loot recycler from being crafted.");
        LootBags.DISABLERECYCLER = prop.getBoolean();
        prop = config.get("general", "Disable Opener Recipe", false);
        prop.setComment("Disables the bag opener from being crafted.");
        LootBags.DISABLEOPENER = prop.getBoolean();
        prop = config.get("general", "Verbose Mode", true);
        prop.setComment("Setting this to false will disable many of the info messages, only showing errors in the log.");
        LootBags.VERBOSEMODE = prop.getBoolean();
        prop = config.get("general", "Debug Mode", false);
        prop.setComment("Setting this to true will display extra information about the contents of the bags and tables.");
        LootBags.DEBUGMODE = prop.getBoolean();
        prop = config.get("general", "Valid Kill Methods", "All");
        prop.setComment("Sources of entity death that are counted to determine if a bag can drop.  Allowable names: All, Player, Real.  All is any source of death, Player is any player entity including mod fake players, Real is only real players.");
        String method = prop.getString();
        if (method.equalsIgnoreCase("all")) {
            LootBags.BAGFROMPLAYERKILL = 0;
        } else if (method.equalsIgnoreCase("player")) {
            LootBags.BAGFROMPLAYERKILL = 1;
        } else if (method.equalsIgnoreCase("real")) {
            LootBags.BAGFROMPLAYERKILL = 2;
        } else {
            FMLLog.log((Level)Level.WARN, (String)("Invalid death source: " + method + ".  Setting method to allow all sources."), (Object[])new Object[0]);
            LootBags.BAGFROMPLAYERKILL = 0;
        }
        prop = config.get("general", "Limit bag drop to one bag per death", true);
        prop.setComment("This limits the loot bags to only drop one bag.  Bag weighting is dependant on drop chances.");
        LootBags.LIMITONEBAGPERDROP = prop.getBoolean();
        prop = config.get("general", "Bag ID used in Recycler", 0);
        prop.setComment("The bag ID (see the bag config) used in the recycler to fabricate new bags.");
        LootBags.RECYCLEDID = prop.getInt();
        prop = config.get("general", "Prevent Merging Opened Bags", false);
        prop.setComment("If set to true, prevents bag crafting from working if any of the bags have been opened.");
        LootBags.PREVENTMERGEDBAGS = prop.getBoolean();
        prop = config.get("Recycler", "Value Formula Multiplier", 2.0);
        prop.setComment("Multiplies the recycler value of an item in the Recycler, in the formula (a*Total Value)/(Item Value*(isStackable)?(b):(c)), this is the a variable.");
        LootBags.RECYCLERVALUENUMERATOR = prop.getDouble();
        prop = config.get("Recycler", "Stackable Formula Divider", 8.0);
        prop.setComment("Divides the recycler value of an item in the Recycler by this if the item stacks past one item, in the formula (a*Total Value)/(Item Value*(isStackable)?(b):(c)), this is the b variable.");
        LootBags.RECYCLERVALUESTACK = prop.getDouble();
        prop = config.get("Recycler", "Non-Stackable Formula Divider", 1.0);
        prop.setComment("Divides the recycler value of an item in the Recycler by this if the item does not stack past one item, in the formula (a*Total Value)/(Item Value*(isStackable)?(b):(c)), this is the c variable.");
        LootBags.RECYCLERVALUENONSTACK = prop.getDouble();
        config.save();
    }

    public static ArrayList<String> getBlacklistConfigData() {
        return blacklistConfigData;
    }

    public static ArrayList<String> getWhitelistConfigData() {
        return whitelistConfigData;
    }

    public static ArrayList<String> getRecyclerBlacklistConfigData() {
        return recyclerBlacklistConfigData;
    }

    public static ArrayList<String> getRecyclerWhitelistConfigData() {
        return recyclerWhitelistConfigData;
    }
}

