/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags;

import java.util.HashMap;
import java.util.Random;
import mal.lootbags.LootbagsUtil;
import mal.lootbags.blocks.BlockOpener;
import mal.lootbags.blocks.BlockRecycler;
import mal.lootbags.config.BagConfigHandler;
import mal.lootbags.config.GeneralConfigHandler;
import mal.lootbags.handler.BagHandler;
import mal.lootbags.handler.ConfigReloadCommand;
import mal.lootbags.handler.GUIHandler;
import mal.lootbags.handler.ItemDumpCommand;
import mal.lootbags.handler.LootSourceCommand;
import mal.lootbags.handler.MobDropHandler;
import mal.lootbags.handler.NBTPullCommand;
import mal.lootbags.item.LootbagItem;
import mal.lootbags.loot.LootItem;
import mal.lootbags.loot.LootMap;
import mal.lootbags.loot.LootRecipe;
import mal.lootbags.network.CommonProxy;
import mal.lootbags.network.LootbagsPacketHandler;
import mal.lootbags.tileentity.TileEntityOpener;
import mal.lootbags.tileentity.TileEntityRecycler;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.logging.log4j.Level;

@Mod(modid="lootbags", version="2.1.3", acceptedMinecraftVersions="[1.10.2]")
public class LootBags {
    public static final String MODID = "lootbags";
    public static final String VERSION = "2.1.3";
    public static int SPECIALDROPCHANCE = 250;
    public static int DROPRESOLUTION = 1000;
    public static int CHESTQUALITYWEIGHT = 20;
    public static int CPERCENTILE = 100;
    public static int UPERCENTILE = 75;
    public static int RPERCENTILE = 50;
    public static int EPERCENTILE = 25;
    public static int LPERCENTILE = 5;
    public static boolean REVERSEQUALITY = true;
    public static boolean SHOWSECRETBAGS = true;
    private static boolean HASLOADED = false;
    public static boolean VERBOSEMODE = true;
    public static boolean DEBUGMODE = false;
    public static final int MINCHANCE = 0;
    public static final int MAXCHANCE = 1000;
    public static boolean LIMITONEBAGPERDROP = false;
    public static int BAGFROMPLAYERKILL = 2;
    public static int PREVENTDUPLICATELOOT = 0;
    public static int MINITEMSDROPPED = 1;
    public static int MAXITEMSDROPPED = 5;
    public static int MAXREROLLCOUNT = 50;
    public static double TOTALVALUEMULTIPLIER = 1.0;
    public static int RECYCLEDID = 0;
    public static double RECYCLERVALUENUMERATOR = 2.0;
    public static double RECYCLERVALUENONSTACK = 1.0;
    public static double RECYCLERVALUESTACK = 8.0;
    public static int OPENERMAXCOOLDOWN = 100;
    public static boolean PREVENTMERGEDBAGS = false;
    public static String[] LOOTCATEGORYLIST = null;
    public static String[] LOOTBAGINDUNGEONLOOT;
    private HashMap<String, Integer> totalvaluemap = new HashMap();
    public static boolean DISABLERECYCLER;
    public static boolean DISABLEOPENER;
    public static LootMap LOOTMAP;
    public static BagConfigHandler bagconfig;
    private static Random random;
    @SidedProxy(clientSide="mal.lootbags.network.ClientProxy", serverSide="mal.lootbags.network.CommonProxy")
    public static CommonProxy prox;
    public static LootbagItem lootbagItem;
    public static BlockRecycler recyclerBlock;
    public static BlockOpener openerBlock;
    @Mod.Instance(value="lootbags")
    public static LootBags LootBagsInstance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MobDropHandler handler = new MobDropHandler();
        MinecraftForge.EVENT_BUS.register((Object)handler);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)LootBagsInstance, (IGuiHandler)new GUIHandler());
        FMLLog.log((Level)Level.INFO, (String)"Your current LootBags version is: 2.1.3", (Object[])new Object[0]);
        GeneralConfigHandler.loadConfig(event);
        bagconfig = new BagConfigHandler(event);
        bagconfig.initBagConfig();
        LootbagsPacketHandler.init();
        lootbagItem = new LootbagItem();
        recyclerBlock = new BlockRecycler();
        openerBlock = new BlockOpener();
        if (CHESTQUALITYWEIGHT <= 0) {
            FMLLog.log((Level)Level.INFO, (String)"Chest Weighting < 1, this causes problems for everything and is terrible.  Setting it to 1 instead.", (Object[])new Object[0]);
            CHESTQUALITYWEIGHT = 1;
        }
        if (MAXREROLLCOUNT <= 0) {
            LootbagsUtil.LogInfo("Reroll count has to be at least 1 (fancy error prevention stuff)");
            MAXREROLLCOUNT = 1;
        }
        if (OPENERMAXCOOLDOWN < 0) {
            LootbagsUtil.LogInfo("Negative cooldown is not possible, setting it to 0.");
            OPENERMAXCOOLDOWN = 0;
        }
        if (TOTALVALUEMULTIPLIER <= 0.0) {
            LootbagsUtil.LogInfo("Free or negative value required for lootbag creation is not a good thing.  Setting it to 1.");
            TOTALVALUEMULTIPLIER = 1.0;
        }
        if (BagHandler.isIDFree(RECYCLEDID)) {
            LootbagsUtil.LogInfo("The requested ID is not actually a bag, using the lowest used ID.");
            RECYCLEDID = BagHandler.getLowestUsedID();
        }
        if (RECYCLERVALUESTACK <= 0.0) {
            LootbagsUtil.LogInfo("Dividing by zero or having a negative loot item value is not good.  Setting it to 1.0.");
            RECYCLERVALUESTACK = 1.0;
        }
        if (RECYCLERVALUENONSTACK <= 0.0) {
            LootbagsUtil.LogInfo("Dividing by zero or having a negative loot item value is not good.  Setting it to 1.0.");
            RECYCLERVALUENONSTACK = 1.0;
        }
        if (RECYCLERVALUENUMERATOR <= 0.0) {
            LootbagsUtil.LogInfo("Free or negative loot item value is not good.  Setting it to 1.0.");
            RECYCLERVALUENUMERATOR = 1.0;
        }
        prox.registerRenderersPreInit();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        prox.registerRenderersInit();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        GameRegistry.registerTileEntity(TileEntityRecycler.class, (String)"lootbags_tileentityrecycler");
        GameRegistry.registerTileEntity(TileEntityOpener.class, (String)"lootbags_tileentityopener");
        RecipeSorter.register((String)"lootbags:lootrecipe", LootRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        LOOTMAP = new LootMap();
        LOOTMAP.populateGeneralBlacklist(GeneralConfigHandler.getBlacklistConfigData());
        LOOTMAP.populateGeneralWhitelist(GeneralConfigHandler.getWhitelistConfigData());
        LOOTMAP.populateRecyclerBlacklist(GeneralConfigHandler.getRecyclerBlacklistConfigData());
        LOOTMAP.populateRecyclerWhitelist(GeneralConfigHandler.getRecyclerWhitelistConfigData());
        LOOTMAP.setLootSources(LOOTCATEGORYLIST);
        if (!DISABLERECYCLER) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack((Block)recyclerBlock), new Object[]{"SSS", "SCS", "SIS", Character.valueOf('S'), "stone", Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae), Character.valueOf('I'), "ingotIron"}));
        }
        if (!DISABLEOPENER) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack((Block)openerBlock), new Object[]{"SIS", "SCS", "SSS", Character.valueOf('S'), "stone", Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae), Character.valueOf('I'), "ingotIron"}));
        }
        BagHandler.generateBagRecipes(CraftingManager.func_77594_a().func_77592_b());
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new ItemDumpCommand());
        event.registerServerCommand((ICommand)new LootSourceCommand());
        event.registerServerCommand((ICommand)new NBTPullCommand());
        event.registerServerCommand((ICommand)new ConfigReloadCommand());
    }

    @Mod.EventHandler
    public void serverLoaded(FMLServerStartedEvent event) {
        if (!HASLOADED) {
            LOOTMAP.populateGeneralMap((World)FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0]);
            BagHandler.populateBagLists();
            LOOTMAP.setTotalListWeight();
            LootbagsUtil.LogInfo("Completed on-load tasks.");
            HASLOADED = true;
        }
    }

    public static boolean isItemDroppable(ItemStack item) {
        for (LootItem loot : LootBags.LOOTMAP.recyclerWhitelist) {
            if (!LootBags.areItemStacksEqualItem(loot.getContentItem(), item, true, false)) continue;
            return true;
        }
        for (LootItem loot : LootBags.LOOTMAP.totalList.values()) {
            if (!LootBags.areItemStacksEqualItem(loot.getContentItem(), item, true, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemRecyleBlacklisted(ItemStack item) {
        for (LootItem loot : LootBags.LOOTMAP.recyclerBlacklist) {
            if (!LootBags.areItemStacksEqualItem(loot.getContentItem(), item, true, false)) continue;
            return true;
        }
        return false;
    }

    public static int getItemValue(ItemStack item) {
        for (LootItem c : LootBags.LOOTMAP.recyclerWhitelist) {
            if (!LootBags.areItemStacksEqualItem(c.getContentItem(), item, true, false)) continue;
            double value = Math.ceil(RECYCLERVALUENUMERATOR * (double)LOOTMAP.getTotalListWeight() / ((double)c.getItemWeight() * (item.func_77976_d() == 1 ? RECYCLERVALUENONSTACK : RECYCLERVALUESTACK)));
            if (value <= 0.0) {
                value = 1.0;
            }
            return (int)value;
        }
        for (LootItem c : LootBags.LOOTMAP.totalList.values()) {
            if (!LootBags.areItemStacksEqualItem(c.getContentItem(), item, true, false)) continue;
            double value = Math.ceil(RECYCLERVALUENUMERATOR * (double)LOOTMAP.getTotalListWeight() / ((double)c.getItemWeight() * (item.func_77976_d() == 1 ? RECYCLERVALUENONSTACK : RECYCLERVALUESTACK)));
            if (value <= 0.0) {
                value = 1.0;
            }
            return (int)value;
        }
        return 0;
    }

    public static boolean areItemStacksEqualItem(ItemStack is1, ItemStack is2, boolean alwaysUseDamage, boolean considerNBT) {
        if (is1 == null ^ is2 == null) {
            return false;
        }
        if (Item.func_150891_b((Item)is1.func_77973_b()) != Item.func_150891_b((Item)is2.func_77973_b())) {
            return false;
        }
        if (alwaysUseDamage && is1.func_77981_g() && is2.func_77981_g() && is1.func_77952_i() != is2.func_77952_i()) {
            return false;
        }
        return !considerNBT || ItemStack.func_77970_a((ItemStack)is1, (ItemStack)is2);
    }

    public static int getDefaultDropWeight() {
        return DROPRESOLUTION / 10;
    }

    public static Random getRandom() {
        return random;
    }

    static {
        DISABLERECYCLER = false;
        DISABLEOPENER = false;
        random = new Random();
    }
}

