/*
 * Decompiled with CFR 0.152.
 */
package CustomSteve_Server;

import CustomSteve.NetWorkPacket.P000_Login;
import CustomSteve.NetWorkPacket.P100_ModelInfomation;
import CustomSteve.NetWorkPacket.P200_ModelInfomationUpdate;
import CustomSteve.NetWorkPacket.P201_AnimationStatus;
import CustomSteve.NetWorkPacket.P400_Error;
import CustomSteve_Server.CSmanager_Server;
import CustomSteve_Server.Commands.Whitelist;
import CustomSteve_Server.Config;
import CustomSteve_Server.Event.NetWorkHandler;
import CustomSteve_Server.PacketPipelineServer;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraft.launchwrapper.LaunchClassLoader;

@SideOnly(value=Side.SERVER)
@Mod(modid="customsteveserver", name="CustomSteveServer", version="1.1.0Beta")
public class ModContainer {
    public static final PacketPipelineServer packetPipeline = new PacketPipelineServer();
    public static final String VERSION = "1.1.0Beta";
    public static String classPath;
    public static iList myConfig;
    public static ModContainer INSTANCE;

    public ModContainer() {
        INSTANCE = this;
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        for (int i = 0; i < ((LaunchClassLoader)this.getClass().getClassLoader()).getSources().size(); ++i) {
            classPath = new File(((URL)((LaunchClassLoader)this.getClass().getClassLoader()).getSources().get(i)).getFile()).getAbsolutePath().replace("%20", " ");
            if (classPath.indexOf("CustomSteve") == -1 || classPath.indexOf(".jar") == -1) continue;
            classPath = classPath.replace(classPath.substring(classPath.lastIndexOf("\\")), "");
            break;
        }
        this.loadMyConfig();
        if (Config.whitelist) {
            this.loadWhitelist();
        }
        packetPipeline.initialise();
        packetPipeline.registerPacket(P000_Login.class);
        packetPipeline.registerPacket(P100_ModelInfomation.class);
        packetPipeline.registerPacket(P200_ModelInfomationUpdate.class);
        packetPipeline.registerPacket(P201_AnimationStatus.class);
        packetPipeline.registerPacket(P400_Error.class);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        NetWorkHandler pa = new NetWorkHandler();
        packetPipeline.postInitialise();
    }

    @NetworkCheckHandler
    public boolean checker(Map<String, String> versions, Side side) {
        return true;
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent ev) {
        ev.registerServerCommand((ICommand)new Whitelist());
    }

    @Mod.EventHandler
    public void onServerStoping(FMLServerStoppingEvent ev) {
        this.saveMyConfig();
        if (Config.whitelist) {
            this.saveWhitelist();
        }
    }

    public void loadWhitelist() {
        try {
            File file = new File(classPath + "/" + "CustomSteve_Server/whitelist.txt");
            CSmanager_Server.instance.whiteList = new ArrayList();
            if (!file.exists()) {
                this.saveWhitelist();
            }
            InputStreamReader read = new InputStreamReader(new FileInputStream(file));
            BufferedReader bufferedReader = new BufferedReader(read);
            String lineTxt = null;
            while ((lineTxt = bufferedReader.readLine()) != null) {
                CSmanager_Server.instance.whiteList.add(lineTxt);
            }
            read.close();
        }
        catch (Exception e) {
            System.out.println("[CustomSteve_Server]Failed to load config file\n" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void saveWhitelist() {
        try {
            File file = new File(classPath + "/" + "CustomSteve_Server/whitelist.txt");
            file.mkdirs();
            if (file.exists()) {
                file.delete();
            }
            if (!file.createNewFile()) {
                throw new IOException("[CustomSteve_Server]Failed to re-create config file.");
            }
            if (CSmanager_Server.instance.whiteList == null) {
                return;
            }
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file));
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            for (int i = 0; i < CSmanager_Server.instance.whiteList.size(); ++i) {
                bufferedWriter.write(CSmanager_Server.instance.whiteList.get(i));
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            writer.close();
        }
        catch (Exception e) {
            System.out.println("[CustomSteve_Server]Failed to load config file");
            e.printStackTrace();
        }
    }

    public void loadMyConfig() {
        myConfig = new iList();
        try {
            File file = new File(classPath + "/" + "CustomSteve_Server/CS_Server.txt");
            if (!file.exists()) {
                this.saveMyConfig();
            }
            InputStreamReader read = new InputStreamReader(new FileInputStream(file));
            BufferedReader bufferedReader = new BufferedReader(read);
            String lineTxt = null;
            while ((lineTxt = bufferedReader.readLine()) != null) {
                String status;
                if (lineTxt.indexOf("whitelist:") != -1) {
                    status = lineTxt.replace("whitelist:", "");
                    Config.whitelist = status.equals("yes");
                    continue;
                }
                if (lineTxt.indexOf("modelVerify:") != -1) {
                    status = lineTxt.replace("modelVerify:", "");
                    Config.modelVerify = status.equals("yes");
                    continue;
                }
                if (lineTxt.indexOf("maxEntity:") != -1) {
                    ModContainer.myConfig.maxEntity = Integer.parseInt(lineTxt.replace("maxEntity:", ""));
                    continue;
                }
                if (lineTxt.indexOf("modelLimits:") != -1) {
                    status = lineTxt.replace("modelLimits:", "");
                    Config.modelLimits = status.equals("yes");
                    continue;
                }
                if (lineTxt.indexOf("maxVertex:") != -1) {
                    ModContainer.myConfig.maxVertex = Integer.parseInt(lineTxt.replace("maxVertex:", ""));
                    continue;
                }
                if (lineTxt.indexOf("maxTexture:") != -1) {
                    ModContainer.myConfig.maxTexture = Integer.parseInt(lineTxt.replace("maxTexture:", ""));
                    continue;
                }
                if (lineTxt.indexOf("maxTexturexSize:") != -1) {
                    ModContainer.myConfig.maxTextureSize = Integer.parseInt(lineTxt.replace("maxTexturexSize:", ""));
                    continue;
                }
                if (lineTxt.indexOf("maxIK:") != -1) {
                    ModContainer.myConfig.maxIK = Integer.parseInt(lineTxt.replace("maxIK:", ""));
                    continue;
                }
                if (lineTxt.indexOf("maxRigidBody:") != -1) {
                    ModContainer.myConfig.maxRigidBody = Integer.parseInt(lineTxt.replace("maxRigidBody:", ""));
                    continue;
                }
                if (lineTxt.indexOf("maxScaleX:") != -1) {
                    ModContainer.myConfig.maxScale_X = Float.parseFloat(lineTxt.replace("maxScaleX:", ""));
                    continue;
                }
                if (lineTxt.indexOf("maxScaleY:") != -1) {
                    ModContainer.myConfig.maxScale_Y = Float.parseFloat(lineTxt.replace("maxScaleY:", ""));
                    continue;
                }
                if (lineTxt.indexOf("maxScaleZ:") == -1) continue;
                ModContainer.myConfig.maxScale_Z = Float.parseFloat(lineTxt.replace("maxScaleZ:", ""));
            }
            read.close();
        }
        catch (Exception e) {
            System.out.println("[CustomSteve_Server]Failed to load config file\n" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void saveMyConfig() {
        try {
            File file = new File(classPath + "/" + "CustomSteve_Server/CS_Server.txt");
            file.mkdirs();
            if (file.exists()) {
                file.delete();
            }
            if (!file.createNewFile()) {
                throw new IOException("[CustomSteve_Server]Failed to re-create config file.");
            }
            OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file));
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            bufferedWriter.write("whitelist:");
            bufferedWriter.write(Config.whitelist ? "yes" : "no");
            bufferedWriter.newLine();
            bufferedWriter.write("modelVerify:");
            bufferedWriter.write(Config.modelVerify ? "yes" : "no");
            bufferedWriter.newLine();
            bufferedWriter.write("maxEntity:");
            bufferedWriter.write(new Integer(ModContainer.myConfig.maxEntity).toString());
            bufferedWriter.newLine();
            bufferedWriter.write("modelLimits:");
            bufferedWriter.write(Config.modelLimits ? "yes" : "no");
            bufferedWriter.newLine();
            bufferedWriter.write("maxVertex:");
            bufferedWriter.write(new Integer(ModContainer.myConfig.maxVertex).toString());
            bufferedWriter.newLine();
            bufferedWriter.write("maxTexture:");
            bufferedWriter.write(new Integer(ModContainer.myConfig.maxTexture).toString());
            bufferedWriter.newLine();
            bufferedWriter.write("maxTexturexSize:");
            bufferedWriter.write(new Integer(ModContainer.myConfig.maxTextureSize).toString());
            bufferedWriter.newLine();
            bufferedWriter.write("maxIK:");
            bufferedWriter.write(new Integer(ModContainer.myConfig.maxIK).toString());
            bufferedWriter.newLine();
            bufferedWriter.write("maxRigidBody:");
            bufferedWriter.write(new Integer(ModContainer.myConfig.maxRigidBody).toString());
            bufferedWriter.newLine();
            bufferedWriter.write("maxScaleX:");
            bufferedWriter.write(new Float(ModContainer.myConfig.maxScale_X).toString());
            bufferedWriter.newLine();
            bufferedWriter.write("maxScaleY:");
            bufferedWriter.write(new Float(ModContainer.myConfig.maxScale_Y).toString());
            bufferedWriter.newLine();
            bufferedWriter.write("maxScaleZ:");
            bufferedWriter.write(new Float(ModContainer.myConfig.maxScale_Z).toString());
            bufferedWriter.flush();
            bufferedWriter.close();
            writer.close();
        }
        catch (Exception e) {
            System.out.println("[CustomSteve_Server]Failed to load config file");
            e.printStackTrace();
        }
    }

    public class iList {
        public int maxEntity = 0;
        public int maxVertex = 0;
        public int maxTexture = 0;
        public int maxTextureSize = 0;
        public int maxIK = 0;
        public int maxRigidBody = 0;
        public float maxScale_X = 0.0f;
        public float maxScale_Y = 0.0f;
        public float maxScale_Z = 0.0f;
    }
}

