/*
 * Decompiled with CFR 0.152.
 */
package fr.eyzox.forgecreeperheal.worldhealer;

import fr.eyzox.forgecreeperheal.ForgeCreeperHeal;
import fr.eyzox.forgecreeperheal.Profiler;
import fr.eyzox.forgecreeperheal.worldhealer.BlockData;
import fr.eyzox.forgecreeperheal.worldhealer.HealTask;
import fr.eyzox.forgecreeperheal.worldhealer.WorldHealerUtils;
import fr.eyzox.ticklinkedlist.TickContainer;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fluids.FluidRegistry;

public class WorldHealer
extends WorldSavedData {
    private World world;
    private HealTask toHeal = new HealTask();
    private Profiler profiler;

    public WorldHealer() {
        this(WorldHealer.getDataStorageKey());
    }

    public WorldHealer(String key) {
        super(key);
    }

    public void onTick() {
        Collection blocksToHeal;
        if (this.profiler != null) {
            this.profiler.begin();
            this.profiler.tickStart();
        }
        if ((blocksToHeal = (Collection)this.toHeal.tick()) != null) {
            for (BlockData blockData : blocksToHeal) {
                this.heal(blockData);
            }
        }
        if (this.profiler != null) {
            this.profiler.tickStop();
            this.profiler.handleMemoryUse(this.toHeal.getLinkedList());
            this.profiler.report();
        }
    }

    public void onDetonate(ExplosionEvent.Detonate event) {
        Block block;
        if (this.profiler != null) {
            this.profiler.explosionStart();
        }
        int maxTicksBeforeHeal = 0;
        for (ChunkPosition c : event.getAffectedBlocks()) {
            block = event.world.func_147439_a(c.field_151329_a, c.field_151327_b, c.field_151328_c);
            if (!block.func_149721_r()) continue;
            int ticksBeforeHeal = ForgeCreeperHeal.getConfig().getMinimumTicksBeforeHeal() + this.world.field_73012_v.nextInt(ForgeCreeperHeal.getConfig().getRandomTickVar());
            if (ticksBeforeHeal > maxTicksBeforeHeal) {
                maxTicksBeforeHeal = ticksBeforeHeal;
            }
            this.onBlockHealed(c, block, ticksBeforeHeal);
        }
        ++maxTicksBeforeHeal;
        for (ChunkPosition c : event.getAffectedBlocks()) {
            block = event.world.func_147439_a(c.field_151329_a, c.field_151327_b, c.field_151328_c);
            if (block.func_149721_r() || block.isAir((IBlockAccess)event.world, c.field_151329_a, c.field_151327_b, c.field_151328_c)) continue;
            this.onBlockHealed(c, block, maxTicksBeforeHeal + this.world.field_73012_v.nextInt(ForgeCreeperHeal.getConfig().getRandomTickVar()));
        }
        if (this.profiler != null) {
            this.profiler.explosionStop();
        }
    }

    private void onBlockHealed(ChunkPosition c, Block block, int ticks) {
        TileEntity te;
        if (ForgeCreeperHeal.getConfig().isDropItemsFromContainer() && !ForgeCreeperHeal.getConfig().getRemoveException().contains(block) && (te = this.world.func_147438_o(c.field_151329_a, c.field_151327_b, c.field_151328_c)) instanceof IInventory) {
            WorldHealerUtils.dropInventory(this.world, c, (IInventory)te);
        }
        if (!ForgeCreeperHeal.getConfig().getHealException().contains(block)) {
            this.toHeal.add(ticks, new BlockData(this.world, c));
        }
        if (!ForgeCreeperHeal.getConfig().getRemoveException().contains(block)) {
            this.world.func_147475_p(c.field_151329_a, c.field_151327_b, c.field_151328_c);
            this.world.func_147465_d(c.field_151329_a, c.field_151327_b, c.field_151328_c, Blocks.field_150350_a, 0, 7);
        }
    }

    private void heal(BlockData blockData) {
        boolean isAir = this.world.func_147437_c(blockData.getChunkPosition().field_151329_a, blockData.getChunkPosition().field_151327_b, blockData.getChunkPosition().field_151328_c);
        if (ForgeCreeperHeal.getConfig().isOverride() || isAir || ForgeCreeperHeal.getConfig().isOverrideFluid() && FluidRegistry.lookupFluidForBlock((Block)this.world.func_147439_a(blockData.getChunkPosition().field_151329_a, blockData.getChunkPosition().field_151327_b, blockData.getChunkPosition().field_151328_c)) != null) {
            TileEntity te;
            if (ForgeCreeperHeal.getConfig().isDropIfAlreadyBlock() && !isAir) {
                this.world.func_72838_d((Entity)WorldHealerUtils.getEntityItem(this.world, blockData.getChunkPosition(), new ItemStack(this.world.func_147439_a(blockData.getChunkPosition().field_151329_a, blockData.getChunkPosition().field_151327_b, blockData.getChunkPosition().field_151328_c)), this.world.field_73012_v.nextFloat() * 0.8f + 0.1f, this.world.field_73012_v.nextFloat() * 0.8f + 0.1f, this.world.field_73012_v.nextFloat() * 0.8f + 0.1f, 0.05f));
                te = this.world.func_147438_o(blockData.getChunkPosition().field_151329_a, blockData.getChunkPosition().field_151327_b, blockData.getChunkPosition().field_151328_c);
                if (te instanceof IInventory) {
                    WorldHealerUtils.dropInventory(this.world, blockData.getChunkPosition(), (IInventory)te);
                }
            }
            this.world.func_147465_d(blockData.getChunkPosition().field_151329_a, blockData.getChunkPosition().field_151327_b, blockData.getChunkPosition().field_151328_c, blockData.getBlock(), blockData.getMetadata(), 7);
            this.world.func_72921_c(blockData.getChunkPosition().field_151329_a, blockData.getChunkPosition().field_151327_b, blockData.getChunkPosition().field_151328_c, blockData.getMetadata(), 7);
            if (blockData.getTileEntityTag() != null && (te = this.world.func_147438_o(blockData.getChunkPosition().field_151329_a, blockData.getChunkPosition().field_151327_b, blockData.getChunkPosition().field_151328_c)) != null) {
                te.func_145839_a(blockData.getTileEntityTag());
                this.world.func_147455_a(blockData.getChunkPosition().field_151329_a, blockData.getChunkPosition().field_151327_b, blockData.getChunkPosition().field_151328_c, te);
            }
        } else if (ForgeCreeperHeal.getConfig().isDropIfAlreadyBlock()) {
            TileEntity te;
            this.world.func_72838_d((Entity)WorldHealerUtils.getEntityItem(this.world, blockData.getChunkPosition(), new ItemStack(blockData.getBlock()), this.world.field_73012_v.nextFloat() * 0.8f + 0.1f, this.world.field_73012_v.nextFloat() * 0.8f + 0.1f, this.world.field_73012_v.nextFloat() * 0.8f + 0.1f, 0.05f));
            if (blockData.getTileEntityTag() != null && (te = blockData.getBlock().createTileEntity(this.world, blockData.getMetadata())) instanceof IInventory) {
                te.func_145839_a(blockData.getTileEntityTag());
                WorldHealerUtils.dropInventory(this.world, blockData.getChunkPosition(), (IInventory)te);
            }
        }
    }

    public World getWorld() {
        return this.world;
    }

    public void func_76184_a(NBTTagCompound tag) {
        NBTTagList tagList = (NBTTagList)tag.func_74781_a("toHeal");
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tickContainerTag = tagList.func_150305_b(i);
            int ticksLeft = tickContainerTag.func_74762_e("ticks");
            LinkedList<BlockData> blockDataList = new LinkedList<BlockData>();
            NBTTagList blockDataListTag = (NBTTagList)tickContainerTag.func_74781_a("blockdatalist");
            for (int j = 0; j < blockDataListTag.func_74745_c(); ++j) {
                NBTTagCompound blockDataTag = blockDataListTag.func_150305_b(j);
                BlockData blockData = new BlockData();
                blockData.readFromNBT(blockDataTag);
                blockDataList.add(blockData);
            }
            this.toHeal.getLinkedList().addLast(new TickContainer(ticksLeft, blockDataList));
        }
    }

    public void func_76187_b(NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (TickContainer tickContainer : this.toHeal.getLinkedList()) {
            NBTTagCompound tickContainerTag = new NBTTagCompound();
            tickContainerTag.func_74768_a("ticks", tickContainer.getTick());
            NBTTagList blockDataListTag = new NBTTagList();
            for (BlockData blockData : (Collection)tickContainer.getData()) {
                NBTTagCompound blockDataTag = new NBTTagCompound();
                blockData.writeToNBT(blockDataTag);
                blockDataListTag.func_74742_a((NBTBase)blockDataTag);
            }
            tickContainerTag.func_74782_a("blockdatalist", (NBTBase)blockDataListTag);
            tagList.func_74742_a((NBTBase)tickContainerTag);
        }
        tag.func_74782_a("toHeal", (NBTBase)tagList);
    }

    public static WorldHealer loadWorldHealer(World w) {
        MapStorage storage = w.perWorldStorage;
        String KEY = WorldHealer.getDataStorageKey();
        WorldHealer result = (WorldHealer)storage.func_75742_a(WorldHealer.class, KEY);
        if (result == null) {
            result = new WorldHealer(KEY);
            storage.func_75745_a(KEY, (WorldSavedData)result);
            ForgeCreeperHeal.getLogger().info("Unable to find data for world " + w.func_72912_H().func_76065_j() + "[" + w.field_73011_w.field_76574_g + "], new data created");
        }
        result.world = w;
        return result;
    }

    public static String getDataStorageKey() {
        return "forgecreeperheal:" + WorldHealer.class.getSimpleName();
    }

    public boolean func_76188_b() {
        return true;
    }

    public void enableProfiler(ICommandSender sender) {
        if (this.profiler == null) {
            this.profiler = new Profiler(this);
        }
        this.profiler.addListener(sender);
    }

    public void disableProfiler(ICommandSender sender) {
        if (this.profiler != null) {
            this.profiler.removeListener(sender);
        }
    }

    public void disableProfiler() {
        this.profiler = null;
    }

    public boolean isProfilerEnabled() {
        return this.profiler != null;
    }

    public Profiler getProfiler() {
        return this.profiler;
    }
}

