/*
 * Decompiled with CFR 0.152.
 */
package fr.eyzox.forgecreeperheal.worldhealer;

import cpw.mods.fml.common.registry.GameData;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public class BlockData {
    private Block block;
    private int metadata;
    private NBTTagCompound tileEntityTag;
    private ChunkPosition chunkPosition;

    public BlockData(World world, ChunkPosition chunkPosition) {
        this(world.func_147439_a(chunkPosition.field_151329_a, chunkPosition.field_151327_b, chunkPosition.field_151328_c));
        this.chunkPosition = chunkPosition;
        this.metadata = world.func_72805_g(chunkPosition.field_151329_a, chunkPosition.field_151327_b, chunkPosition.field_151328_c);
        TileEntity te = world.func_147438_o(chunkPosition.field_151329_a, chunkPosition.field_151327_b, chunkPosition.field_151328_c);
        if (te != null) {
            this.tileEntityTag = new NBTTagCompound();
            te.func_145841_b(this.tileEntityTag);
        }
    }

    protected BlockData(Block block) {
        this.block = block;
    }

    protected BlockData() {
    }

    public Block getBlock() {
        return this.block;
    }

    public int getMetadata() {
        return this.metadata;
    }

    public ChunkPosition getChunkPosition() {
        return this.chunkPosition;
    }

    public NBTTagCompound getTileEntityTag() {
        return this.tileEntityTag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.block = Block.func_149684_b((String)tag.func_74779_i("block"));
        this.metadata = tag.func_74762_e("metadata");
        int[] coords = tag.func_74759_k("chunkposition");
        this.chunkPosition = new ChunkPosition(coords[0], coords[1], coords[2]);
        this.tileEntityTag = tag.func_74775_l("tileentity");
        if (this.tileEntityTag.func_82582_d()) {
            this.tileEntityTag = null;
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("block", GameData.getBlockRegistry().func_148750_c((Object)this.block));
        if (this.metadata != 0) {
            tag.func_74768_a("metadata", this.metadata);
        }
        tag.func_74783_a("chunkposition", new int[]{this.chunkPosition.field_151329_a, this.chunkPosition.field_151327_b, this.chunkPosition.field_151328_c});
        if (this.tileEntityTag != null) {
            tag.func_74782_a("tileentity", (NBTBase)this.tileEntityTag);
        }
    }
}

