/*
 * Decompiled with CFR 0.152.
 */
package fr.eyzox.forgecreeperheal.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import fr.eyzox.forgecreeperheal.PlayerModData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;

public class ModDataMessage
implements IMessage {
    private String modVersion;

    public void fromBytes(ByteBuf buf) {
        this.modVersion = String.format("%d.%d.%d", buf.readByte(), buf.readByte(), buf.readByte());
    }

    public void toBytes(ByteBuf buf) {
        String[] versionTab = this.modVersion.split("\\.");
        for (int i = 0; i < 3; ++i) {
            buf.writeByte((int)Byte.parseByte(versionTab[i]));
        }
    }

    public ModDataMessage fill() {
        this.modVersion = "1.1.1";
        return this;
    }

    public static class Handler
    implements IMessageHandler<ModDataMessage, IMessage> {
        public IMessage onMessage(ModDataMessage message, MessageContext ctx) {
            if (message.modVersion != null) {
                PlayerModData data = new PlayerModData(message.modVersion);
                PlayerModData.register((EntityPlayer)ctx.getServerHandler().field_147369_b, data);
            }
            return null;
        }
    }
}

