/*
 * Decompiled with CFR 0.152.
 */
package fr.eyzox.forgecreeperheal.proxy;

import fr.eyzox.forgecreeperheal.Config;
import fr.eyzox.forgecreeperheal.handler.ExplosionEventHandler;
import fr.eyzox.forgecreeperheal.handler.WorldEventHandler;
import fr.eyzox.forgecreeperheal.handler.WorldTickEventHandler;
import fr.eyzox.forgecreeperheal.network.ProfilerInfoMessage;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

public class CommonProxy {
    private Logger logger;
    private Config config;
    private WorldEventHandler worldEventHandler;
    private SimpleNetworkWrapper channel;

    public void onPreInit(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        this.config = new Config(new Configuration(event.getSuggestedConfigurationFile()));
    }

    public void onInit(FMLInitializationEvent event) {
        this.worldEventHandler = new WorldEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)new WorldTickEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)this.worldEventHandler);
        MinecraftForge.EVENT_BUS.register((Object)new ExplosionEventHandler());
        this.channel = NetworkRegistry.INSTANCE.newSimpleChannel("forgecreeperheal:ch0");
        this.channel.registerMessage(ProfilerInfoMessage.Handler.class, ProfilerInfoMessage.class, 1, Side.CLIENT);
    }

    public static void addChatMessage(ICommandSender sender, TextComponentTranslation msg) {
        sender.func_145747_a((ITextComponent)msg);
    }

    public static void addChatMessage(ICommandSender sender, String string) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(I18n.func_135052_a((String)string, (Object[])new Object[0]), new Object[0]));
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Config getConfig() {
        return this.config;
    }

    public WorldEventHandler getWorldEventHandler() {
        return this.worldEventHandler;
    }

    public SimpleNetworkWrapper getChannel() {
        return this.channel;
    }

    public void setConfig(Config config) {
        this.config = config;
    }
}

