/*
 * Decompiled with CFR 0.152.
 */
package fr.eyzox.forgecreeperheal.network;

import fr.eyzox.forgecreeperheal.ForgeCreeperHeal;
import fr.eyzox.forgecreeperheal.proxy.ClientProxy;
import io.netty.buffer.ByteBuf;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProfilerInfoMessage
implements IMessage {
    private String worldName;
    private int dimensionID;
    private double ticks;
    private long blocksUsed;
    private transient int displayTicks;

    public ProfilerInfoMessage() {
    }

    public ProfilerInfoMessage(World world, double ticks, long blocksUsed) {
        this.worldName = world.func_72912_H().func_76065_j();
        this.dimensionID = world.field_73011_w.getDimension();
        this.ticks = ticks;
        this.blocksUsed = blocksUsed;
    }

    public void fromBytes(ByteBuf buf) {
        this.worldName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.dimensionID = buf.readInt();
        this.ticks = buf.readDouble();
        this.blocksUsed = buf.readLong();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.worldName);
        buf.writeInt(this.dimensionID);
        buf.writeDouble(this.ticks);
        buf.writeLong(this.blocksUsed);
    }

    @SideOnly(value=Side.CLIENT)
    public int getDisplayTicks() {
        return this.displayTicks;
    }

    @SideOnly(value=Side.CLIENT)
    public void setDisplayTicks(int displayTicks) {
        this.displayTicks = displayTicks;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public int getDimensionID() {
        return this.dimensionID;
    }

    public double getTicks() {
        return this.ticks;
    }

    public long getBlocksUsed() {
        return this.blocksUsed;
    }

    public static class Handler
    implements IMessageHandler<ProfilerInfoMessage, IMessage> {
        public IMessage onMessage(ProfilerInfoMessage message, MessageContext ctx) {
            if (ForgeCreeperHeal.getProxy() instanceof ClientProxy) {
                ((ClientProxy)ForgeCreeperHeal.getProxy()).getProfilerRenderEventHandler().onMessage(message);
            }
            return null;
        }
    }
}

