/*
 * Decompiled with CFR 0.152.
 */
package fr.eyzox.forgecreeperheal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import fr.eyzox.forgecreeperheal.ForgeCreeperHeal;
import fr.eyzox.forgecreeperheal.json.adapter.BlockAdapter;
import fr.eyzox.forgecreeperheal.json.adapter.ClassAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;

public class Config {
    private int minimumTicksBeforeHeal = 6000;
    private int randomTickVar = 12000;
    private boolean override = false;
    private boolean overrideFluid = true;
    private boolean dropItemsFromContainer = true;
    private boolean dropIfAlreadyBlock = false;
    private Set<Block> removeException = new HashSet<Block>();
    private Set<Block> healException = new HashSet<Block>();
    private Set<Class<? extends Entity>> fromEntityException = new HashSet<Class<? extends Entity>>();
    private transient File configFile;

    public int getMinimumTicksBeforeHeal() {
        return this.minimumTicksBeforeHeal;
    }

    public int getRandomTickVar() {
        return this.randomTickVar;
    }

    public boolean isOverride() {
        return this.override;
    }

    public boolean isOverrideFluid() {
        return this.overrideFluid;
    }

    public boolean isDropItemsFromContainer() {
        return this.dropItemsFromContainer;
    }

    public boolean isDropIfAlreadyBlock() {
        return this.dropIfAlreadyBlock;
    }

    public Set<Block> getRemoveException() {
        return this.removeException;
    }

    public Set<Block> getHealException() {
        return this.healException;
    }

    public Set<Class<? extends Entity>> getFromEntityException() {
        return this.fromEntityException;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(File f) {
        this.configFile = f;
    }

    private void loadDefaultConfig() {
        this.removeException.add(Blocks.field_150335_W);
        this.healException.add(Blocks.field_150335_W);
    }

    public void save() {
        Gson gson = Config.getGsonBuilder().setPrettyPrinting().excludeFieldsWithModifiers(new int[]{128}).create();
        try {
            PrintWriter pw = new PrintWriter(this.configFile);
            gson.toJson((Object)this, (Appendable)pw);
            pw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            ForgeCreeperHeal.getLogger().warn("Unable to save configuration file at " + this.configFile.getAbsolutePath());
        }
    }

    public static Config loadConfig(File configFile) {
        Config c = null;
        if (configFile.exists() && configFile.length() > 0L) {
            Gson gson = Config.getGsonBuilder().create();
            try {
                c = (Config)gson.fromJson((Reader)new FileReader(configFile), Config.class);
                c.setConfigFile(configFile);
            }
            catch (JsonParseException e) {
                e.printStackTrace();
                ForgeCreeperHeal.getLogger().warn("Unable to load configuration from " + configFile.getAbsolutePath() + " loading default configuration");
                c = new Config();
                c.loadDefaultConfig();
            }
            catch (FileNotFoundException e) {
                ForgeCreeperHeal.getLogger().info("Unable to find configuration file from " + configFile.getAbsolutePath() + " : creating a config file at this location with default configuration");
                c = Config.createNewConfig(configFile);
            }
        } else {
            c = Config.createNewConfig(configFile);
        }
        return c;
    }

    private static Config createNewConfig(File configFile) {
        Config c = new Config();
        c.loadDefaultConfig();
        c.setConfigFile(configFile);
        c.save();
        return c;
    }

    private static GsonBuilder getGsonBuilder() {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeHierarchyAdapter(Block.class, (Object)new BlockAdapter());
        gson.registerTypeHierarchyAdapter(Class.class, (Object)new ClassAdapter());
        return gson;
    }

    public String toString() {
        return "Config [\n\tminimumTicksBeforeHeal=" + this.minimumTicksBeforeHeal + "\n\trandomTickVar=" + this.randomTickVar + "\n\toverride=" + this.override + "\n\tdropItempFromContainer=" + this.dropItemsFromContainer + "\n\tremoveException=" + this.removeException + "\n\thealException=" + this.healException + "\n\tfromEntityException=" + this.fromEntityException + "\n]";
    }
}

