/*
 * Decompiled with CFR 0.152.
 */
package fr.eyzox.forgecreeperheal.worldhealer;

import fr.eyzox.forgecreeperheal.ForgeCreeperHeal;
import fr.eyzox.forgecreeperheal.Profiler;
import fr.eyzox.forgecreeperheal.worldhealer.BlockData;
import fr.eyzox.forgecreeperheal.worldhealer.HealTask;
import fr.eyzox.forgecreeperheal.worldhealer.WorldHealerUtils;
import fr.eyzox.ticklinkedlist.TickContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fluids.FluidRegistry;
import org.apache.logging.log4j.Level;

public class WorldHealer
extends WorldSavedData {
    private World world;
    private HealTask healTask;
    private Profiler profiler;
    private boolean logspam = false;
    private ArrayList<Block> blacklist = new ArrayList();

    public WorldHealer(String key) {
        super(key);
        this.healTask = new HealTask();
        this.blacklist.add(null);
        this.blacklist.add(Blocks.field_150350_a);
        this.blacklist.add(Blocks.field_150324_C);
        this.blacklist.add(Blocks.field_180410_as);
        this.blacklist.add(Blocks.field_180411_ar);
        this.blacklist.add(Blocks.field_180412_aq);
        this.blacklist.add(Blocks.field_180413_ao);
        this.blacklist.add(Blocks.field_180409_at);
    }

    public World getWorld() {
        return this.world;
    }

    public void onTick() {
        Collection blocksToHeal;
        if (this.profiler != null) {
            this.profiler.begin();
            this.profiler.tickStart();
        }
        if ((blocksToHeal = (Collection)this.healTask.tick()) != null) {
            for (BlockData blockData : blocksToHeal) {
                this.heal(blockData);
            }
        }
        if (this.profiler != null) {
            this.profiler.tickStop();
            this.profiler.handleMemoryUse(this.healTask.getLinkedList());
            this.profiler.report();
        }
    }

    public void onDetonate(ExplosionEvent.Detonate event) {
        IBlockState blockStateExplosion;
        if (this.profiler != null) {
            this.profiler.explosionStart();
        }
        World world = event.getWorld();
        int maxTicksBeforeHeal = 0;
        for (BlockPos blockPosExplosion : event.getAffectedBlocks()) {
            blockStateExplosion = world.func_180495_p(blockPosExplosion);
            if (this.blacklist.contains(blockStateExplosion.func_177230_c()) || !blockStateExplosion.func_177230_c().isNormalCube(blockStateExplosion, (IBlockAccess)world, blockPosExplosion)) continue;
            int ticksBeforeHeal = ForgeCreeperHeal.getConfig().getMinimumTicksBeforeHeal() + world.field_73012_v.nextInt(ForgeCreeperHeal.getConfig().getRandomTickVar());
            if (ticksBeforeHeal > maxTicksBeforeHeal) {
                maxTicksBeforeHeal = ticksBeforeHeal;
            }
            if (this.logspam) {
                ForgeCreeperHeal.getLogger().log(Level.INFO, "cube:" + blockStateExplosion.func_177230_c().func_149739_a());
            }
            this.onBlockHealed(blockPosExplosion, blockStateExplosion, ticksBeforeHeal);
        }
        ++maxTicksBeforeHeal;
        for (BlockPos blockPosExplosion : event.getAffectedBlocks()) {
            blockStateExplosion = world.func_180495_p(blockPosExplosion);
            if (this.blacklist.contains(blockStateExplosion.func_177230_c()) || blockStateExplosion.func_177230_c().isNormalCube(blockStateExplosion, (IBlockAccess)world, blockPosExplosion)) continue;
            if (this.logspam) {
                ForgeCreeperHeal.getLogger().log(Level.INFO, "noncube:" + blockStateExplosion.func_177230_c().func_149739_a());
            }
            this.onBlockHealed(blockPosExplosion, blockStateExplosion, maxTicksBeforeHeal + world.field_73012_v.nextInt(ForgeCreeperHeal.getConfig().getRandomTickVar()));
        }
        if (this.profiler != null) {
            this.profiler.explosionStop();
        }
    }

    private void onBlockHealed(BlockPos blockPosExplosion, IBlockState blockStateExplosion, int ticks) {
        this.healTask.add(ticks, new BlockData(this.world, blockPosExplosion, blockStateExplosion));
        this.world.func_175713_t(blockPosExplosion);
        this.world.func_180501_a(blockPosExplosion, Blocks.field_150350_a.func_176223_P(), 7);
    }

    private void heal(BlockData blockData) {
        EntityItem ei;
        boolean isAir = this.world.func_175623_d(blockData.getBlockPos());
        if (ForgeCreeperHeal.getConfig().isOverride() || isAir || ForgeCreeperHeal.getConfig().isOverrideFluid() && FluidRegistry.lookupFluidForBlock((Block)this.world.func_180495_p(blockData.getBlockPos()).func_177230_c()) != null) {
            TileEntity te;
            EntityItem ei2;
            if (ForgeCreeperHeal.getConfig().isDropIfAlreadyBlock() && !isAir && this.world.func_180495_p(blockData.getBlockPos()).func_177230_c() != null && (ei2 = WorldHealerUtils.getEntityItem(this.world, blockData.getBlockPos(), new ItemStack(this.world.func_180495_p(blockData.getBlockPos()).func_177230_c()), this.world.field_73012_v.nextFloat() * 0.8f + 0.1f, this.world.field_73012_v.nextFloat() * 0.8f + 0.1f, this.world.field_73012_v.nextFloat() * 0.8f + 0.1f, 0.05f)) != null) {
                this.world.func_72838_d((Entity)ei2);
                TileEntity te2 = this.world.func_175625_s(blockData.getBlockPos());
                if (te2 instanceof IInventory) {
                    WorldHealerUtils.dropInventory(this.world, blockData.getBlockPos(), (IInventory)te2);
                }
            }
            this.world.func_180501_a(blockData.getBlockPos(), blockData.getBlockState(), 7);
            if (blockData.getTileEntityTag() != null && (te = this.world.func_175625_s(blockData.getBlockPos())) != null) {
                te.func_145839_a(blockData.getTileEntityTag());
                this.world.func_175690_a(blockData.getBlockPos(), te);
            }
        } else if (ForgeCreeperHeal.getConfig().isDropIfAlreadyBlock() && blockData.getBlockState().func_177230_c() != null && (ei = WorldHealerUtils.getEntityItem(this.world, blockData.getBlockPos(), new ItemStack(blockData.getBlockState().func_177230_c()), this.world.field_73012_v.nextFloat() * 0.8f + 0.1f, this.world.field_73012_v.nextFloat() * 0.8f + 0.1f, this.world.field_73012_v.nextFloat() * 0.8f + 0.1f, 0.05f)) != null) {
            TileEntity te;
            this.world.func_72838_d((Entity)ei);
            if (blockData.getTileEntityTag() != null && (te = blockData.getBlockState().func_177230_c().createTileEntity(this.world, blockData.getBlockState())) instanceof IInventory) {
                te.func_145839_a(blockData.getTileEntityTag());
                WorldHealerUtils.dropInventory(this.world, blockData.getBlockPos(), (IInventory)te);
            }
        }
    }

    public void func_76184_a(NBTTagCompound tag) {
        NBTTagList tagList = (NBTTagList)tag.func_74781_a("healtasklist");
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tickContainerTag = tagList.func_150305_b(i);
            int ticksLeft = tickContainerTag.func_74762_e("ticks");
            LinkedList<BlockData> blockDataList = new LinkedList<BlockData>();
            NBTTagList blockDataListTag = (NBTTagList)tickContainerTag.func_74781_a("blockdatalist");
            for (int j = 0; j < blockDataListTag.func_74745_c(); ++j) {
                NBTTagCompound blockDataTag = blockDataListTag.func_150305_b(j);
                BlockData blockData = new BlockData();
                blockData.readFromNBT(blockDataTag);
                blockDataList.add(blockData);
            }
            this.healTask.getLinkedList().addLast(new TickContainer(ticksLeft, blockDataList));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (TickContainer tickContainer : this.healTask.getLinkedList()) {
            NBTTagCompound tickContainerTag = new NBTTagCompound();
            tickContainerTag.func_74768_a("ticks", tickContainer.getTick());
            NBTTagList blockDataListTag = new NBTTagList();
            for (BlockData blockData : (Collection)tickContainer.getData()) {
                NBTTagCompound blockDataTag = new NBTTagCompound();
                blockData.writeToNBT(blockDataTag);
                blockDataListTag.func_74742_a((NBTBase)blockDataTag);
            }
            tickContainerTag.func_74782_a("blockdatalist", (NBTBase)blockDataListTag);
            tagList.func_74742_a((NBTBase)tickContainerTag);
        }
        tag.func_74782_a("healtasklist", (NBTBase)tagList);
        return tag;
    }

    public static WorldHealer loadWorldHealer(World w) {
        String KEY;
        MapStorage storage = w.getPerWorldStorage();
        WorldHealer result = (WorldHealer)storage.func_75742_a(WorldHealer.class, KEY = WorldHealer.getDataStorageKey());
        if (result == null) {
            result = new WorldHealer(KEY);
            storage.func_75745_a(KEY, (WorldSavedData)result);
            ForgeCreeperHeal.getLogger().info("Unable to find data for world " + w.func_72912_H().func_76065_j() + "[" + w.field_73011_w.getDimension() + "], new data created");
        }
        result.world = w;
        return result;
    }

    public static String getDataStorageKey() {
        return "forgecreeperheal:" + WorldHealer.class.getSimpleName();
    }

    public boolean func_76188_b() {
        return true;
    }

    public void enableProfiler(ICommandSender sender) {
        if (this.profiler == null) {
            this.profiler = new Profiler(this);
        }
        this.profiler.addListener(sender);
    }

    public void disableProfiler(ICommandSender sender) {
        if (this.profiler != null) {
            this.profiler.removeListener(sender);
        }
    }

    public void disableProfiler() {
        this.profiler = null;
    }

    public boolean isProfilerEnabled() {
        return this.profiler != null;
    }

    public Profiler getProfiler() {
        return this.profiler;
    }
}

