/*
 * Decompiled with CFR 0.152.
 */
package fr.eyzox.forgecreeperheal.worldhealer;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BlockData {
    private IBlockState blockState;
    private NBTTagCompound tileEntityTag;
    private BlockPos blockPos;

    public BlockData(World world, BlockPos chunkPosition, IBlockState blockState) {
        this.blockState = blockState;
        this.blockPos = chunkPosition;
        TileEntity te = world.func_175625_s(chunkPosition);
        if (te != null) {
            this.tileEntityTag = new NBTTagCompound();
            te.func_189515_b(this.tileEntityTag);
        }
    }

    public BlockData() {
    }

    public IBlockState getBlockState() {
        return this.blockState;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public NBTTagCompound getTileEntityTag() {
        return this.tileEntityTag;
    }

    public void readFromNBT(NBTTagCompound tag) {
        Block block = Block.func_149684_b((String)tag.func_74779_i("block"));
        if (block != null) {
            this.blockState = block.func_176203_a(tag.func_74762_e("metadata"));
            this.blockPos = BlockPos.func_177969_a((long)tag.func_74763_f("coords"));
            this.tileEntityTag = tag.func_74775_l("tileentity");
            if (this.tileEntityTag.func_82582_d()) {
                this.tileEntityTag = null;
            }
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("block", GameData.getBlockRegistry().getNameForObject((IForgeRegistryEntry)this.blockState.func_177230_c()).toString());
        int metadata = this.blockState.func_177230_c().func_176201_c(this.blockState);
        if (metadata != 0) {
            tag.func_74768_a("metadata", metadata);
        }
        tag.func_74772_a("coords", this.blockPos.func_177986_g());
        if (this.tileEntityTag != null) {
            tag.func_74782_a("tileentity", (NBTBase)this.tileEntityTag);
        }
    }

    public void setBlockState(IBlockState blockState) {
        this.blockState = blockState;
    }

    public void setTileEntityTag(NBTTagCompound tileEntityTag) {
        this.tileEntityTag = tileEntityTag;
    }

    public void setBlockPos(BlockPos blockPos) {
        this.blockPos = blockPos;
    }
}

