/*
 * Decompiled with CFR 0.152.
 */
package fr.eyzox.forgecreeperheal;

import fr.eyzox.forgecreeperheal.ForgeCreeperHeal;
import fr.eyzox.forgecreeperheal.network.ProfilerInfoMessage;
import fr.eyzox.forgecreeperheal.proxy.CommonProxy;
import fr.eyzox.forgecreeperheal.worldhealer.BlockData;
import fr.eyzox.forgecreeperheal.worldhealer.WorldHealer;
import fr.eyzox.ticklinkedlist.TickContainer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Profiler {
    private Set<EntityPlayerMP> clientSideModListeners = new HashSet<EntityPlayerMP>();
    private Set<EntityPlayerMP> noClientSideModListeners = new HashSet<EntityPlayerMP>();
    private boolean serverWatch;
    private WorldHealer worldHealer;
    private int totalTicks;
    private int currentTick;
    private long tickStart;
    private long explosionStart;
    private double avgTick;
    private double avgExplosion;
    private long blocksUsed;

    public Profiler(WorldHealer worldHealer) {
        this(worldHealer, 20);
    }

    public Profiler(WorldHealer worldHealer, int totalTicks) {
        this.totalTicks = totalTicks;
        this.worldHealer = worldHealer;
    }

    public void begin() {
        if (this.currentTick >= this.totalTicks) {
            this.currentTick = 0;
            this.avgTick = 0.0;
            this.avgExplosion = 0.0;
        } else {
            ++this.currentTick;
        }
    }

    public void tickStart() {
        this.tickStart = System.currentTimeMillis();
    }

    public void tickStop() {
        long tickStop = System.currentTimeMillis();
        this.avgTick = this.currentTick == 0 ? (double)(tickStop - this.tickStart) : (this.avgTick + (double)(tickStop - this.tickStart)) / 2.0;
    }

    public void explosionStart() {
        this.explosionStart = System.currentTimeMillis();
    }

    public void explosionStop() {
        long explosionStop = System.currentTimeMillis();
        this.avgExplosion = this.avgExplosion == 0.0 ? (double)(explosionStop - this.explosionStart) : (this.avgExplosion + (double)(explosionStop - this.explosionStart)) / 2.0;
    }

    public void handleMemoryUse(LinkedList<TickContainer<Collection<BlockData>>> data) {
        if (this.currentTick < this.totalTicks) {
            return;
        }
        this.blocksUsed = 0L;
        Iterator<TickContainer<Collection<BlockData>>> it = data.descendingIterator();
        TickContainer<Collection<BlockData>> cursor = null;
        while (it.hasNext()) {
            cursor = it.next();
            this.blocksUsed += (long)cursor.getData().size();
        }
    }

    public void addListener(ICommandSender sender) {
        if (sender instanceof EntityPlayerMP) {
            this.clientSideModListeners.add((EntityPlayerMP)sender);
        } else {
            this.serverWatch = true;
        }
    }

    public void removeListener(ICommandSender sender) {
        if (sender instanceof EntityPlayerMP) {
            this.clientSideModListeners.remove(sender);
            this.noClientSideModListeners.remove(sender);
        } else {
            this.serverWatch = false;
        }
        if (this.getNbListeners() <= 0) {
            this.worldHealer.disableProfiler();
        }
    }

    public int getNbListeners() {
        return (this.serverWatch ? 1 : 0) + this.clientSideModListeners.size() + this.noClientSideModListeners.size();
    }

    public void report() {
        if (this.currentTick < this.totalTicks) {
            return;
        }
        double totalTicks = this.avgTick + this.avgExplosion;
        if (this.serverWatch) {
            ForgeCreeperHeal.getLogger().info(String.format("[PROFILER:%s#%d] Tick : %.4f ms, Memory usage : %d blocks", this.worldHealer.getWorld().func_72912_H().func_76065_j(), this.worldHealer.getWorld().field_73011_w.getDimension(), totalTicks, this.blocksUsed));
        }
        for (EntityPlayerMP player : this.clientSideModListeners) {
            if (player.func_184102_h().func_184103_al().func_177451_a(player.getPersistentID()) != null) {
                ForgeCreeperHeal.getChannel().sendTo((IMessage)new ProfilerInfoMessage(this.worldHealer.getWorld(), totalTicks, this.blocksUsed), player);
                continue;
            }
            this.worldHealer.disableProfiler((ICommandSender)player);
        }
        for (EntityPlayerMP player : this.noClientSideModListeners) {
            if (player.func_184102_h().func_184103_al().func_177451_a(player.getPersistentID()) != null) {
                CommonProxy.addChatMessage((ICommandSender)player, new TextComponentTranslation(String.format("[ForgeCreeperHeal][%s#%d] Tick : %.4f ms, Memory usage : %d blocks", this.worldHealer.getWorld().func_72912_H().func_76065_j(), this.worldHealer.getWorld().field_73011_w.getDimension(), totalTicks, this.blocksUsed), new Object[0]));
                continue;
            }
            this.worldHealer.disableProfiler((ICommandSender)player);
        }
    }
}

