/*
 * Decompiled with CFR 0.152.
 */
package fr.eyzox.forgecreeperheal.worldhealer;

import com.example.examplemod.ForgeCreeperHeal;
import fr.eyzox.forgecreeperheal.worldhealer.BlockData;
import fr.eyzox.forgecreeperheal.worldhealer.TickContainer;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;
import net.minecraftforge.fluids.FluidRegistry;

public class WorldHealer
extends WorldSavedData {
    private Random rdn = new Random();
    private World world;
    private LinkedList<TickContainer> toHeal = new LinkedList();

    public WorldHealer() {
        this(WorldHealer.getDataStorageKey());
    }

    public WorldHealer(String key) {
        super(key);
    }

    public void add(BlockData blockData, int ticks) {
        if (this.toHeal.isEmpty()) {
            this.toHeal.add(new TickContainer(ticks, blockData));
        } else {
            ListIterator<TickContainer> it = this.toHeal.listIterator();
            while (it.hasNext()) {
                TickContainer current = (TickContainer)it.next();
                if (current.getTicksLeft() < ticks) {
                    ticks -= current.getTicksLeft();
                    continue;
                }
                if (current.getTicksLeft() == ticks) {
                    current.getBlockDataList().add(blockData);
                    return;
                }
                it.set(new TickContainer(ticks, blockData));
                current.setTicksLeft(current.getTicksLeft() - ticks);
                it.add(current);
                return;
            }
            this.toHeal.add(new TickContainer(ticks, blockData));
        }
    }

    public void onTick() {
        if (!this.toHeal.isEmpty()) {
            TickContainer tc = this.toHeal.getFirst();
            if (tc.getTicksLeft() <= 1) {
                this.toHeal.removeFirst();
                for (BlockData blockData : tc.getBlockDataList()) {
                    this.heal(blockData);
                }
            } else {
                tc.setTicksLeft(tc.getTicksLeft() - 1);
            }
        }
    }

    private void heal(BlockData blockData) {
        boolean isAir = this.world.func_147437_c(blockData.getChunkPosition().field_151329_a, blockData.getChunkPosition().field_151327_b, blockData.getChunkPosition().field_151328_c);
        if (ForgeCreeperHeal.getConfig().isOverride() || isAir || ForgeCreeperHeal.getConfig().isOverrideFluid() && FluidRegistry.lookupFluidForBlock((Block)this.world.func_147439_a(blockData.getChunkPosition().field_151329_a, blockData.getChunkPosition().field_151327_b, blockData.getChunkPosition().field_151328_c)) != null) {
            TileEntity te;
            if (ForgeCreeperHeal.getConfig().isDropIfAlreadyBlock() && !isAir) {
                this.world.func_72838_d((Entity)this.buildEntityItem(blockData.getChunkPosition(), new ItemStack(this.world.func_147439_a(blockData.getChunkPosition().field_151329_a, blockData.getChunkPosition().field_151327_b, blockData.getChunkPosition().field_151328_c)), this.rdn.nextFloat() * 0.8f + 0.1f, this.rdn.nextFloat() * 0.8f + 0.1f, this.rdn.nextFloat() * 0.8f + 0.1f, 0.05f));
                te = this.world.func_147438_o(blockData.getChunkPosition().field_151329_a, blockData.getChunkPosition().field_151327_b, blockData.getChunkPosition().field_151328_c);
                if (te instanceof IInventory) {
                    this.dropInventory((IInventory)te, blockData.getChunkPosition());
                }
            }
            this.world.func_147465_d(blockData.getChunkPosition().field_151329_a, blockData.getChunkPosition().field_151327_b, blockData.getChunkPosition().field_151328_c, blockData.getBlock(), blockData.getMetadata(), 7);
            this.world.func_72921_c(blockData.getChunkPosition().field_151329_a, blockData.getChunkPosition().field_151327_b, blockData.getChunkPosition().field_151328_c, blockData.getMetadata(), 7);
            if (blockData.getTileEntityTag() != null && (te = this.world.func_147438_o(blockData.getChunkPosition().field_151329_a, blockData.getChunkPosition().field_151327_b, blockData.getChunkPosition().field_151328_c)) != null) {
                te.func_145839_a(blockData.getTileEntityTag());
                this.world.func_147455_a(blockData.getChunkPosition().field_151329_a, blockData.getChunkPosition().field_151327_b, blockData.getChunkPosition().field_151328_c, te);
            }
        } else if (ForgeCreeperHeal.getConfig().isDropIfAlreadyBlock()) {
            TileEntity te;
            this.world.func_72838_d((Entity)this.buildEntityItem(blockData.getChunkPosition(), new ItemStack(blockData.getBlock()), this.rdn.nextFloat() * 0.8f + 0.1f, this.rdn.nextFloat() * 0.8f + 0.1f, this.rdn.nextFloat() * 0.8f + 0.1f, 0.05f));
            if (blockData.getTileEntityTag() != null && (te = blockData.getBlock().createTileEntity(this.world, blockData.getMetadata())) instanceof IInventory) {
                te.func_145839_a(blockData.getTileEntityTag());
                this.dropInventory((IInventory)te, blockData.getChunkPosition());
            }
        }
    }

    private EntityItem buildEntityItem(ChunkPosition cp, ItemStack itemStack, float deltaX, float deltaY, float deltaZ, float motion) {
        EntityItem entityitem = new EntityItem(this.world, (double)((float)cp.field_151329_a + deltaX), (double)((float)cp.field_151327_b + deltaY), (double)((float)cp.field_151328_c + deltaZ), itemStack);
        entityitem.field_70159_w = (float)this.rdn.nextGaussian() * motion;
        entityitem.field_70181_x = (float)this.rdn.nextGaussian() * motion + 0.2f;
        entityitem.field_70179_y = (float)this.rdn.nextGaussian() * motion;
        return entityitem;
    }

    public void dropInventory(IInventory inventory, ChunkPosition cp) {
        for (int inventoryIndex = 0; inventoryIndex < inventory.func_70302_i_(); ++inventoryIndex) {
            ItemStack itemstack = inventory.func_70301_a(inventoryIndex);
            if (itemstack == null) continue;
            float f = this.rdn.nextFloat() * 0.8f + 0.1f;
            float f1 = this.rdn.nextFloat() * 0.8f + 0.1f;
            float f2 = this.rdn.nextFloat() * 0.8f + 0.1f;
            while (itemstack.field_77994_a > 0) {
                int j1 = this.rdn.nextInt(21) + 10;
                if (j1 > itemstack.field_77994_a) {
                    j1 = itemstack.field_77994_a;
                }
                itemstack.field_77994_a -= j1;
                float f3 = 0.05f;
                EntityItem entityitem = this.buildEntityItem(cp, new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()), f, f1, f2, f3);
                if (itemstack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                }
                this.world.func_72838_d((Entity)entityitem);
            }
            inventory.func_70299_a(inventoryIndex, null);
        }
    }

    public World getWorld() {
        return this.world;
    }

    public void func_76184_a(NBTTagCompound tag) {
        NBTTagList tagList = (NBTTagList)tag.func_74781_a("toHeal");
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tickContainerTag = tagList.func_150305_b(i);
            int ticksLeft = tickContainerTag.func_74762_e("ticks");
            LinkedList<BlockData> blockDataList = new LinkedList<BlockData>();
            NBTTagList blockDataListTag = (NBTTagList)tickContainerTag.func_74781_a("blockdatalist");
            for (int j = 0; j < blockDataListTag.func_74745_c(); ++j) {
                NBTTagCompound blockDataTag = blockDataListTag.func_150305_b(j);
                BlockData blockData = new BlockData();
                blockData.readFromNBT(blockDataTag);
                blockDataList.add(blockData);
            }
            this.toHeal.add(new TickContainer(ticksLeft, blockDataList));
        }
    }

    public void func_76187_b(NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (TickContainer tc : this.toHeal) {
            NBTTagCompound tickContainerTag = new NBTTagCompound();
            tickContainerTag.func_74768_a("ticks", tc.getTicksLeft());
            NBTTagList blockDataListTag = new NBTTagList();
            for (BlockData blockData : tc.getBlockDataList()) {
                NBTTagCompound blockDataTag = new NBTTagCompound();
                blockData.writeToNBT(blockDataTag);
                blockDataListTag.func_74742_a((NBTBase)blockDataTag);
            }
            tickContainerTag.func_74782_a("blockdatalist", (NBTBase)blockDataListTag);
            tagList.func_74742_a((NBTBase)tickContainerTag);
        }
        tag.func_74782_a("toHeal", (NBTBase)tagList);
    }

    public static WorldHealer loadWorldHealer(World w) {
        MapStorage storage = w.perWorldStorage;
        String KEY = WorldHealer.getDataStorageKey();
        WorldHealer result = (WorldHealer)storage.func_75742_a(WorldHealer.class, KEY);
        if (result == null) {
            result = new WorldHealer(KEY);
            storage.func_75745_a(KEY, (WorldSavedData)result);
            ForgeCreeperHeal.getLogger().info("Unable to find data for world " + w.func_72912_H().func_76065_j() + "[" + w.field_73011_w.field_76574_g + "], new data created");
        }
        result.world = w;
        return result;
    }

    public static String getDataStorageKey() {
        return "forgecreeperheal:" + WorldHealer.class.getSimpleName();
    }

    public boolean func_76188_b() {
        return true;
    }
}

