/*
 * Decompiled with CFR 0.152.
 */
package fr.eyzox.forgecreeperheal.handler;

import com.example.examplemod.ForgeCreeperHeal;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import fr.eyzox.forgecreeperheal.worldhealer.BlockData;
import fr.eyzox.forgecreeperheal.worldhealer.WorldHealer;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.ExplosionEvent;

public class ExplosionEventHandler {
    private Random rdn = new Random();

    @SubscribeEvent
    public void onDetonate(ExplosionEvent.Detonate event) {
        WorldHealer worldHealer;
        if (!event.world.field_72995_K && !ForgeCreeperHeal.getConfig().getFromEntityException().contains(event.explosion.field_77283_e.getClass()) && (worldHealer = ForgeCreeperHeal.getWorldHealer((WorldServer)event.world)) != null) {
            Block block;
            int maxTicksBeforeHeal = 0;
            for (ChunkPosition c : event.getAffectedBlocks()) {
                block = event.world.func_147439_a(c.field_151329_a, c.field_151327_b, c.field_151328_c);
                if (!block.func_149721_r()) continue;
                int ticksBeforeHeal = ForgeCreeperHeal.getConfig().getMinimumTicksBeforeHeal() + this.rdn.nextInt(ForgeCreeperHeal.getConfig().getRandomTickVar());
                if (ticksBeforeHeal > maxTicksBeforeHeal) {
                    maxTicksBeforeHeal = ticksBeforeHeal;
                }
                this.processBlock(worldHealer, event.world, c, block, ticksBeforeHeal);
            }
            ++maxTicksBeforeHeal;
            for (ChunkPosition c : event.getAffectedBlocks()) {
                block = event.world.func_147439_a(c.field_151329_a, c.field_151327_b, c.field_151328_c);
                if (block.func_149721_r() || block.isAir((IBlockAccess)event.world, c.field_151329_a, c.field_151327_b, c.field_151328_c)) continue;
                this.processBlock(worldHealer, event.world, c, block, maxTicksBeforeHeal + this.rdn.nextInt(ForgeCreeperHeal.getConfig().getRandomTickVar()));
            }
        }
    }

    private void processBlock(WorldHealer worldHealer, World world, ChunkPosition c, Block block, int ticks) {
        TileEntity te;
        if (ForgeCreeperHeal.getConfig().isDropItemsFromContainer() && !ForgeCreeperHeal.getConfig().getRemoveException().contains(block) && (te = world.func_147438_o(c.field_151329_a, c.field_151327_b, c.field_151328_c)) instanceof IInventory) {
            worldHealer.dropInventory((IInventory)te, c);
        }
        if (!ForgeCreeperHeal.getConfig().getHealException().contains(block)) {
            worldHealer.add(new BlockData(world, c), ticks);
        }
        if (!ForgeCreeperHeal.getConfig().getRemoveException().contains(block)) {
            world.func_147475_p(c.field_151329_a, c.field_151327_b, c.field_151328_c);
            world.func_147465_d(c.field_151329_a, c.field_151327_b, c.field_151328_c, Blocks.field_150350_a, 0, 7);
        }
    }
}

