/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.Config;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import fr.eyzox.forgecreeperheal.handler.ExplosionEventHandler;
import fr.eyzox.forgecreeperheal.handler.WorldEventHandler;
import fr.eyzox.forgecreeperheal.handler.WorldTickEventHandler;
import fr.eyzox.forgecreeperheal.worldhealer.WorldHealer;
import java.util.logging.Logger;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="forgecreeperheal", name="Forge Creeper Heal 1.0.0", version="1.0.0", acceptableRemoteVersions="*")
public class ForgeCreeperHeal {
    public static final String MODID = "forgecreeperheal";
    public static final String VERSION = "1.0.0";
    public static final String MODNAME = "Forge Creeper Heal 1.0.0";
    @Mod.Instance(value="forgecreeperheal")
    public static ForgeCreeperHeal instance;
    private static Logger logger;
    private Config config;
    private WorldEventHandler worldEventHandler;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        this.config = Config.loadConfig(event.getSuggestedConfigurationFile());
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        this.worldEventHandler = new WorldEventHandler();
        FMLCommonHandler.instance().bus().register((Object)new WorldTickEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)this.worldEventHandler);
        MinecraftForge.EVENT_BUS.register((Object)new ExplosionEventHandler());
    }

    public static ForgeCreeperHeal getInstance() {
        return instance;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static WorldHealer getWorldHealer(WorldServer w) {
        return ForgeCreeperHeal.instance.worldEventHandler.getWorldHealers().get(w);
    }

    public static Config getConfig() {
        return ForgeCreeperHeal.instance.config;
    }

    static {
        logger = Logger.getLogger(MODID);
    }
}

