/*
 * Decompiled with CFR 0.152.
 */
package fr.eyzox.forgecreeperheal.proxy;

import fr.eyzox.forgecreeperheal.Config;
import fr.eyzox.forgecreeperheal.commands.ForgeCreeperHealCommands;
import fr.eyzox.forgecreeperheal.commands.config.ConfigCommands;
import fr.eyzox.forgecreeperheal.commands.config.ReloadConfigCommand;
import fr.eyzox.forgecreeperheal.commands.profiler.ProfilerCommand;
import fr.eyzox.forgecreeperheal.handler.ExplosionEventHandler;
import fr.eyzox.forgecreeperheal.handler.WorldEventHandler;
import fr.eyzox.forgecreeperheal.handler.WorldTickEventHandler;
import fr.eyzox.forgecreeperheal.network.ModDataMessage;
import fr.eyzox.forgecreeperheal.network.ProfilerInfoMessage;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

public class CommonProxy {
    private Logger logger;
    private Config config;
    private WorldEventHandler worldEventHandler;
    private SimpleNetworkWrapper channel;

    public void onPreInit(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        this.config = Config.loadConfig(event.getSuggestedConfigurationFile());
    }

    public void onInit(FMLInitializationEvent event) {
        this.worldEventHandler = new WorldEventHandler();
        FMLCommonHandler.instance().bus().register((Object)new WorldTickEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)this.worldEventHandler);
        MinecraftForge.EVENT_BUS.register((Object)new ExplosionEventHandler());
        this.channel = NetworkRegistry.INSTANCE.newSimpleChannel("forgecreeperheal:ch0");
        this.channel.registerMessage(ModDataMessage.Handler.class, ModDataMessage.class, 0, Side.SERVER);
        this.channel.registerMessage(ProfilerInfoMessage.Handler.class, ProfilerInfoMessage.class, 1, Side.CLIENT);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        this.registerCommand();
    }

    protected void registerCommand() {
        ServerCommandManager m = (ServerCommandManager)MinecraftServer.func_71276_C().func_71187_D();
        ForgeCreeperHealCommands forgeCreeperHealCmds = new ForgeCreeperHealCommands();
        ConfigCommands configCmds = new ConfigCommands();
        configCmds.register(new ReloadConfigCommand());
        forgeCreeperHealCmds.register(configCmds);
        forgeCreeperHealCmds.register(new ProfilerCommand());
        m.func_71560_a((ICommand)forgeCreeperHealCmds);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Config getConfig() {
        return this.config;
    }

    public WorldEventHandler getWorldEventHandler() {
        return this.worldEventHandler;
    }

    public SimpleNetworkWrapper getChannel() {
        return this.channel;
    }

    public void setConfig(Config config) {
        this.config = config;
    }
}

