/*
 * Decompiled with CFR 0.152.
 */
package fr.eyzox.forgecreeperheal;

import fr.eyzox.forgecreeperheal.ForgeCreeperHeal;
import fr.eyzox.forgecreeperheal.PlayerModData;
import fr.eyzox.forgecreeperheal.commands.ForgeCreeperHealCommands;
import fr.eyzox.forgecreeperheal.network.ProfilerInfoMessage;
import fr.eyzox.forgecreeperheal.worldhealer.BlockData;
import fr.eyzox.forgecreeperheal.worldhealer.WorldHealer;
import fr.eyzox.ticklinkedlist.TickContainer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Profiler {
    private Set<EntityPlayerMP> clientSideModListeners = new HashSet<EntityPlayerMP>();
    private Set<EntityPlayerMP> noClientSideModListeners = new HashSet<EntityPlayerMP>();
    private boolean serverWatch;
    private WorldHealer worldHealer;
    private int totalTicks;
    private int currentTick;
    private long tickStart;
    private long explosionStart;
    private double avgTick;
    private double avgExplosion;
    private long blocksUsed;

    public Profiler(WorldHealer worldHealer) {
        this(worldHealer, 20);
    }

    public Profiler(WorldHealer worldHealer, int totalTicks) {
        this.totalTicks = totalTicks;
        this.worldHealer = worldHealer;
    }

    public void begin() {
        if (this.currentTick >= this.totalTicks) {
            this.currentTick = 0;
            this.avgTick = 0.0;
            this.avgExplosion = 0.0;
        } else {
            ++this.currentTick;
        }
    }

    public void tickStart() {
        this.tickStart = System.currentTimeMillis();
    }

    public void tickStop() {
        long tickStop = System.currentTimeMillis();
        this.avgTick = this.currentTick == 0 ? (double)(tickStop - this.tickStart) : (this.avgTick + (double)(tickStop - this.tickStart)) / 2.0;
    }

    public void explosionStart() {
        this.explosionStart = System.currentTimeMillis();
    }

    public void explosionStop() {
        long explosionStop = System.currentTimeMillis();
        this.avgExplosion = this.avgExplosion == 0.0 ? (double)(explosionStop - this.explosionStart) : (this.avgExplosion + (double)(explosionStop - this.explosionStart)) / 2.0;
    }

    public void handleMemoryUse(LinkedList<TickContainer<Collection<BlockData>>> data) {
        if (this.currentTick < this.totalTicks) {
            return;
        }
        this.blocksUsed = 0L;
        Iterator<TickContainer<Collection<BlockData>>> it = data.descendingIterator();
        TickContainer<Collection<BlockData>> cursor = null;
        while (it.hasNext()) {
            cursor = it.next();
            this.blocksUsed += (long)cursor.getData().size();
        }
    }

    public void addListener(ICommandSender sender) {
        if (sender instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)sender;
            PlayerModData playerModData = PlayerModData.get((EntityPlayer)player);
            if (playerModData != null && playerModData.MOD_VERSION.compareToIgnoreCase("1.1.0") >= 0) {
                this.clientSideModListeners.add(player);
            } else {
                this.noClientSideModListeners.add(player);
            }
        } else {
            this.serverWatch = true;
        }
    }

    public void removeListener(ICommandSender sender) {
        if (sender instanceof EntityPlayerMP) {
            this.clientSideModListeners.remove(sender);
            this.noClientSideModListeners.remove(sender);
        } else {
            this.serverWatch = false;
        }
        if (this.getNbListeners() <= 0) {
            this.worldHealer.disableProfiler();
        }
    }

    public int getNbListeners() {
        return (this.serverWatch ? 1 : 0) + this.clientSideModListeners.size() + this.noClientSideModListeners.size();
    }

    public void report() {
        if (this.currentTick < this.totalTicks) {
            return;
        }
        double totalTicks = this.avgTick + this.avgExplosion;
        if (this.serverWatch) {
            ForgeCreeperHeal.getLogger().info(String.format("[PROFILER:%s#%d] Tick : %.4f ms, Memory usage : %d blocks", this.worldHealer.getWorld().func_72912_H().func_76065_j(), this.worldHealer.getWorld().field_73011_w.func_177502_q(), totalTicks, this.blocksUsed));
        }
        for (EntityPlayerMP player : this.clientSideModListeners) {
            if (MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.contains(player)) {
                ForgeCreeperHeal.getChannel().sendTo((IMessage)new ProfilerInfoMessage(this.worldHealer.getWorld(), totalTicks, this.blocksUsed), player);
                continue;
            }
            this.worldHealer.disableProfiler((ICommandSender)player);
        }
        for (EntityPlayerMP player : this.noClientSideModListeners) {
            if (MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.contains(player)) {
                ForgeCreeperHealCommands.addChatMessage((ICommandSender)player, (IChatComponent)new ChatComponentText(String.format("[%s#%d] Tick : %.4f ms, Memory usage : %d blocks", this.worldHealer.getWorld().func_72912_H().func_76065_j(), this.worldHealer.getWorld().field_73011_w.func_177502_q(), totalTicks, this.blocksUsed)));
                continue;
            }
            this.worldHealer.disableProfiler((ICommandSender)player);
        }
    }
}

