/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.mlmg.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import party.lemons.mlmg.blocks.ModBlocks;
import party.lemons.mlmg.config.ModConfig;
import party.lemons.mlmg.crafting.GrinderTab;

public class BlockSpike
extends Block {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    private static final double SIZE_OFFSET = 0.025;
    private static AxisAlignedBB[] DIRECTION_AABBS = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.025, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.975, 1.0), new AxisAlignedBB(0.0, 0.0, 0.025, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.975), new AxisAlignedBB(0.025, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.975, 1.0, 1.0)};

    public BlockSpike(Material material, String name) {
        super(material);
        this.func_149663_c("mylittlemobgrinder." + name);
        this.setRegistryName(name);
        this.func_149647_a(GrinderTab.TAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(2.0f);
        this.func_149752_b(0.25f);
        this.func_149672_a(SoundType.field_185858_k);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return DIRECTION_AABBS[((EnumFacing)blockState.func_177229_b((IProperty)FACING)).ordinal()];
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.setDefaultDirection(worldIn, pos, state);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (entityIn instanceof EntityItem && !this.destroysItems()) {
            return;
        }
        if (entityIn instanceof EntityXPOrb) {
            return;
        }
        entityIn.func_70097_a((DamageSource)new DamageSourceSpike(this), (float)this.getDamage());
    }

    public boolean destroysItems() {
        if (this == ModBlocks.IRON_SPIKES) {
            return ModConfig.GameplayConfig.ironSpikesDestroyItems;
        }
        if (this == ModBlocks.DIAMOND_SPIKE) {
            return ModConfig.GameplayConfig.diamondSpikesDestroyItems;
        }
        return false;
    }

    public double getDamage() {
        if (this == ModBlocks.IRON_SPIKES) {
            return ModConfig.GameplayConfig.damageIronSpike;
        }
        if (this == ModBlocks.DIAMOND_SPIKE) {
            return ModConfig.GameplayConfig.damageDiamondSpike;
        }
        return 0.0;
    }

    public boolean dropsXP() {
        if (this == ModBlocks.IRON_SPIKES) {
            return ModConfig.GameplayConfig.ironSpikesDropXP;
        }
        if (this == ModBlocks.DIAMOND_SPIKE) {
            return ModConfig.GameplayConfig.diamondSpikesDropXP;
        }
        return false;
    }

    private void setDefaultDirection(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            boolean flag = worldIn.func_180495_p(pos.func_177978_c()).func_185913_b();
            boolean flag1 = worldIn.func_180495_p(pos.func_177968_d()).func_185913_b();
            if (enumfacing == EnumFacing.NORTH && flag && !flag1) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && flag1 && !flag) {
                enumfacing = EnumFacing.NORTH;
            } else {
                boolean flag2 = worldIn.func_180495_p(pos.func_177976_e()).func_185913_b();
                boolean flag3 = worldIn.func_180495_p(pos.func_177974_f()).func_185913_b();
                if (enumfacing == EnumFacing.WEST && flag2 && !flag3) {
                    enumfacing = EnumFacing.EAST;
                } else if (enumfacing == EnumFacing.EAST && flag3 && !flag2) {
                    enumfacing = EnumFacing.WEST;
                }
            }
            worldIn.func_175656_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing));
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        return i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        String desItems = "" + TextFormatting.BLUE;
        desItems = this.destroysItems() ? desItems + I18n.func_135052_a((String)"tile.mylittlemobgrinder.spike.destroyitems", (Object[])new Object[0]) : desItems + I18n.func_135052_a((String)"tile.mylittlemobgrinder.spike.dropitems", (Object[])new Object[0]);
        tooltip.add(desItems);
        if (this.dropsXP()) {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"tile.mylittlemobgrinder.spike.dropxp", (Object[])new Object[0]));
        }
        tooltip.add(I18n.func_135052_a((String)"tile.mylittlemobgrinder.spike.damage", (Object[])new Object[0]) + ": " + this.getDamage());
    }

    public static class DamageSourceSpike
    extends DamageSource {
        BlockSpike spike;

        public DamageSourceSpike(BlockSpike spike) {
            super("spike_damage");
            this.spike = spike;
        }

        public boolean dropXP() {
            return this.spike.dropsXP();
        }
    }
}

