/*
 * Decompiled with CFR 0.152.
 */
package de.intektor.grapple_hooks.entity;

import de.intektor.grapple_hooks.GrappleHooks;
import de.intektor.grapple_hooks.server.IGrappleCapability;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityGrapplingHook
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    public EntityPlayer field_70192_c;
    public boolean isReturning;
    public double grapplingDistance;
    public double grapplingStrength;
    public double radio;
    private float throwingStrength;
    protected Point3d startPoint;
    protected byte type;
    public static final int TYPE_WOODEN_HOOK = 0;
    public static final int TYPE_STONE_HOOK = 1;
    public static final int TYPE_IRON_HOOK = 2;
    public static final int TYPE_DIAMOND_HOOK = 3;
    public static final int TYPE_GOLDEN_HOOK = 4;
    public static final int TYPE_SPIDER_HOOK = 5;
    public static final int TYPE_CREATIVE_HOOK = 6;
    public static final int TYPE_IRIDIUM_GRAPPLE = 7;
    double maxY;
    int spinX = 1;
    private static final DataParameter<Float> dataX = EntityDataManager.func_187226_a(EntityGrapplingHook.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> dataY = EntityDataManager.func_187226_a(EntityGrapplingHook.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> dataZ = EntityDataManager.func_187226_a(EntityGrapplingHook.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> pullThrower = EntityDataManager.func_187226_a(EntityGrapplingHook.class, (DataSerializer)DataSerializers.field_187198_h);
    boolean canBeCollided = true;

    public EntityGrapplingHook(World worldIn, EntityPlayer thrower, double grapplingDistance, double grapplingStrength, byte type, float throwingStrength) {
        super(worldIn, (EntityLivingBase)thrower);
        this.field_70192_c = thrower;
        this.grapplingDistance = grapplingDistance;
        this.grapplingStrength = grapplingStrength;
        this.type = type;
        this.throwingStrength = throwingStrength;
        this.func_184538_a((Entity)thrower, thrower.field_70125_A, thrower.field_70177_z, 0.0f, 1.5f, 1.0f);
        this.field_70159_w *= (double)throwingStrength;
        this.field_70181_x *= (double)throwingStrength;
        this.field_70179_y *= (double)throwingStrength;
    }

    public EntityGrapplingHook(World world) {
        super(world);
    }

    public void func_70071_h_() {
        Vector3d vec;
        Vec3d pVec;
        if (this.startPoint == null) {
            this.startPoint = new Point3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        Point3d point3d = new Point3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.startPoint.distance(point3d) > this.grapplingDistance) {
            this.setReturning();
        }
        if (this.isReturning && this.func_70032_d((Entity)this.field_70192_c) <= 2.0f) {
            IGrappleCapability cap;
            this.func_70076_C();
            if (this.field_70192_c.hasCapability(GrappleHooks.GRAPPLE_CAP, null) && (cap = (IGrappleCapability)this.field_70192_c.getCapability(GrappleHooks.GRAPPLE_CAP, null)).getHook() != null) {
                cap.setHook(null);
            }
        }
        if (!this.isReturning) {
            if (this.type != 5) {
                if (this.pullThrower() && this.field_70192_c != null) {
                    pVec = this.field_70192_c.func_174791_d().func_178786_a(0.0, (double)-1.3f, 0.0);
                    vec = new Vector3d(this.getPullPosX() - pVec.field_72450_a, this.getPullPosY() - pVec.field_72448_b, this.getPullPosZ() - pVec.field_72449_c);
                    vec.normalize();
                    double distance = this.func_174791_d().func_72438_d(pVec);
                    float f = distance > this.grapplingStrength ? (float)this.grapplingStrength : 0.5f;
                    this.field_70192_c.field_70159_w = vec.x * (double)f;
                    this.field_70192_c.field_70181_x = vec.y * (double)f;
                    this.field_70192_c.field_70179_y = vec.z * (double)f;
                    this.field_70192_c.field_70143_R = 0.0f;
                }
            } else if (!this.field_70128_L && this.pullThrower()) {
                // empty if block
            }
        } else {
            this.setPullPosX((float)this.field_70165_t);
            this.setPullPosY((float)this.field_70163_u);
            this.setPullPosZ((float)this.field_70161_v);
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            pVec = this.field_70192_c.func_174791_d().func_178786_a(0.0, (double)-1.3f, 0.0);
            vec = new Vector3d(this.getPullPosX() - pVec.field_72450_a, this.getPullPosY() - pVec.field_72448_b, this.getPullPosZ() - pVec.field_72449_c);
            vec.normalize();
            float f = 2.0f;
            this.field_70159_w = -vec.x * (double)f;
            this.field_70181_x = -vec.y * (double)f;
            this.field_70179_y = -vec.z * (double)f;
        }
        super.func_70071_h_();
        Vec3d vec3 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec31 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult movingobjectposition = this.field_70170_p.func_72933_a(vec3, vec31);
        vec3 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec31 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (!this.field_70170_p.field_72995_K) {
            EntityItem entity = null;
            List list = this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d0 = 0.0;
            if (movingobjectposition != null) {
                vec31 = new Vec3d(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
            }
            for (EntityItem entity1 : list) {
                double d1;
                float f = 0.3f;
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72314_b((double)f, (double)f, (double)f);
                RayTraceResult movingobjectposition1 = axisalignedbb.func_72327_a(vec3, vec31);
                if (movingobjectposition1 != null && ((d1 = vec3.func_72436_e(movingobjectposition1.field_72307_f)) < d0 || d0 == 0.0)) {
                    entity = entity1;
                    d0 = d1;
                }
                if (entity == null) continue;
                movingobjectposition = new RayTraceResult(entity);
            }
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(movingobjectposition.func_178782_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(movingobjectposition.func_178782_a());
            } else {
                this.func_70184_a(movingobjectposition);
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(dataX, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(dataY, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(dataZ, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(pullThrower, (Object)false);
    }

    public double getPullPosX() {
        return ((Float)this.field_70180_af.func_187225_a(dataX)).floatValue();
    }

    public double getPullPosY() {
        return ((Float)this.field_70180_af.func_187225_a(dataY)).floatValue();
    }

    public double getPullPosZ() {
        return ((Float)this.field_70180_af.func_187225_a(dataZ)).floatValue();
    }

    public void setPullPosX(float pos) {
        this.field_70180_af.func_187227_b(dataX, (Object)Float.valueOf(pos));
    }

    public void setPullPosY(float pos) {
        this.field_70180_af.func_187227_b(dataY, (Object)Float.valueOf(pos));
    }

    public void setPullPosZ(float pos) {
        this.field_70180_af.func_187227_b(dataZ, (Object)Float.valueOf(pos));
    }

    public boolean pullThrower() {
        return (Boolean)this.field_70180_af.func_187225_a(pullThrower);
    }

    public void setPullThrower(boolean flag) {
        this.field_70180_af.func_187227_b(pullThrower, (Object)flag);
    }

    protected void func_70184_a(RayTraceResult mop) {
        if (!this.canBeCollided || this.field_70170_p.field_72995_K) {
            return;
        }
        if (mop.field_72313_a == RayTraceResult.Type.ENTITY) {
            if (mop.field_72308_g instanceof EntityPlayer && !GrappleHooks.allowGrapplingPlayers || mop.field_72308_g instanceof EntityEnderCrystal || !GrappleHooks.allowGrapplingEntities || mop.field_72308_g instanceof EntityItem && !GrappleHooks.allowGrapplingItems) {
                return;
            }
            if (mop.field_72308_g == this.field_70192_c) {
                return;
            }
            this.setReturning();
            Entity entity = mop.field_72308_g;
            entity.func_184220_m((Entity)this);
            this.canBeCollided = false;
            this.setPullThrower(false);
            return;
        }
        if (!this.pullThrower() && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
            if (!this.field_70170_p.func_180495_p(mop.func_178782_a()).func_177230_c().func_149688_o(null).func_76220_a()) {
                return;
            }
            this.setPullThrower(true);
            this.setPullPosX((float)mop.field_72307_f.field_72450_a);
            this.setPullPosY((float)mop.field_72307_f.field_72448_b);
            this.setPullPosZ((float)mop.field_72307_f.field_72449_c);
            this.func_70107_b(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c);
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            this.radio = this.func_70032_d((Entity)this.field_70192_c);
            this.field_70122_E = true;
            this.maxY = this.field_70192_c.field_70163_u;
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.func_85052_h().func_70005_c_());
        buffer.writeDouble(this.grapplingDistance);
        buffer.writeDouble(this.grapplingStrength);
        buffer.writeByte((int)this.type);
        buffer.writeFloat(this.throwingStrength);
    }

    public boolean func_70039_c(NBTTagCompound tagCompund) {
        return false;
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.field_70192_c = this.field_70170_p.func_72924_a(ByteBufUtils.readUTF8String((ByteBuf)additionalData));
        this.grapplingDistance = additionalData.readDouble();
        this.grapplingStrength = additionalData.readDouble();
        this.type = additionalData.readByte();
        this.throwingStrength = additionalData.readFloat();
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void setReturning() {
        this.setPullPosX((float)this.field_70165_t);
        this.setPullPosY((float)this.field_70163_u);
        this.setPullPosZ((float)this.field_70161_v);
        this.isReturning = true;
    }

    public boolean func_70067_L() {
        return true;
    }
}

