/*
 * Decompiled with CFR 0.152.
 */
package de.intektor.grapple_hooks.event;

import de.intektor.grapple_hooks.GrappleHooks;
import de.intektor.grapple_hooks.capability.GrappleCapabiltiyProvider;
import de.intektor.grapple_hooks.item.ItemGrapple;
import de.intektor.grapple_hooks.server.IGrappleCapability;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GrappleEventHandler {
    @SubscribeEvent
    public void registerPlayerCapability(AttachCapabilitiesEvent.Entity event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            event.addCapability(new ResourceLocation("grapple_hooks", "GrappleCapability"), (ICapabilityProvider)new GrappleCapabiltiyProvider());
        }
    }

    @SubscribeEvent
    public void playerLoggout(PlayerEvent.PlayerLoggedOutEvent event) {
        this.finishGrappleStuff(event.player);
    }

    @SubscribeEvent
    public void playerDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            this.finishGrappleStuff(player);
        }
    }

    private void finishGrappleStuff(EntityPlayer player) {
        IGrappleCapability cap;
        if (player.hasCapability(GrappleHooks.GRAPPLE_CAP, null) && (cap = (IGrappleCapability)player.getCapability(GrappleHooks.GRAPPLE_CAP, null)).getHook() != null) {
            cap.getHook().func_70106_y();
        }
    }

    @SubscribeEvent
    public void playerUpdate(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        if (player.hasCapability(GrappleHooks.GRAPPLE_CAP, null)) {
            IGrappleCapability cap = (IGrappleCapability)player.getCapability(GrappleHooks.GRAPPLE_CAP, null);
            if (!(player.func_184586_b(EnumHand.MAIN_HAND) != null && player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemGrapple || cap.getHook() == null)) {
                cap.getHook().func_70106_y();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void modelBakeEvent(ModelBakeEvent event) {
    }
}

