/*
 * Decompiled with CFR 0.152.
 */
package de.intektor.grapple_hooks.item;

import de.intektor.grapple_hooks.GrappleHooks;
import de.intektor.grapple_hooks.GrapplePlayerProperties;
import de.intektor.grapple_hooks.entity.EntityGrapplingHook;
import de.intektor.grapple_hooks.network.MessageToClient;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;

public abstract class ItemGrapple
extends Item {
    protected String name;

    public ItemGrapple(String name) {
        this.func_77655_b("grapple_hooks_" + name);
        this.func_77637_a(GrappleHooks.GRAPPLE_HOOKS_CREATIVE_TAB);
        this.func_77625_d(1);
        this.func_77656_e(this.getDurability());
        this.name = name;
        GameRegistry.registerItem((Item)this, (String)this.func_77658_a());
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        stack.func_77982_d(new NBTTagCompound());
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entity, int itemSlot, boolean isSelected) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return stack;
        }
        EntityGrapplingHook grapple = GrapplePlayerProperties.get(player).getHook();
        if (grapple == null || grapple.field_70128_L || grapple.func_70032_d((Entity)player) < 5.0f && player.func_70093_af()) {
            if (grapple != null && !grapple.field_70128_L) {
                grapple.field_70128_L = true;
            }
            if (!world.field_72995_K) {
                this.addGrapple(world, player);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                }
            }
        } else {
            GrapplePlayerProperties.get(player).getHook().setReturning();
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75100_b = false;
            }
        }
        return stack;
    }

    public void addGrapple(World world, EntityPlayer player) {
        EntityGrapplingHook grapplingHook = new EntityGrapplingHook(world, player, this.getGrapplingDistance(), this.getGrapplingStrength(), this.getType(), this.getThrowingStrength());
        world.func_72838_d((Entity)grapplingHook);
        GrapplePlayerProperties.get(player).setHook(grapplingHook);
        GrappleHooks.network.sendTo((IMessage)new MessageToClient.GrappleShot(grapplingHook), (EntityPlayerMP)player);
    }

    public abstract double getGrapplingDistance();

    public abstract double getGrapplingStrength();

    public abstract float getThrowingStrength();

    public abstract int getDurability();

    public abstract byte getType();

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> list, boolean advanced) {
        list.add(EnumChatFormatting.BLUE + I18n.func_135052_a((String)"tooltip.grapple_hooks_grapple_distance_information.text", (Object[])new Object[]{this.getGrapplingDistance()}));
        list.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"tooltip.grapple_hooks_grappling_strength_information.text", (Object[])new Object[]{this.getGrapplingStrength()}));
        list.add(EnumChatFormatting.DARK_RED + I18n.func_135052_a((String)"tooltip.grapple_hooks_grappling_throwing_power_information.text", (Object[])new Object[]{Float.valueOf(this.getThrowingStrength())}));
    }

    public static class CreativeGrapple
    extends ItemGrapple {
        public CreativeGrapple() {
            super("Creative Grapple");
        }

        @Override
        public double getGrapplingDistance() {
            return 200.0;
        }

        @Override
        public double getGrapplingStrength() {
            return 4.0;
        }

        @Override
        public float getThrowingStrength() {
            return 3.0f;
        }

        @Override
        public int getDurability() {
            return Integer.MAX_VALUE;
        }

        @Override
        public byte getType() {
            return 6;
        }

        public EnumRarity func_77613_e(ItemStack stack) {
            return EnumRarity.EPIC;
        }
    }

    public static class IridiumGrapple
    extends ItemGrapple {
        public IridiumGrapple() {
            super("Iridium Grapple");
        }

        @Override
        public double getGrapplingDistance() {
            return 75.0;
        }

        @Override
        public double getGrapplingStrength() {
            return 2.7;
        }

        @Override
        public float getThrowingStrength() {
            return 3.0f;
        }

        @Override
        public int getDurability() {
            return 750;
        }

        @Override
        public byte getType() {
            return 7;
        }

        public EnumRarity func_77613_e(ItemStack stack) {
            return EnumRarity.EPIC;
        }
    }

    public static class SpiderGrapple
    extends ItemGrapple {
        public SpiderGrapple() {
            super("Spider Grapple");
        }

        @Override
        public double getGrapplingDistance() {
            return 60.0;
        }

        @Override
        public double getGrapplingStrength() {
            return 3.0;
        }

        @Override
        public float getThrowingStrength() {
            return 3.0f;
        }

        @Override
        public int getDurability() {
            return 1000;
        }

        @Override
        public byte getType() {
            return 5;
        }

        public EnumRarity func_77613_e(ItemStack stack) {
            return EnumRarity.EPIC;
        }
    }

    public static class GoldenGrapple
    extends ItemGrapple {
        public GoldenGrapple() {
            super("Golden Grapple");
        }

        @Override
        public double getGrapplingDistance() {
            return 55.0;
        }

        @Override
        public double getGrapplingStrength() {
            return 2.7;
        }

        @Override
        public float getThrowingStrength() {
            return 2.3f;
        }

        @Override
        public int getDurability() {
            return 25;
        }

        @Override
        public byte getType() {
            return 4;
        }
    }

    public static class DiamondGrapple
    extends ItemGrapple {
        public DiamondGrapple() {
            super("Diamond Grapple");
        }

        @Override
        public double getGrapplingDistance() {
            return 40.0;
        }

        @Override
        public double getGrapplingStrength() {
            return 2.5;
        }

        @Override
        public float getThrowingStrength() {
            return 2.0f;
        }

        @Override
        public int getDurability() {
            return 512;
        }

        @Override
        public byte getType() {
            return 3;
        }
    }

    public static class IronGrapple
    extends ItemGrapple {
        public IronGrapple() {
            super("Iron Grapple");
        }

        @Override
        public double getGrapplingDistance() {
            return 30.0;
        }

        @Override
        public double getGrapplingStrength() {
            return 2.0;
        }

        @Override
        public float getThrowingStrength() {
            return 1.5f;
        }

        @Override
        public int getDurability() {
            return 120;
        }

        @Override
        public byte getType() {
            return 2;
        }
    }

    public static class StoneGrapple
    extends ItemGrapple {
        public StoneGrapple() {
            super("Stone Grapple");
        }

        @Override
        public double getGrapplingDistance() {
            return 12.5;
        }

        @Override
        public double getGrapplingStrength() {
            return 1.9;
        }

        @Override
        public float getThrowingStrength() {
            return 1.2f;
        }

        @Override
        public int getDurability() {
            return 60;
        }

        @Override
        public byte getType() {
            return 1;
        }
    }

    public static class WoodenGrapple
    extends ItemGrapple {
        public WoodenGrapple() {
            super("Wooden Grapple");
        }

        @Override
        public double getGrapplingDistance() {
            return 7.5;
        }

        @Override
        public double getGrapplingStrength() {
            return 1.75;
        }

        @Override
        public float getThrowingStrength() {
            return 1.0f;
        }

        @Override
        public int getDurability() {
            return 30;
        }

        @Override
        public byte getType() {
            return 0;
        }
    }
}

