/*
 * Decompiled with CFR 0.152.
 */
package de.intektor.grapple_hooks.event;

import de.intektor.grapple_hooks.GrapplePlayerProperties;
import de.intektor.grapple_hooks.item.ItemGrapple;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GrappleEventHandler {
    @SubscribeEvent
    public void entityConstructing(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer) {
            GrapplePlayerProperties.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void playerLoggout(PlayerEvent.PlayerLoggedOutEvent event) {
        this.finishGrappleStuff(event.player);
    }

    @SubscribeEvent
    public void playerDeath(LivingDeathEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            this.finishGrappleStuff(player);
        }
    }

    private void finishGrappleStuff(EntityPlayer player) {
        if (GrapplePlayerProperties.get(player).getHook() != null) {
            GrapplePlayerProperties.get(player).getHook().func_70106_y();
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75100_b = false;
            }
        }
    }

    @SubscribeEvent
    public void playerUpdate(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = event.player;
        if (!(GrapplePlayerProperties.get(player).getHook() == null || player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof ItemGrapple)) {
            GrapplePlayerProperties.get(player).getHook().func_70106_y();
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71075_bZ.field_75100_b = false;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void modelBakeEvent(ModelBakeEvent event) {
    }
}

