/*
 * Decompiled with CFR 0.152.
 */
package de.intektor.grapple_hooks.entity;

import de.intektor.grapple_hooks.GrappleHooks;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityGrapplingHook
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    public EntityPlayer field_70192_c;
    public boolean isReturning;
    public double grapplingDistance;
    public double grapplingStrength;
    public double radio;
    private float throwingStrength;
    protected Point3d startPoint;
    protected byte type;
    public static final int TYPE_WOODEN_HOOK = 0;
    public static final int TYPE_STONE_HOOK = 1;
    public static final int TYPE_IRON_HOOK = 2;
    public static final int TYPE_DIAMOND_HOOK = 3;
    public static final int TYPE_GOLDEN_HOOK = 4;
    public static final int TYPE_SPIDER_HOOK = 5;
    public static final int TYPE_CREATIVE_HOOK = 6;
    public static final int TYPE_IRIDIUM_GRAPPLE = 7;
    double maxY;
    int spinX = 1;
    boolean canBeCollided = true;

    public EntityGrapplingHook(World worldIn, EntityPlayer thrower, double grapplingDistance, double grapplingStrength, byte type, float throwingStrength) {
        super(worldIn, (EntityLivingBase)thrower);
        this.field_70192_c = thrower;
        this.grapplingDistance = grapplingDistance;
        this.grapplingStrength = grapplingStrength;
        this.type = type;
        this.throwingStrength = throwingStrength;
        this.field_70159_w *= (double)throwingStrength;
        this.field_70181_x *= (double)throwingStrength;
        this.field_70179_y *= (double)throwingStrength;
    }

    public EntityGrapplingHook(World world) {
        super(world);
    }

    public void func_70071_h_() {
        Vector3d vec;
        Vec3 pVec;
        if (this.startPoint == null) {
            this.startPoint = new Point3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        Point3d point3d = new Point3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.startPoint.distance(point3d) > this.grapplingDistance) {
            this.setReturning();
        }
        if (this.isReturning && this.func_70032_d((Entity)this.field_70192_c) <= 2.0f) {
            this.func_70076_C();
        }
        if (!this.isReturning) {
            if (this.type != 5) {
                if (this.pullThrower() && this.field_70192_c != null) {
                    pVec = this.field_70192_c.func_174791_d().func_178786_a(0.0, (double)-1.3f, 0.0);
                    vec = new Vector3d(this.getPullPosX() - pVec.field_72450_a, this.getPullPosY() - pVec.field_72448_b, this.getPullPosZ() - pVec.field_72449_c);
                    vec.normalize();
                    double distance = this.func_174791_d().func_72438_d(pVec);
                    float f = distance > this.grapplingStrength ? (float)this.grapplingStrength : 0.5f;
                    this.field_70192_c.field_70159_w = vec.x * (double)f;
                    this.field_70192_c.field_70181_x = vec.y * (double)f;
                    this.field_70192_c.field_70179_y = vec.z * (double)f;
                    this.field_70192_c.field_70143_R = 0.0f;
                }
            } else if (!this.field_70128_L && this.pullThrower()) {
                double distance = this.func_70011_f(this.field_70192_c.field_70165_t, this.field_70192_c.field_70163_u, this.field_70192_c.field_70161_v);
                if (distance >= this.radio) {
                    this.field_70192_c.field_71075_bZ.field_75100_b = true;
                    this.field_70192_c.field_70143_R = 0.0f;
                    double dX = this.field_70165_t - this.field_70192_c.field_70165_t;
                    double dY = this.field_70163_u - this.field_70192_c.field_70163_u;
                    double atan = Math.atan2(-dY, -dX);
                    this.field_70192_c.field_70165_t = this.field_70165_t + this.radio * Math.cos(atan);
                    this.field_70192_c.field_70163_u = this.field_70163_u + this.radio * Math.sin(atan);
                    if (this.field_70192_c.field_70163_u + 1.0 > this.maxY) {
                        this.spinX = this.spinX == 0 ? 1 : 0;
                    } else {
                        this.field_70192_c.field_70159_w = this.spinX;
                    }
                    this.field_70192_c.field_70159_w = -1.0;
                } else if (distance + 0.3 < this.radio) {
                    this.field_70192_c.field_71075_bZ.field_75100_b = false;
                }
            }
        } else {
            this.setPullPosX((float)this.field_70165_t);
            this.setPullPosY((float)this.field_70163_u);
            this.setPullPosZ((float)this.field_70161_v);
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            pVec = this.field_70192_c.func_174791_d().func_178786_a(0.0, (double)-1.3f, 0.0);
            vec = new Vector3d(this.getPullPosX() - pVec.field_72450_a, this.getPullPosY() - pVec.field_72448_b, this.getPullPosZ() - pVec.field_72449_c);
            vec.normalize();
            float f = 2.0f;
            this.field_70159_w = -vec.x * (double)f;
            this.field_70181_x = -vec.y * (double)f;
            this.field_70179_y = -vec.z * (double)f;
        }
        super.func_70071_h_();
        Vec3 vec3 = new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3 vec31 = new Vec3(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        MovingObjectPosition movingobjectposition = this.field_70170_p.func_72933_a(vec3, vec31);
        vec3 = new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec31 = new Vec3(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (!this.field_70170_p.field_72995_K) {
            EntityItem entity = null;
            List list = this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d0 = 0.0;
            if (movingobjectposition != null) {
                vec31 = new Vec3(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
            }
            for (int j = 0; j < list.size(); ++j) {
                double d1;
                EntityItem entity1 = (EntityItem)list.get(j);
                float f = 0.3f;
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72314_b((double)f, (double)f, (double)f);
                MovingObjectPosition movingobjectposition1 = axisalignedbb.func_72327_a(vec3, vec31);
                if (movingobjectposition1 != null && ((d1 = vec3.func_72436_e(movingobjectposition1.field_72307_f)) < d0 || d0 == 0.0)) {
                    entity = entity1;
                    d0 = d1;
                }
                if (entity == null) continue;
                movingobjectposition = new MovingObjectPosition(entity);
            }
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && this.field_70170_p.func_180495_p(movingobjectposition.func_178782_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(movingobjectposition.func_178782_a());
            } else {
                this.func_70184_a(movingobjectposition);
            }
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(10, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(11, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(12, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(13, (Object)0);
    }

    public double getPullPosX() {
        return this.field_70180_af.func_111145_d(10);
    }

    public double getPullPosY() {
        return this.field_70180_af.func_111145_d(11);
    }

    public double getPullPosZ() {
        return this.field_70180_af.func_111145_d(12);
    }

    public void setPullPosX(float pos) {
        this.field_70180_af.func_75692_b(10, (Object)Float.valueOf(pos));
    }

    public void setPullPosY(float pos) {
        this.field_70180_af.func_75692_b(11, (Object)Float.valueOf(pos));
    }

    public void setPullPosZ(float pos) {
        this.field_70180_af.func_75692_b(12, (Object)Float.valueOf(pos));
    }

    public boolean pullThrower() {
        return this.field_70180_af.func_75683_a(13) != 0;
    }

    public void setPullThrower(boolean flag) {
        this.field_70180_af.func_75692_b(13, (Object)(flag ? (byte)1 : 0));
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        if (!this.canBeCollided || this.field_70170_p.field_72995_K) {
            return;
        }
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
            if (mop.field_72308_g instanceof EntityPlayer && !GrappleHooks.allowGrapplingPlayers || mop.field_72308_g instanceof EntityEnderCrystal || !GrappleHooks.allowGrapplingEntities || mop.field_72308_g instanceof EntityItem && !GrappleHooks.allowGrapplingItems) {
                return;
            }
            if (mop.field_72308_g == this.field_70192_c) {
                return;
            }
            this.setReturning();
            Entity entity = mop.field_72308_g;
            entity.func_70078_a((Entity)this);
            this.canBeCollided = false;
            this.setPullThrower(false);
            return;
        }
        if (!this.pullThrower() && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            if (!this.field_70170_p.func_180495_p(mop.func_178782_a()).func_177230_c().func_149688_o().func_76220_a()) {
                return;
            }
            this.setPullThrower(true);
            this.setPullPosX((float)mop.field_72307_f.field_72450_a);
            this.setPullPosY((float)mop.field_72307_f.field_72448_b);
            this.setPullPosZ((float)mop.field_72307_f.field_72449_c);
            this.func_70107_b(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c);
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            this.radio = this.func_70032_d((Entity)this.field_70192_c);
            this.field_70122_E = true;
            this.maxY = this.field_70192_c.field_70163_u;
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.func_85052_h().func_70005_c_());
        buffer.writeDouble(this.grapplingDistance);
        buffer.writeDouble(this.grapplingStrength);
        buffer.writeByte((int)this.type);
        buffer.writeFloat(this.throwingStrength);
    }

    public boolean func_70039_c(NBTTagCompound tagCompund) {
        return false;
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.field_70192_c = this.field_70170_p.func_72924_a(ByteBufUtils.readUTF8String((ByteBuf)additionalData));
        this.grapplingDistance = additionalData.readDouble();
        this.grapplingStrength = additionalData.readDouble();
        this.type = additionalData.readByte();
        this.throwingStrength = additionalData.readFloat();
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void setReturning() {
        this.setPullPosX((float)this.field_70165_t);
        this.setPullPosY((float)this.field_70163_u);
        this.setPullPosZ((float)this.field_70161_v);
        this.isReturning = true;
    }

    public boolean func_70067_L() {
        return true;
    }
}

