/*
 * Decompiled with CFR 0.152.
 */
package de.intektor.grapple_hooks;

import de.intektor.grapple_hooks.entity.EntityGrapplingHook;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IExtendedEntityProperties;

public class GrapplePlayerProperties
implements IExtendedEntityProperties {
    public static final String EXT_PROP_NAME = "ExtendedPlayerGrapple";
    private final EntityPlayer player;
    private EntityGrapplingHook hook;
    private double circleAngleX;
    private double circleAngleZ;
    private double startY;

    public GrapplePlayerProperties(EntityPlayer player) {
        this.player = player;
    }

    public static void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new GrapplePlayerProperties(player));
    }

    public static GrapplePlayerProperties get(EntityPlayer player) {
        return (GrapplePlayerProperties)player.getExtendedProperties(EXT_PROP_NAME);
    }

    public void saveNBTData(NBTTagCompound compound) {
        compound.func_74778_a("HookUUID", this.hook != null ? this.hook.func_110124_au().toString() : "");
    }

    public void loadNBTData(NBTTagCompound compound) {
        WorldServer world = (WorldServer)this.player.field_70170_p;
        this.hook = (EntityGrapplingHook)world.func_175733_a(UUID.fromString(compound.func_74779_i("HookUUID")));
    }

    public void init(Entity entity, World world) {
    }

    public EntityGrapplingHook getHook() {
        return this.hook;
    }

    public void setHook(EntityGrapplingHook hook) {
        this.hook = hook;
    }

    public void setCircleAngleX(double circleAngle) {
        this.circleAngleX = circleAngle;
    }

    public double getCircleAngleX() {
        return this.circleAngleX;
    }

    public void addCircleAngleX(double amt) {
        this.circleAngleX += amt;
        this.circleAngleX %= Math.PI * 2;
    }

    public void setCircleAngleZ(double circleAngle) {
        this.circleAngleZ = circleAngle;
    }

    public double getCircleAngleZ() {
        return this.circleAngleZ;
    }

    public void addCircleAngleZ(double amt) {
        this.circleAngleZ += amt;
        this.circleAngleZ %= Math.PI * 2;
    }

    public void setStartY(double startY) {
        this.startY = startY;
    }

    public double getStartY() {
        return this.startY;
    }
}

